<?php
/**
 * discussions app
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
require('kernal.php');

// check access level
AccessLevel('restricted');

// valid inputs
$valid['do'] = array('new', 'edit');
if(!in_array($_GET['do'], $valid['do'])) {
    SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
}

// start new discussion
if($_GET['do'] == "new") {
    
    // page header
    PageHeader($translate->__("Write a Discussion"));
    
    if($_POST['submit']) {
        
        // sanitize title
        $title = Sanitize($_POST['title']);
        
        // sanitize body
        require_once 'libs/HTMLPurifier/HTMLPurifier.auto.php';
        $config = HTMLPurifier_Config::createDefault();
        // configuration
        $config->set('Core.Encoding', 'UTF-8');
        $config->set('HTML.Doctype', 'XHTML 1.0 Transitional');
        $config->set('HTML.AllowedAttributes', '*.style, align');
        $config->set('HTML.AllowedElements', 'p, span, b, i, u, ul, ol, li, blockquote, br');
        $config->set('CSS.AllowedProperties', 'font-weight, font-style, text-decoration');
        $purifier = new HTMLPurifier($config);
        $body = (get_magic_quotes_gpc())? stripslashes($_POST['body']) : $_POST['body'];
        $body = Sanitize($purifier->purify($body));
        
        // check if empty
        if(!IsEmpty($title) && !IsEmpty($body)) {
            // check title length
            if(strlen($title) < 256) {
                // check body length
                if(strlen($body) <= 10240) {
                    // insert app post
                    $db->query(sprintf("INSERT INTO posts_discussions (Title, Text) VALUES (%s, %s)", SafeSQL($title), SafeSQL($body) )) or SQLError();
                    $postId = $db->insert_id;
                    // insert post
                    $db->query(sprintf("INSERT INTO posts (UserID, PostType, PostID, Time) VALUES (%s, 5, %s, %s)", Secure($userArray['UserID'], 'int'), Secure($postId, 'int'), Secure($now) )) or SQLError();
                    // update user posts
                    $db->query(sprintf("UPDATE users SET UserPosts = UserPosts + 1 WHERE UserID = %s", Secure($userArray['UserID'], 'int') )) or SQLError();
                    // redirect
                    header('Location: '.SITE_URL.'/discussion/'.$postId);
                }else {
                    $error = "Your body is too long. The maximum length is 10240 characters.";
                }
            }else {
                $error = "Your title is too long. The maximum length is 255 characters.";
            }
        }else {
            $error = "Please provide a title and body. Title and body are required to publish a discussion.";
        }
    }
    
// edit discussion
}elseif($_GET['do'] == "edit") {
    
    // check data ID
    if(!isset($_GET['id']) OR $_GET['id'] == 0 OR $_GET['id'] == "") {
        SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
    }else {
        // check if valid discussion & user authorized to edit it
        $getPost = $db->query(sprintf("SELECT discussion.*, post.*, user.UserFirstName, user.UserLastName, user.UserAvatarPath FROM posts_discussions discussion INNER JOIN posts post ON discussion.ID = post.PostID AND post.PostType = 5 INNER JOIN users user ON post.UserID = user.UserID WHERE post.PostID = %s AND post.UserID = %s", SafeSQL($_GET['id'], 'int'), SafeSQL($userArray['UserID'], 'int') )) or SQLError();
        if($getPost->num_rows == 0) {
            SystemError("This content is currently unavailable", "The page you requested cannot be displayed right now. It may be temporarily unavailable, the link you clicked on may have expired, or you may not have permission to view this page.");
        }
        $post = $getPost->fetch_array(MYSQLI_ASSOC);
        $post['Text'] = Parse($post['Text']);
        $post['Text'] = DecodeText($post['Text']);
        $smarty->assign('post', $post);
    }
    
    // page header
    PageHeader($translate->__("Edit Discussion"));
    
    if($_POST['submit']) {
        
        // sanitize title
        $title = Sanitize($_POST['title']);
        
        // sanitize body
        require_once 'libs/HTMLPurifier/HTMLPurifier.auto.php';
        $config = HTMLPurifier_Config::createDefault();
        // configuration
        $config->set('Core.Encoding', 'UTF-8');
        $config->set('HTML.Doctype', 'XHTML 1.0 Transitional');
        $config->set('HTML.AllowedAttributes', '*.style, align');
        $config->set('HTML.AllowedElements', 'p, span, b, i, u, ul, ol, li, blockquote, br');
        $config->set('CSS.AllowedProperties', 'font-weight, font-style, text-decoration');
        $purifier = new HTMLPurifier($config);
        $body = (get_magic_quotes_gpc())? stripslashes($_POST['body']) : $_POST['body'];
        $body = Sanitize($purifier->purify(stripslashes($body)));
        
        // check if empty
        if(!IsEmpty($title) && !IsEmpty($body)) {
            // check title length
            if(strlen($title) < 256) {
                // check body length
                if(strlen($body) <= 10240) {
                    // update discussion
                    $db->query(sprintf("UPDATE posts_discussions SET Title = %s, Text = %s WHERE ID = %s", SafeSQL($title), SafeSQL($body), SafeSQL($_GET['id'], 'int') )) or SQLError();
                    // redirect
                    header('Location: '.SITE_URL.'/discussion/'.$_GET['id']);
                }else {
                    $error = "Your body is too long. The maximum length is 10240 characters.";
                }
            }else {
                $error = "Your title is too long. The maximum length is 255 characters.";
            }
        }else {
            $error = "Please provide a title and body. Title and body are required to publish a discussion.";
        }
    }
    
}

// assign varibles
$smarty->assign('do', $_GET['do']);
$smarty->assign('id', $_GET['id']);
$smarty->assign('title', $title);
$smarty->assign('body', $body);
$smarty->assign('error', $error);

// page footer
PageFooter("editdiscussion");

?>