<?php
/**
 * photos|videos app
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
require('kernal.php');

// check access level
AccessLevel('restricted');

// check data ID
if(!isset($_GET['id']) || $_GET['id'] == 0 || $_GET['id'] == "") {
    SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
}else {
    
    // valid inputs
    $valid['m'] = array('photos', 'videos');
    $valid['t'] = array('add', 'edit', 'info');
    if(!in_array($_GET['m'], $valid['m'])) {
        SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
    }
    if(!in_array($_GET['t'], $valid['t'])) {
        SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
    }
    
    // prepare tables
    if($_GET['m'] == "photos") {
        $postType = 3;
        $postTable = 'posts_photos';
        $albumTable = 'posts_photos_albums';
        $sourceTable = 'posts_photos_sources';
    }else {
        $postType = 4;
        $postTable = 'posts_videos';
        $albumTable = 'posts_videos_albums';
        $sourceTable = 'posts_videos_sources';
    }
    
    // get album
    $getAlbum = $db->query(sprintf("SELECT * FROM %s WHERE ID = %s", $albumTable, Secure($_GET['id'], 'int') )) or SQLError();
    if($getAlbum->num_rows == 0) {
        SystemError($translate->__("This content is currently unavailable"), $translate->__("The page you requested cannot be displayed right now. It may be temporarily unavailable, the link you clicked on may have expired, or you may not have permission to view this page."));
    }
    $album = $getAlbum->fetch_array(MYSQLI_ASSOC);
    
    // check if user authorized
    if($album['UserID'] != $userArray['UserID'] && $userArray['UserGroup'] == 3) {
        SystemError($translate->__("This content is currently unavailable"), $translate->__("The page you requested cannot be displayed right now. It may be temporarily unavailable, the link you clicked on may have expired, or you may not have permission to view this page."));
    }
    
}

// page header
PageHeader("Edit Album - ".$album['Title']);

// check if published
if($album['IsWall'] == 'N') {
    $checkPost = $db->query(sprintf("SELECT ID FROM %s WHERE IsAlbum = 'Y' AND MediaID = %s", $postTable, SafeSQL($album['ID'], 'int') )) or SQLError();
    if($checkPost->num_rows == 0) {
        $album['published'] = false;
    }else {
        $album['published'] = true;
    }
}else {
    $album['published'] = true;
}

// add tab
if($_GET['t'] == 'add') {
    
    // generate upload secret
    $_SESSION['secret'] = md5(time()*rand(1, 9999));
    $smarty->assign('secret', $_SESSION['secret']);
    
    if($_POST['submit']) {
        // check if wall album
        if($album['IsWall'] == 'N') {
            $counter = 0;
            if($_GET['m'] == "photos") {
                for($i=1; $i<=5; $i++) {
                    if(isset($_POST['thumb'][$i]['src'])) {
                        if(isset($_POST['thumb'][$i]['thumb'])) {
                            $text = Sanitize($_POST['thumb'][$i]['txt']);
                            $source = Sanitize($_POST['thumb'][$i]['src']);
                            $thumbnail = Sanitize($_POST['thumb'][$i]['thumb']);
                            $db->query(sprintf("INSERT INTO %s (AlbumID, Source, Thumbnail, Text, Time) VALUES (%s, %s, %s, %s, %s)", $sourceTable, SafeSQL($album['ID'], 'int'), SafeSQL($source), SafeSQL($thumbnail), SafeSQL($text), $now )) or SQLError();
                            $sourcs[$i] = $db->insert_id;
                            $counter++;
                        }
                    }
                }
            }else {
                for($i=1; $i<=5; $i++) {
                    if(isset($_POST['thumb'][$i]['id']) && isset($_POST['thumb'][$i]['type']) && isset($_POST['thumb'][$i]['thumb']) && isset($_POST['thumb'][$i]['txt'])) {
                        $id = Sanitize($_POST['thumb'][$i]['id']);
                        $type = Sanitize($_POST['thumb'][$i]['type']);
                        $thumbnail = Sanitize($_POST['thumb'][$i]['thumb']);
                        $text = Sanitize($_POST['thumb'][$i]['txt']);
                        $db->query(sprintf("INSERT INTO %s (AlbumID, Source, Type, Thumbnail, Text, Time) VALUES (%s, %s, %s, %s, %s, %s)", $sourceTable, SafeSQL($album['ID'], 'int'), SafeSQL($id), SafeSQL($type), SafeSQL($thumbnail), SafeSQL($text), $now )) or SQLError();
                        $sourcs[$i] = $db->insert_id;
                        $counter++;
                    }
                }
            }
            if($counter > 0) {
                // prepare album cover
                if(isset($_POST['albumCover']) && $_POST['albumCover'] != 'undefined') {
                    $cover = $sourcs[$_POST['albumCover']];
                }else {
                    $cover = ($album['ThumbnailID'] == 0)? 0 : $album['ThumbnailID'];
                }
                // update album
                $db->query(sprintf("UPDATE %s SET Time = %s, ThumbnailID = %s, New = %s, Total = Total + %s WHERE ID = %s", $albumTable, $now, SafeSQL($cover, 'int'), $counter, $counter, SafeSQL($album['ID'], 'int') )) or SQLError();
                if(!$album['published']) {
                    // insert media post
                    $db->query(sprintf("INSERT INTO %s (IsAlbum, MediaID) VALUES ('Y', %s)", $postTable, SafeSQL($album['ID'], 'int') )) or SQLError();
                    $postId = $db->insert_id;
                    // insert post feed
                    $db->query(sprintf("INSERT INTO posts (UserID, PostType, PostID, Time) VALUES (%s, %s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), $now )) or SQLError();
                }
                header('Location: '.SITE_URL.'/albums/'.$_GET['m'].'/'.$album['ID'].'/saved/');
            }else {
                $error = 'Please enter a valid (non-empty) album '.$_GET['m'].'.';
            }
        }else {
            $error = 'You can not add multiple '.$_GET['m'].' to your wall album';
        }
    }
}elseif ($_GET['t'] == 'edit') {
    // get all album resources
    if($album['Total'] > 0) {
        $getResources = $db->query(sprintf("SELECT * FROM %s WHERE AlbumID = %s", $sourceTable, SafeSQL($album['ID'], 'int') )) or SQLError();
        while($resource = $getResources->fetch_array(MYSQLI_ASSOC)) {
            $album['resources'][] = $resource;
        }
    }
    if($_POST['submit']) {
        foreach($_POST['thumbText'] AS $key => $value) {
            $value = Sanitize($value);
            $db->query(sprintf("UPDATE %s SET Text = %s WHERE ID = %s", $sourceTable, SafeSQL($value), SafeSQL($key, 'int') )) or SQLError();
        }
        if(isset($_POST['albumCover'])) {
            $cover = $_POST['albumCover'];
        }else {
            $cover = ($album['ThumbnailID'] == 0)? 0 : $album['ThumbnailID'];
        }
        $db->query(sprintf("UPDATE %s SET ThumbnailID = %s WHERE ID = %s", $albumTable, SafeSQL($cover, 'int'), SafeSQL($album['ID']) )) or SQLError();
        header('Location: '.SITE_URL.'/albums/'.$_GET['m'].'/'.$album['ID'].'/saved/');
    }
}elseif ($_GET['t'] == 'info') {
    if($_POST['submit']) {
        // check if wall album
        if($album['IsWall'] == 'N') {
            // check if empty
            if(!IsEmpty($_POST['title'])) {
                // check length
                if(strlen($_POST['title']) <= 255) {
                    if(strlen($_POST['text']) <= 1024) {
                        // sanitize inputs
                        $_POST['title'] = Sanitize($_POST['title']);
                        $_POST['text'] = Sanitize($_POST['text']);
                        // update album
                        $db->query(sprintf("UPDATE %s SET Title = %s, Text = %s WHERE ID = %s", $albumTable, SafeSQL($_POST['title']), SafeSQL($_POST['text']), SafeSQL($album['ID'], 'int') )) or SQLError();
                        if($album['published']) {
                            header('Location: '.SITE_URL.'/albums/'.$_GET['m'].'/'.$album['ID'].'/saved/');
                        }else {
                            header('Location: '.SITE_URL.'/editalbum/'.$_GET['m'].'/'.$album['ID'].'/add/');
                        }
                    }else {
                        $error = 'Your description is too long. The maximum length is 1024 characters.';
                    }
                }else {
                    $error = 'Your title is too long. The maximum length is 255 characters.';
                }
            }else {
                $error = 'Please enter a valid (non-empty) album title.';
            }
        }else {
            $error = 'You can not edit your wall album';
        }
    }
}

// assign varibles
$smarty->assign('album', $album);
$smarty->assign('media', $_GET['m']);
$smarty->assign('tab', $_GET['t']);
$smarty->assign('error', $error);
    
// page footer
PageFooter("editalbum");

?>