{include file='headinclude.tpl'}
{include file='header.tpl'}

<!-- Content -->
<div class="contentWrapper">
    <div class="content">
        
        <div class="pageContent">
            <div class="signPageContent">
                
                <div class="signHeaderWrapper">
                    <h3 class="mb5 white">{$translate->__("Forgot your password?")}</h3>
                    <p class="">{$translate->__("We will send password reset instructions to the email address associated with your account")}.</p>
                </div>
                
                <div class="signContentWrapper">
                    
                    {if $error != ""}<div class="errorContianer">{$error}</div>{/if}
                    {if $highlight != ""}<div class="highlightContianer">{$highlight}</div>{/if}
                    
                    <!-- reCaptcha theme -->
                    <script type="text/javascript">
                        var RecaptchaOptions = {
                            theme : 'custom',
                            custom_theme_widget: 'recaptcha_widget'
                        };
                    </script>
                    <!-- reCaptcha theme -->
                    
                    <form action="{$SITE_URL}/recover/" method="post">
                        <table class="signInputTable mt10">
                            <tr>
                                <td class="label">{$translate->__("Email")}:</td>
                                <td class="input fs11">
                                    <input class="uiInput active" type="text" name="email" value="{$email}" tabindex="1" />
                                    <p class="mt5">{$translate->__("Please type your email address above")}.</p>
                                </td>
                            </tr>
                            <tr>
                                <td class="label"></td>
                                <td class="input">
                                    <!-- reCaptcha -->
                                    <div id="captchaWidget">
                                        <div id="recaptcha_widget" class="fs11 pb10 mb10" style="border-bottom: 1px solid #3c3c3c; display:none">
                                            <p class="mb10 pb5 fs12" style="border-bottom: 1px solid #3c3c3c;">{$translate->__("Security Check")}</p>
                                            <div id="recaptcha_image" class="mb10"></div>
                                            <div class="captchaRefresh">
                                                {$translate->__("Can't read the text above?")}<br />
                                                <a href="javascript:Recaptcha.reload()">{$translate->__("Try another CAPTCHA")}</a> {$translate->__("or")} <span class="recaptcha_only_if_image"><a href="javascript:Recaptcha.switch_type('audio');">{$translate->__("an audio captcha")}</a></span><span class="recaptcha_only_if_audio"><a href="javascript:Recaptcha.switch_type('image');">{$translate->__("back to text")}</a></span>
                                            </div>
                                            <div class="inline mt10">
                                                <label>{$translate->__("Text in the box")}:</label>
                                                <div class="captchaInput ml5"><input class="uiInput" type="text" id="recaptcha_response_field" name="recaptcha_response_field" autocomplete="off" tabindex="2" /></div>
                                            </div>
                                        </div>
                                        <script type="text/javascript" src="http://www.google.com/recaptcha/api/challenge?k={$RECAPTCHA_PUBLICKEY}"></script>
                                        <noscript>
                                            <iframe src="http://www.google.com/recaptcha/api/noscript?k={$RECAPTCHA_PUBLICKEY}" height="300" width="500" frameborder="0"></iframe><br/>
                                            <textarea name="recaptcha_challenge_field" rows="3" cols="40"></textarea>
                                            <input type="hidden" name="recaptcha_response_field" value="manual_challenge" />
                                        </noscript>
                                    </div>
                                    <!-- reCaptcha -->
                                </td>
                            </tr>
                            <tr>
                                <td class="label"></td>
                                <td class="input fs11">
                                    <input style="padding: 4px 15px;" class="uiButton bigButton" type="submit" name="submit" value="{$translate->__("Send Instructions")}" tabindex="3" />
                                </td>
                            </tr>
                        </table>
                    </form>
                
                </div>
                
            </div>
        </div>
        
    </div>
</div>
<!-- Content -->

{include file='footer.tpl'}