{include file='_head.tpl'}
{include file='header.tpl'}
    
<div class="container" style="padding-top: 80px;">
    <div class="row">
        
        <div class="span3">
            <div class="well" style="max-width: 340px; padding: 8px 0;">
                <ul class="nav nav-list">
                    <li class="nav-header">{$translate->__("Users")}</li>
                    <li><a href="{$SITE_URL}/admin/users.php">{$translate->__("Find User")}</a></li>
                    <li><a href="{$SITE_URL}/admin/users.php?tab=find">{$translate->__("Show All Users")}</a></li>
                    <li><a href="{$SITE_URL}/admin/users.php?tab=find&group=2">{$translate->__("List Moderators")}</a></li>
                    <li><a href="{$SITE_URL}/admin/users.php?tab=find&order=UserPosts&sort=DESC">{$translate->__("List Top Posters")}</a></li>
                    <li><a href="{$SITE_URL}/admin/users.php?tab=find&order=SignupDate&sort=DESC">{$translate->__("List New Registrations")}</a></li>
                    <li class="nav-header">Blocked</li>
                    <li><a href="{$SITE_URL}/admin/users.php?tab=find&blocked=Y">{$translate->__("View Blocked Users")}</a></li>
                </ul>
            </div>
        </div>
        
        <div class="span9">
            <section>
                
                <ul class="breadcrumb">
                    {if $view == "search" || $view == "find"}
                        <li><a href="{$SITE_URL}/admin/index.php?tab=dashboard"><i class="icon-home"></i> {$translate->__("Dashboard")}</a> <span class="divider">/</span></li>
                        <li class="active">{$translate->__("Users")}</li>
                    {elseif $view == "edit"}
                        <li><a href="{$SITE_URL}/admin/index.php?tab=dashboard"><i class="icon-home"></i> {$translate->__("Dashboard")}</a> <span class="divider">/</span></li>
                        <li><a href="{$SITE_URL}/admin/users.php">{$translate->__("Users")}</a> <span class="divider">/</span></li>
                        <li class="active">{$profile.UserFirstName} {$profile.UserLastName}</li>
                    {/if}
                </ul>
                
                {if $view == "search"}
                    
                    <div class="alert alert-info">{$translate->__("Hint: If you leave a field blank it will be ignored")}</div>
                    
                    <form class="form-horizontal" method="post" action="{$SITE_URL}/admin/users.php?tab=find">
                        <input type="hidden" name="tab" value="find" />
                        <fieldset>
                            
                            <div id="legend" class="">
                                <legend class="">{$translate->__("Advanced Search")}</legend>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("First Name")}</label>
                                <div class="controls">
                                    <input type="text" name="firstname" />
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("Last Name")}</label>
                                <div class="controls">
                                    <input type="text" name="lastname" />
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("Group")}</label>
                                <div class="controls">
                                    <select name="group">
                                        <option value="all">{$translate->__("-- All Usergroups --")}</option>
                                        <option value="2">{$translate->__("Admins")}</option>
                                        <option value="2">{$translate->__("Moderators")}</option>
                                        <option value="3">{$translate->__("Users")}</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("UserName")}</label>
                                <div class="controls">
                                    <input type="text" name="username" />
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("Email")}</label>
                                <div class="controls">
                                    <input type="text" name="email" />
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("Sex")}</label>
                                <div class="controls">
                                    <label class="radio inline">
                                        <input type="radio" name="sex" value="M">{$translate->__("Male")}
                                    </label>
                                    <label class="radio inline">
                                        <input type="radio" name="sex" value="F">{$translate->__("Female")}
                                    </label>
                                    <label class="radio inline">
                                        <input type="radio" name="sex" value="either" checked="checked">{$translate->__("Either")}
                                    </label>
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("Facebook Connected")}</label>
                                <div class="controls">
                                    <label class="radio inline">
                                        <input type="radio" name="fb_connected" value="Y">{$translate->__("Yes")}
                                    </label>
                                    <label class="radio inline">
                                        <input type="radio" name="fb_connected" value="N">{$translate->__("No")}
                                    </label>
                                    <label class="radio inline">
                                        <input type="radio" name="fb_connected" value="either" checked="checked">{$translate->__("Either")}
                                    </label>
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("Twitter Connected")}</label>
                                <div class="controls">
                                    <label class="radio inline">
                                        <input type="radio" name="tw_connected" value="Y">{$translate->__("Yes")}
                                    </label>
                                    <label class="radio inline">
                                        <input type="radio" name="tw_connected" value="N">{$translate->__("No")}
                                    </label>
                                    <label class="radio inline">
                                        <input type="radio" name="tw_connected" value="either" checked="checked">{$translate->__("Either")}
                                    </label>
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("Yes")}Blocked</label>
                                <div class="controls">
                                    <label class="radio inline">
                                        <input type="radio" name="tw_connected" value="Y">{$translate->__("Yes")}
                                    </label>
                                    <label class="radio inline">
                                        <input type="radio" name="tw_connected" value="N">{$translate->__("No")}
                                    </label>
                                    <label class="radio inline">
                                        <input type="radio" name="tw_connected" value="either" checked="checked">{$translate->__("Either")}
                                    </label>
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("Join Date After")}</label>
                                <div class="controls">
                                    <input type="text" name="joindate_after" />
                                    <p class="muted">(dd-mm-yyyy)</p>
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("Join Date Before")}</label>
                                <div class="controls">
                                    <input type="text" name="joindate_before" />
                                    <p class="muted">(dd-mm-yyyy)</p>
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("Last Activity After")}</label>
                                <div class="controls">
                                    <input type="text" name="lastlogin_after" />
                                    <p class="muted">(dd-mm-yyyy)</p>
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("Last Activity Before")}</label>
                                <div class="controls">
                                    <input type="text" name="lastlogin_before" />
                                    <p class="muted">(dd-mm-yyyy)</p>
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("Posts &gt;=")}</label>
                                <div class="controls">
                                    <input type="text" name="posts_gt" />
                                    <p class="muted">{$translate->__("Posts are greater than or equal to")}</p>
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("Posts &lt;")}</label>
                                <div class="controls">
                                    <input type="text" name="posts_lt" />
                                    <p class="muted">{$translate->__("Posts are less than")}</p>
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("IP Address")}</label>
                                <div class="controls">
                                    <input type="text" name="ip" />
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("Order By")}</label>
                                <div class="controls">
                                    <select name="order">
                                        <option value="UserID">{$translate->__("User ID")}</option>
                                        <option value="UserName">{$translate->__("User Name")}</option>
                                        <option value="UserEmail">{$translate->__("Email")}</option>
                                        <option value="SignupDate">{$translate->__("Join Date")}</option>
                                        <option value="UserLastLogin">{$translate->__("Last Login")}</option>
                                        <option value="UserPosts">{$translate->__("Posts Count")}</option>
                                    </select>
                                    <select name="sort">
                                        <option value="ASC">{$translate->__("Ascending")}</option>
                                        <option value="DESC">{$translate->__("Descending")}</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">{$translate->__("Max Results")}</label>
                                <div class="controls">
                                    <input type="text" name="size" value="50" />
                                </div>
                            </div>
                            
                            <div class="control-group">
                                <div class="form-actions">
                                    <button type="submit" class="btn btn-primary" name="submit">{$translate->__("Search")}</button>
                                </div>
                            </div>
                            
                        </fieldset>
                    </form>
                    
                {elseif $view == "find"}
                    
                    {if $results > 0}
                        
                        <ul class="chats">
                            {foreach $people as $person}
                                <li class="in">
                                    <a href="{$SITE_URL}/{$person.UserName}"><img class="avatar" alt="" src="{$SITE_URL}/{$person.UserAvatarPathMedium}"></a>
                                    <div class="message">
                                        <span class="arrow"></span>
                                        <a class="name" href="{$SITE_URL}/{$person.UserName}">{$person.UserFirstName} {$person.UserLastName}</a>
                                        <span class="datetime">joined {$person.SignupDate|date_format:"%B %e, %Y"}</span>
                                        <span class="pull-right"><a class="btn btn-warning btn-small" href="{$SITE_URL}/admin/users.php?tab=edit&uid={$person.UserID}">{$translate->__("Edit User")}</a></span>
                                        <span class="body">
                                            {$person.UserBiography}
                                        </span>
                                    </div>
                                </li>
                            {/foreach}
                        </ul>
                        
                        <!-- Pagination -->
                        {$pager}
                        <!-- Pagination -->
                                                                        
                    {else}
                        <div class="alert alert-error">{$translate->__("No Users Matched Your Query")}</div>
                    {/if}
                    
                {elseif $view == "edit"}
                    
                    <div class="row-fluid">
                        
                        <div class="span4">
                            
                            <img src="{$SITE_URL}/{$profile.UserAvatarPath}" />
                            
                        </div>
                        
                        <div class="span4">
                            <div class="portlet sale-summary">
                                <div class="portlet-title">
                                    <div class="caption">{$translate->__("User Stats")}</div>
                                </div>
                                <ul class="unstyled">
                                    <li>
                                        <span class="sale-info">{$translate->__("User ID")}</span>
                                        <span class="sale-num">{$profile.UserID}</span>
                                    </li>
                                    <li>
                                        <span class="sale-info">{$translate->__("Posts")}</span>
                                        <span class="sale-num">{$profile.UserPosts}</span>
                                    </li>
                                    <li>
                                        <span class="sale-info">{$translate->__("Followings")}</span>
                                        <span class="sale-num">{$profile.UserFollowings}</span>
                                    </li>
                                    <li>
                                        <span class="sale-info">{$translate->__("Followers")}</span>
                                        <span class="sale-num">{$profile.UserFollowers}</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        
                        <div class="span4">
                            <div class="portlet sale-summary">
                                <div class="portlet-title">
                                    <div class="caption">{$translate->__("User Stats")}</div>
                                </div>
                                <ul class="unstyled">
                                    <li>
                                        <span class="sale-info">{$translate->__("Conversations")}</span>
                                        <span class="sale-num">{$profile.UserMessages}</span>
                                    </li>
                                    <li>
                                        <span class="sale-info">{$translate->__("Notifications")}</span>
                                        <span class="sale-num">{$profile.UserNotifications}</span>
                                    </li>
                                    <li>
                                        <span class="sale-info">{$translate->__("Joined")}</span>
                                        <span class="sale-num">{$profile.UserLastLogin|date_format:"%B %e, %Y"}</span>
                                    </li>
                                    <li>
                                        <span class="sale-info">{$translate->__("Last Login")}</span>
                                        <span class="sale-num">{$profile.SignupDate|date_format:"%B %e, %Y"}</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        
                    </div>
                    
                    {if $highlight != ""}<div class="alert alert-success">{$highlight}</div>{/if}
                    
                    <div class="tabbable" style="margin-bottom: 18px;">
                        <ul class="nav nav-tabs">
                            <li class="active"><a href="#tab1" data-toggle="tab">{$translate->__("Basic Info")}</a></li>
                            <li class=""><a href="#tab2" data-toggle="tab">{$translate->__("Name")}</a></li>
                            <li class=""><a href="#tab3" data-toggle="tab">{$translate->__("Username")}</a></li>
                            <li class=""><a href="#tab4" data-toggle="tab">{$translate->__("Email")}</a></li>
                            <li class=""><a href="#tab5" data-toggle="tab">{$translate->__("Password")}</a></li>
                            <li class=""><a href="#tab6" data-toggle="tab">{$translate->__("Profile")}</a></li>
                            <li class=""><a href="#tab7" data-toggle="tab">{$translate->__("Privacy")}</a></li>
                        </ul>
                        <div class="tab-content" style="padding-bottom: 9px; border-bottom: 1px solid #ddd;">
                            <div class="tab-pane active" id="tab1">
                                
                                <form class="form-horizontal" method="post" action="{$SITE_URL}/admin/users.php?tab=edit&uid={$profile.UserID}&modify=basic">
                                    <fieldset>
                                        
                                        <div id="legend" class="">
                                            <legend class="">{$translate->__("Edit Basic Info")}</legend>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Blocked")}</label>
                                            <div class="controls">
                                                <label class="radio inline">
                                                    <input type="radio" name="blocked" {if $profile.Blocked == "Y"}checked="checked"{/if} value="Y">{$translate->__("Yes")}
                                                </label>
                                                <label class="radio inline">
                                                    <input type="radio" name="blocked" {if $profile.Blocked == "N"}checked="checked"{/if} value="N">{$translate->__("No")}
                                                </label>
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Verified")}</label>
                                            <div class="controls">
                                                <label class="radio inline">
                                                    <input type="radio" name="verified" {if $profile.Verified == "Y"}checked="checked"{/if} value="Y">{$translate->__("Yes")}
                                                </label>
                                                <label class="radio inline">
                                                    <input type="radio" name="verified" {if $profile.Verified == "N"}checked="checked"{/if} value="N">{$translate->__("No")}
                                                </label>
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Getting Started")}</label>
                                            <div class="controls">
                                                <label class="radio inline">
                                                    <input type="radio" name="started" {if $profile.GettingStarted == "Y"}checked="checked"{/if} value="Y">{$translate->__("Yes")}
                                                </label>
                                                <label class="radio inline">
                                                    <input type="radio" name="started" {if $profile.GettingStarted == "N"}checked="checked"{/if} value="N">{$translate->__("No")}
                                                </label>
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Reseted")}</label>
                                            <div class="controls">
                                                <label class="radio inline">
                                                    <input type="radio" name="reseted" {if $profile.Reseted == "Y"}checked="checked"{/if} value="Y">{$translate->__("Yes")}
                                                </label>
                                                <label class="radio inline">
                                                    <input type="radio" name="reseted" {if $profile.Reseted == "N"}checked="checked"{/if} value="N">{$translate->__("No")}
                                                </label>
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Group")}</label>
                                            <div class="controls">
                                                <select name="group">
                                                    <option {if $profile.UserGroup == "1"}selected="selected"{/if} value="1">{$translate->__("Administrators")}</option>
                                                    <option {if $profile.UserGroup == "2"}selected="selected"{/if} value="2">{$translate->__("Moderators")}</option>
                                                    <option {if $profile.UserGroup == "3"}selected="selected"{/if} value="3">{$translate->__("Users")}</option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Facebook Connected")}</label>
                                            <div class="controls">
                                                <label class="radio inline">
                                                    <input type="radio" name="fb_connected" {if $profile.fb_connected == "Y"}checked="checked"{/if} value="Y">{$translate->__("Yes")}
                                                </label>
                                                <label class="radio inline">
                                                    <input type="radio" name="fb_connected" {if $profile.fb_connected == "N"}checked="checked"{/if} value="N">{$translate->__("No")}
                                                </label>
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Facebook UserID")}</label>
                                            <div class="controls">
                                                <input type="text" name="fb_UserID" value="{$profile.fb_UserID}" />
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Facebook UserName")}</label>
                                            <div class="controls">
                                                <input type="text" name="fb_UserName" value="{$profile.fb_UserName}" />
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Facebook Token")}</label>
                                            <div class="controls">
                                                <input type="text" name="fb_Token" value="{$profile.fb_Token}" />
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Twitter Connected")}</label>
                                            <div class="controls">
                                                <label class="radio inline">
                                                    <input type="radio" name="tw_connected" {if $profile.tw_connected == "Y"}checked="checked"{/if} value="Y">{$translate->__("Yes")}
                                                </label>
                                                <label class="radio inline">
                                                    <input type="radio" name="tw_connected" {if $profile.tw_connected == "N"}checked="checked"{/if} value="N">{$translate->__("No")}
                                                </label>
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Twitter UserID")}</label>
                                            <div class="controls">
                                                <input type="text" name="tw_UserID" value="{$profile.tw_UserID}" />
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Twitter UserName")}</label>
                                            <div class="controls">
                                                <input type="text" name="tw_UserName" value="{$profile.tw_UserName}" />
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Twitter Token")}</label>
                                            <div class="controls">
                                                <input type="text" name="tw_Token" value="{$profile.tw_Token}" />
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Twitter Secret")}</label>
                                            <div class="controls">
                                                <input type="text" name="tw_TokenSecret" value="{$profile.tw_TokenSecret}" />
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("IP")}</label>
                                            <div class="controls">
                                                <input type="text" name="UserIP" value="{$profile.UserIP}" />
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <div class="form-actions">
                                                <button type="submit" class="btn btn-primary" name="submit">{$translate->__("Save changes")}</button>
                                            </div>
                                        </div>
                                        
                                    </fieldset>
                                </form>
                                
                            </div>
                            <div class="tab-pane" id="tab2">
                                
                                <form class="form-horizontal" method="post" action="{$SITE_URL}/admin/users.php?tab=edit&uid={$profile.UserID}&modify=name">
                                    <fieldset>
                                        
                                        <div id="legend" class="">
                                            <legend class="">{$translate->__("Edit Name")}</legend>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("First Name")}</label>
                                            <div class="controls">
                                                <input type="text" name="firstname" value="{$profile.UserFirstName}" />
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Last Name")}</label>
                                            <div class="controls">
                                                <input type="text" name="lastname" value="{$profile.UserLastName}" />
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <div class="form-actions">
                                                <button type="submit" class="btn btn-primary" name="submit">{$translate->__("Save changes")}</button>
                                            </div>
                                        </div>
                                        
                                    </fieldset>
                                </form>
                                
                            </div>
                            <div class="tab-pane" id="tab3">
                                
                                <form class="form-horizontal" method="post" action="{$SITE_URL}/admin/users.php?tab=edit&uid={$profile.UserID}&modify=email">
                                    <fieldset>
                                        
                                        <div id="legend" class="">
                                            <legend class="">{$translate->__("Edit Username")}</legend>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Username")}</label>
                                            <div class="controls">
                                                <input type="text" name="username" value="{$profile.UserName}" />
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <div class="form-actions">
                                                <button type="submit" class="btn btn-primary" name="submit">{$translate->__("Save changes")}</button>
                                            </div>
                                        </div>
                                        
                                    </fieldset>
                                </form>
                                
                            </div>
                            
                            <div class="tab-pane" id="tab4">
                                
                                <form class="form-horizontal" method="post" action="{$SITE_URL}/admin/users.php?tab=edit&uid={$profile.UserID}&modify=username">
                                    <fieldset>
                                        
                                        <div id="legend" class="">
                                            <legend class="">{$translate->__("Edit Email")}</legend>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Email")}</label>
                                            <div class="controls">
                                                <input type="text" name="email" value="{$profile.UserEmail}"  />
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <div class="form-actions">
                                                <button type="submit" class="btn btn-primary" name="submit">{$translate->__("Save changes")}</button>
                                            </div>
                                        </div>
                                        
                                    </fieldset>
                                </form>
                                
                            </div>
                            
                            <div class="tab-pane" id="tab5">
                                
                                <form class="form-horizontal" method="post" action="{$SITE_URL}/admin/users.php?tab=edit&uid={$profile.UserID}&modify=password">
                                    <fieldset>
                                        
                                        <div id="legend" class="">
                                            <legend class="">{$translate->__("Edit Password")}</legend>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Password")}</label>
                                            <div class="controls">
                                                <input type="text" type="text" name="password"/>
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <div class="form-actions">
                                                <button type="submit" class="btn btn-primary" name="submit">{$translate->__("Save changes")}</button>
                                            </div>
                                        </div>
                                        
                                    </fieldset>
                                </form>
                                
                            </div>
                            
                            <div class="tab-pane" id="tab6">
                                
                                <form class="form-horizontal" method="post" action="{$SITE_URL}/admin/users.php?tab=edit&uid={$profile.UserID}&modify=profile">
                                    <fieldset>
                                        
                                        <div id="legend" class="">
                                            <legend class="">{$translate->__("Edit Profile Info")}</legend>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Sex")}</label>
                                            <div class="controls">
                                                <select name="sex">
                                                    <option {if $profile.UserSex == "M"}selected="selected"{/if} value="M">{$translate->__("Male")}</option>
                                                    <option {if $profile.UserSex == "F"}selected="selected"{/if} value="F">{$translate->__("Female")}</option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Birthday")}</label>
                                            <div class="controls">
                                                <select name="month">
                                                    <option value="none" selected="selected">{$translate->__("Month")}:</option>
                                                    <option {if $profile.UserBirthMonth == "1"}selected="selected"{/if} value="1">{$translate->__("Jan")}</option>
                                                    <option {if $profile.UserBirthMonth == "2"}selected="selected"{/if} value="2">{$translate->__("Feb")}</option>
                                                    <option {if $profile.UserBirthMonth == "3"}selected="selected"{/if} value="3">{$translate->__("Mar")}</option>
                                                    <option {if $profile.UserBirthMonth == "4"}selected="selected"{/if} value="4">{$translate->__("Apr")}</option>
                                                    <option {if $profile.UserBirthMonth == "5"}selected="selected"{/if} value="5">{$translate->__("May")}</option>
                                                    <option {if $profile.UserBirthMonth == "6"}selected="selected"{/if} value="6">{$translate->__("Jun")}</option>
                                                    <option {if $profile.UserBirthMonth == "7"}selected="selected"{/if} value="7">{$translate->__("Jul")}</option>
                                                    <option {if $profile.UserBirthMonth == "8"}selected="selected"{/if} value="8">{$translate->__("Aug")}</option>
                                                    <option {if $profile.UserBirthMonth == "9"}selected="selected"{/if} value="9">{$translate->__("Sep")}</option>
                                                    <option {if $profile.UserBirthMonth == "10"}selected="selected"{/if} value="10">{$translate->__("Oct")}</option>
                                                    <option {if $profile.UserBirthMonth == "11"}selected="selected"{/if} value="11">{$translate->__("Nov")}</option>
                                                    <option {if $profile.UserBirthMonth == "12"}selected="selected"{/if} value="12">{$translate->__("Dec")}</option>
                                                </select>
                                                
                                                <select name="day">
                                                    <option value="none" selected="selected">{$translate->__("Day")}:</option>
                                                    {for $i=1 to 31}
                                                        <option {if $profile.UserBirthDay == $i}selected="selected"{/if} value="{$i}">{$i}</option>
                                                    {/for}
                                                </select>
                                                
                                                <select name="year">
                                                    <option value="none" selected="selected">{$translate->__("Year")}:</option>
                                                    {for $i=1905 to 2011}
                                                        <option {if $profile.UserBirthYear == $i}selected="selected"{/if} value="{$i}">{$i}</option>
                                                    {/for}
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Location")}</label>
                                            <div class="controls">
                                                <input type="text" name="location" value="{$profile.UserCountry}" />
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Bio")}</label>
                                            <div class="controls">
                                                <textarea name="bio">{$profile.UserBiography}</textarea>
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <div class="form-actions">
                                                <button type="submit" class="btn btn-primary" name="submit">{$translate->__("Save changes")}</button>
                                            </div>
                                        </div>
                                        
                                    </fieldset>
                                </form>
                                
                            </div>
                            
                            <div class="tab-pane" id="tab7">
                                
                                <form class="form-horizontal" method="post" action="{$SITE_URL}/admin/users.php?tab=edit&uid={$profile.UserID}&modify=privacy">
                                    <fieldset>
                                        
                                        <div id="legend" class="">
                                            <legend class="">{$translate->__("Edit Privacy")}</legend>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Facebook Account")}</label>
                                            <div class="controls">
                                                <label class="radio inline">
                                                    <input type="radio" name="privacyFB" {if $profile.privacyFB == "Y"}checked="checked"{/if} value="Y">{$translate->__("Yes")}
                                                </label>
                                                <label class="radio inline">
                                                    <input type="radio" name="privacyFB" {if $profile.privacyFB == "N"}checked="checked"{/if} value="N">{$translate->__("No")}
                                                </label>
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <label class="control-label">{$translate->__("Twitter Account")}</label>
                                            <div class="controls">
                                                <label class="radio inline">
                                                    <input type="radio" name="privacyTW" {if $profile.privacyTW == "Y"}checked="checked"{/if} value="Y">{$translate->__("Yes")}
                                                </label>
                                                <label class="radio inline">
                                                    <input type="radio" name="privacyTW" {if $profile.privacyTW == "N"}checked="checked"{/if} value="N">{$translate->__("No")}
                                                </label>
                                            </div>
                                        </div>
                                        
                                        <div class="control-group">
                                            <div class="form-actions">
                                                <button type="submit" class="btn btn-primary" name="submit">{$translate->__("Save changes")}</button>
                                            </div>
                                        </div>
                                        
                                    </fieldset>
                                </form>
                                
                            </div>
                            
                        </div>
                    </div>
                    
                {/if}
                
            </section>
        </div>
    </div>
</div>

{include file='footer.tpl'}