<!DOCTYPE html>
<html>
<head>
    <title>Sngine &rsaquo; Installer</title>
    <!-- Theme CSS -->
    
    {literal}
    <style type="text/css">
        html {
        	background: #f9f9f9;
        }
        
        body {
        	background: #fff;
        	color: #333;
        	font-family: sans-serif;
        	margin: 2em auto;
        	padding: 1em 2em;
        	-webkit-border-radius: 3px;
        	border-radius: 3px;
        	border: 1px solid #dfdfdf;
        	max-width: 700px;
        }
        
        a {
        	color: #21759b;
        	text-decoration: none;
        }
        
        a:hover {
        	color: #d54e21;
        }
        
        h1 {
        	border-bottom: 1px solid #dadada;
        	clear: both;
        	color: #666;
        	font: 24px Georgia, "Times New Roman", Times, serif;
        	margin: 30px 0 0 0;
        	padding: 0;
        	padding-bottom: 7px;
        }
        
        h2 {
        	font-size: 16px;
        }
        
        p, li, dd, dt {
        	padding-bottom: 2px;
        	font-size: 14px;
        	line-height: 1.5;
        }
        
        code, .code {
        	font-size: 14px;
        }
        
        ul, ol, dl {
        	padding: 5px 5px 5px 22px;
        }
        
        a img {
        	border:0
        }
        abbr {
        	border: 0;
        	font-variant: normal;
        }
        #logo {
        	margin: 6px 0 14px 0;
        	border-bottom: none;
        	text-align:center
        }
        #logo a {
        	background-image: url('../content/themes/admin/images/header/logo-installer.png');
        	background-size: 274px 63px;
        	background-position: top center;
        	background-repeat: no-repeat;
        	height: 67px;
        	text-indent: -9999px;
        	outline: none;
        	overflow: hidden;
        	display: block;
        }
        @media print,
          (-o-min-device-pixel-ratio: 5/4),
          (-webkit-min-device-pixel-ratio: 1.25),
          (min-resolution: 120dpi) {
        	#logo a {
        		background-image: url('../images/wordpress-logo-2x.png?ver=20120412');
        		background-size: 274px 63px;
        	}
        }
        .step {
        	margin: 20px 0 15px;
        }
        .step, th {
        	text-align: left;
        	padding: 0;
        }
        .step .button-large {
        	font-size: 14px;
        }
        textarea {
        	border: 1px solid #dfdfdf;
        	-webkit-border-radius: 3px;
        	border-radius: 3px;
        	font-family: sans-serif;
        	width:  695px;
        }
        
        .form-table {
        	border-collapse: collapse;
        	margin-top: 1em;
        	width: 100%;
        }
        
        .form-table td {
        	margin-bottom: 9px;
        	padding: 10px 20px 10px 0;
        	border-bottom: 8px solid #fff;
        	font-size: 14px;
        	vertical-align: top
        }
        
        .form-table th {
        	font-size: 14px;
        	text-align: left;
        	padding: 16px 20px 10px 0;
        	border-bottom: 8px solid #fff;
        	width: 140px;
        	vertical-align: top;
        }
        
        .form-table code {
        	line-height: 18px;
        	font-size: 14px;
        }
        
        .form-table p {
        	margin: 4px 0 0 0;
        	font-size: 11px;
        }
        
        .form-table input {
        	line-height: 20px;
        	font-size: 15px;
        	padding: 2px;
        	border: 1px #dfdfdf solid;
        	-webkit-border-radius: 3px;
        	border-radius: 3px;
        	font-family: sans-serif;
        }
        
        .form-table input[type=text],
        .form-table input[type=password] {
        	width: 206px;
        }
        
        .form-table th p {
        	font-weight: normal;
        }
        
        .form-table.install-success td {
        	vertical-align: middle;
        	padding: 16px 20px 10px 0;
        }
        
        .form-table.install-success td p {
        	margin: 0;
        	font-size: 14px;
        }
        
        .form-table.install-success td code {
        	margin: 0;
        	font-size: 18px;
        }
        
        #error-page {
        	margin-top: 50px;
        }
        
        #error-page p {
        	font-size: 14px;
        	line-height: 18px;
        	margin: 25px 0 20px;
        }
        
        #error-page code, .code {
        	font-family: Consolas, Monaco, monospace;
        }
        
        #pass-strength-result {
        	background-color: #eee;
        	border-color: #ddd !important;
        	border-style: solid;
        	border-width: 1px;
        	margin: 5px 5px 5px 0;
        	padding: 5px;
        	text-align: center;
        	width: 200px;
        	display: none;
        }
        
        #pass-strength-result.bad {
        	background-color: #ffb78c;
        	border-color: #ff853c !important;
        }
        
        #pass-strength-result.good {
        	background-color: #ffec8b;
        	border-color: #ffcc00 !important;
        }
        
        #pass-strength-result.short {
        	background-color: #ffa0a0;
        	border-color: #f04040 !important;
        }
        
        #pass-strength-result.strong {
        	background-color: #c3ff88;
        	border-color: #8dff1c !important;
        }
        
        .message {
        	border: 1px solid #e6db55;
        	padding: 0.3em 0.6em;
        	margin: 5px 0 15px;
        	background-color: #ffffe0;
        }
        
    </style>
    {/literal}
</head>

<body>
    
    <h1 id="logo"><a href="http://sngine.com/">Sngine</a></h1>
    
    {if $step == '0'}
        
        <p>Welcome to Sngine. Before getting started, we need some information on the database. You will need to know the following items before proceeding.</p>
        <ol>
        	<li>Database name</li>
        	<li>Database username</li>
        	<li>Database password</li>
        	<li>Database host</li>
        </ol>
        <p><strong>If for any reason this automatic file creation doesn't work, don't worry. All this does is fill in the database information to a configuration file. You may also simply open <code>libs/config-sample.php</code> in a text editor, fill in your information, and save it as <code>libs/config.php</code>.</strong></p>
        <p>In all likelihood, these items were supplied to you by your Web Host. If you do not have this information, then you will need to contact them before you can continue. If you're all ready</p>
        
        <p class="step"><a href="install.php?step=1" class="button button-large">Let's go!</a></p>
        
    {elseif $step == '1'}
        
        <form method="post" action="install.php?step=2">
            
            <p>Below you should enter your database connection details. If you're not sure about these, contact your host.</p>
            <table class="form-table">
                <tbody>
                    <tr>
                        <th scope="row"><label for="dbname">Database Name</label></th>
                        <td><input name="dbname" id="dbname" type="text" size="25" value="sngine"></td>
                        <td>The name of the database you want to run Sngine in.</td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="uname">User Name</label></th>
                        <td><input name="uname" id="uname" type="text" size="25" value="username"></td>
                        <td>Your MySQL username</td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="pwd">Password</label></th>
                        <td><input name="pwd" id="pwd" type="text" size="25" value="password"></td>
                        <td>and your MySQL password.</td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="dbhost">Database Host</label></th>
                        <td><input name="dbhost" id="dbhost" type="text" size="25" value="localhost"></td>
                        <td>You should be able to get this info from your web host, if <code>localhost</code> does not work.</td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="debugging">Debugging Mode</label></th>
                        <td><select name="debugging" id="debugging"><option value="true">Yes</option><option value="false">No</option></select></td>
                        <td>Change this to true to enable the display of notices during development.</td>
                    </tr>
                </tbody>
            </table>
            
            <p>Yes, the following information can be changed later.</p>
            <table class="form-table">
                <tbody>
                    <tr>
                        <th scope="row"><label for="title">System Title</label></th>
                        <td><input name="title" id="title" type="text" size="25" value="Sngine"></td>
                        <td></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="domain">System Domain</label></th>
                        <td><input name="domain" id="domain" type="text" size="25" value="{$domain}"></td>
                        <td></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="url">System URL</label></th>
                        <td><input name="url" id="url" type="text" size="25" value=""></td>
                        <td></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="RECAPTCHA_PUBLICKEY">RECAPTCHA PUBLICKEY</label></th>
                        <td><input name="RECAPTCHA_PUBLICKEY" id="RECAPTCHA_PUBLICKEY" type="text" size="25" value=""></td>
                        <td></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="RECAPTCHA_PRIVATEKEY">RECAPTCHA PRIVATEKEY</label></th>
                        <td><input name="RECAPTCHA_PRIVATEKEY" id="RECAPTCHA_PRIVATEKEY" type="text" size="25" value=""></td>
                        <td></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="email">Admin Email</label></th>
                        <td><input name="email" id="email" type="text" size="25" value=""></td>
                        <td></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="username">Admin Username</label></th>
                        <td><input name="username" id="username" type="text" size="25" value=""></td>
                        <td></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="password">Admin Password</label></th>
                        <td><input name="password" id="password" type="password" size="25" value=""></td>
                        <td></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="confirm">Confirm Password</label></th>
                        <td><input name="confirm" id="confirm" type="password" size="25" value=""></td>
                        <td></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="email">Admin Firstname</label></th>
                        <td><input name="firstname" id="firstname" type="text" size="25" value=""></td>
                        <td></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="email">Admin Lastname</label></th>
                        <td><input name="lastname" id="lastname" type="text" size="25" value=""></td>
                        <td></td>
                    </tr>
                </tbody>
            </table>
            <p class="step"><input name="submit" type="submit" value="Submit" class="button button-large"></p>
            
        </form>
        
    {/if}
    
</body>
</html>