<?php
/**
 * photos|videos app
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
require('kernal.php');

// check access level
AccessLevel();

// check data ID
if(!isset($_GET['id']) OR $_GET['id'] == 0 OR $_GET['id'] == "") {
    SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
}

// valid inputs
$valid['m'] = array('photos', 'videos');
if(!in_array($_GET['m'], $valid['m'])) {
    SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
}

// get media
if($_GET['m'] == "photos") {
    $postType = 3;
    $postTable = 'posts_photos';
    $albumTable = 'posts_photos_albums';
    $sourceTable = 'posts_photos_sources';
}elseif($_GET['m'] == "videos") {
    $postType = 4;
    $postTable = 'posts_videos';
    $albumTable = 'posts_videos_albums';
    $sourceTable = 'posts_videos_sources';
}else {
    header('Location: '.SITE_URL);
}

// get album
$getAlbum = $db->query(sprintf("SELECT album.*, user.UserName, user.UserFirstName, user.UserLastName FROM %s album INNER JOIN users user ON album.UserID = user.UserID WHERE ID = %s", $albumTable, Secure($_GET['id'], 'int'))) or SQLError();
if($getAlbum->num_rows == 0) {
    SystemError($translate->__("This content is currently unavailable"), $translate->__("The page you requested cannot be displayed right now. It may be temporarily unavailable, the link you clicked on may have expired, or you may not have permission to view this page."));
}
$album = $getAlbum->fetch_array(MYSQLI_ASSOC);
$album['Text'] = DecodeText($album['Text']);

// page header
PageHeader($album['Title'], strip_tags($album['Text']));

// get all album resources
if($album['Total'] > 0) {
    $getResources = $db->query(sprintf("SELECT * FROM %s WHERE AlbumID = %s", $sourceTable, Secure($album['ID'], 'int') ));
    while($resource = $getResources->fetch_array(MYSQLI_ASSOC)) {
        $album['resources'][] = $resource;
    }
    $album['firstNode'] = $album['resources'][0]['ID'];
    // get comments & statistics
    if($album['IsWall'] == "N") {
        $getPost = $db->query(sprintf("SELECT post.* FROM %s media INNER JOIN posts post ON media.ID = post.PostID AND post.PostType = %s WHERE media.IsAlbum = 'Y' AND media.MediaID = %s", $postTable, $postType, SafeSQL($album['ID'], 'int') )) or SQLError();
        $post = $getPost->fetch_array(MYSQLI_ASSOC);
        $smarty->assign('post', $post);
        $album['Favorits'] = $post['Favorits'];
        $album['Likes'] = $post['Likes'];
        $album['Dislikes'] = $post['Dislikes'];
        $album['Comments'] = $post['Comments'];
        $album['PComments'] = $post['PComments'];
        // check if user favorited this album before
        $getPostStatus = $db->query(sprintf("SELECT Favorited FROM users_posts_favorites WHERE UserID = %s AND PostType = %s AND PostID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($post['PostType'], 'int'), SafeSQL($post['PostID'], 'int') )) or SQLError();
        if($getPostStatus->num_rows > 0) {
            $album['favorited'] = true;
        }else {
            $album['favorited'] = false;
        }
        // check if user liked|disliked this album before
        $getPostStatus = $db->query(sprintf("SELECT Liked FROM users_posts_likes WHERE UserID = %s AND PostType = %s AND PostID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($post['PostType'], 'int'), SafeSQL($post['PostID'], 'int') )) or SQLError();
        if($getPostStatus->num_rows > 0) {
            $postStatus = $getPostStatus->fetch_array(MYSQLI_ASSOC);
            $album['liked'] = $postStatus['Liked'];
        }
        // get comments
        if($post['Comments'] > 0) {
            // prepare where statement
            if(count($userBlockedUsers) > 0) {
                $whereStatement = ' AND comm.UserID NOT IN (' . implode(',', $userBlockedUsers) . ')';
            }
            $album['prevComments'] = ($post['PComments'] > $systemSetting['MaxComments'])? $post['PComments'] - $systemSetting['MaxComments']: 0;
            $getComments = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_comments comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.PostType = %s AND comm.PostID = %s AND comm.ParentNodeID = 0 ".$whereStatement." ORDER BY comm.Time ASC LIMIT %s,".$systemSetting['MaxComments'], SafeSQL($post['PostType'], 'int'), SafeSQL($post['PostID'], 'int'), $album['prevComments'] )) or SQLError();
            while($comment = $getComments->fetch_array(MYSQLI_ASSOC)) {
                // get Replies
                if($comment['Replies'] > 0) {
                    $comment['prevReplies'] = ($comment['Replies'] > $systemSetting['MaxReplies'])? $comment['Replies'] - $systemSetting['MaxReplies']: 0;
                    $getReplies = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_comments comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.ParentNodeID = %s ".$whereStatement." ORDER BY comm.Time ASC LIMIT %s,".$systemSetting['MaxReplies'], SafeSQL($comment['ID'], 'int'), $comment['prevReplies'] )) or SQLError();
                    while($reply = $getReplies->fetch_array(MYSQLI_ASSOC)) {
                        // check if user liked|disliked this reply before
                        $getReplyStatus = $db->query(sprintf("SELECT Liked FROM users_comments_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($reply['ID'], 'int') )) or SQLError();
                        if($getReplyStatus->num_rows > 0) {
                            $replyStatus = $getReplyStatus->fetch_array(MYSQLI_ASSOC);
                            $reply['liked'] = $replyStatus['Liked'];
                        }
                        // decode text
                        $reply['Text'] = DecodeText($reply['Text']);
                        $comment['replies'][] = $reply;
                    }
                }
                // check if user liked|disliked this comment before
                $getCommentStatus = $db->query(sprintf("SELECT Liked FROM users_comments_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($comment['ID'], 'int') )) or SQLError();
                if($getCommentStatus->num_rows > 0) {
                    $commentStatus = $getCommentStatus->fetch_array(MYSQLI_ASSOC);
                    $comment['liked'] = $commentStatus['Liked'];
                }
                // decode text
                $comment['Text'] = DecodeText($comment['Text']);
                $album['comments'][] = $comment;
            }
        }
    }else {
        // check if user favorited this wall album before
        $getAlbumStatus = $db->query(sprintf("SELECT Favorited FROM users_media_favorites WHERE UserID = %s AND PostType = %s AND IsAlbum = 'Y' AND MediaID = %s", SafeSQL($userArray['UserID'], 'int'), $postType, SafeSQL($album['ID'], 'int') )) or SQLError();
        if($getAlbumStatus->num_rows > 0) {
            $album['favorited'] = true;
        }else {
            $album['favorited'] = false;
        }
        // check if user liked|disliked this wall album before
        $getAlbumStatus = $db->query(sprintf("SELECT Liked FROM users_media_likes WHERE UserID = %s AND PostType = %s AND IsAlbum = 'Y' AND  MediaID = %s", SafeSQL($userArray['UserID'], 'int'), $postType, SafeSQL($album['ID'], 'int') )) or SQLError();
        if($getAlbumStatus->num_rows > 0) {
            $albumStatus = $getAlbumStatus->fetch_array(MYSQLI_ASSOC);
            $album['liked'] = $albumStatus['Liked'];
        }
        // get comments
        if($album['Comments'] > 0) {
            // prepare where statement
            if(count($userBlockedUsers) > 0) {
                $whereStatement = ' AND comm.UserID NOT IN (' . implode(',', $userBlockedUsers) . ')';
            }
            $album['prevComments'] = ($album['PComments'] > $systemSetting['MaxComments'])? $album['PComments'] - $systemSetting['MaxComments']: 0;
            $getComments = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_comments_media comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.PostType = %s AND IsAlbum = 'Y' AND comm.MediaID = %s AND comm.ParentNodeID = 0 ".$whereStatement." ORDER BY comm.Time ASC LIMIT %s,".$systemSetting['MaxComments'], $postType, SafeSQL($album['ID'], 'int'), $album['prevComments'] )) or SQLError();
            while($comment = $getComments->fetch_array(MYSQLI_ASSOC)) {
                // get Replies
                if($comment['Replies'] > 0) {
                    $comment['prevReplies'] = ($comment['Replies'] > $systemSetting['MaxReplies'])? $comment['Replies'] - $systemSetting['MaxReplies']: 0;
                    $getReplies = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_comments_media comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.ParentNodeID = %s ".$whereStatement." ORDER BY comm.Time ASC LIMIT %s,".$systemSetting['MaxReplies'], SafeSQL($comment['ID'], 'int'), $comment['prevReplies'] )) or SQLError();
                    while($reply = $getReplies->fetch_array(MYSQLI_ASSOC)) {
                        // check if user liked|disliked this reply before
                        $getReplyStatus = $db->query(sprintf("SELECT Liked FROM users_comments_media_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($reply['ID'], 'int') )) or SQLError();
                        if($getReplyStatus->num_rows > 0) {
                            $replyStatus = $getReplyStatus->fetch_array(MYSQLI_ASSOC);
                            $reply['liked'] = $replyStatus['Liked'];
                        }
                        // decode text
                        $reply['Text'] = DecodeText($reply['Text']);
                        $comment['replies'][] = $reply;
                    }
                }
                // check if user liked|disliked this comment before
                $getCommentStatus = $db->query(sprintf("SELECT Liked FROM users_comments_media_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($comment['ID'], 'int') )) or SQLError();
                if($getCommentStatus->num_rows > 0) {
                    $commentStatus = $getCommentStatus->fetch_array(MYSQLI_ASSOC);
                    $comment['liked'] = $commentStatus['Liked'];
                }
                // decode text
                $comment['Text'] = DecodeText($comment['Text']);
                $album['comments'][] = $comment;
            }
        }
        // prepare post variables
        $post['PostType'] = $postType;
        $post['PostID'] = $_GET['id'];
        $smarty->assign('post', $post);
    }
}

// check if any saving
$saved = (isset($_GET['saved']))? true : false;

// assign variables
$album['PostType'] = $postType;
$smarty->assign('album', $album);
$smarty->assign('media', $_GET['m']);
$smarty->assign('saved', $saved);

// page footer
PageFooter("album");

?>