<?php
/**
 * get follow(ers|ings)
 * 
 * @package Sngine
 * @author Zamblek
 */


// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check page parameters
if(!isset($_GET['id']) || !isset($_GET['get']) || !isset($_GET['sp'])) {
    exit(ReportError('parameters error[1] @/ajax/users/people'));
}

// valid inputs
$valid['get'] = array('followings', 'followers');
if(!in_array($_GET['get'], $valid['get'])) {
    exit(ReportError('parameters error[2] @/ajax/users/people'));
}

// parse parameters
if(!preg_match('/^([0-9]+)$/', $_GET['id'])) {
    exit(ReportError('parameters error[3] @/ajax/users/people'));
}

// parse parameters
if(!preg_match('/^([0-9]+)$/', $_GET['sp'])) {
    exit(ReportError('parameters error[4] @/ajax/users/people'));
}

// prepare where statement
if($_GET['sp'] > 0) {
    $whereStatement = 'AND people.ID < '.SafeSQL($_GET['sp'], 'int');
}

// get people
if($_GET['get'] == "followings") {
    // get followings
    $getPeople = $db->query(sprintf("SELECT people.ID, people.FollowingID AS PeopleID, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath, user.UserBiography FROM users_followings people INNER JOIN users user ON people.FollowingID = user.UserID WHERE people.UserID = %s ".$whereStatement." ORDER BY people.ID DESC LIMIT ".$systemSetting['MaxPeople'], SafeSQL($_GET['id'], 'int'))) or die(ReportError('sql error #1 @/ajax/users/people'));
    while($following = $getPeople->fetch_array(MYSQLI_ASSOC)) {
        // check if user follow any of them
        if($userExist) {
            $following['FollowingHim'] = (count($userFollowings) > 0 && in_array($following['PeopleID'], $userFollowings))? true: false;
        }
        $people[] = $following;
    }
}else {
    // get followers
    $getPeople = $db->query(sprintf("SELECT people.ID, people.UserID AS PeopleID, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath, user.UserBiography FROM users_followings people INNER JOIN users user ON people.UserID = user.UserID WHERE people.FollowingID = %s ".$whereStatement." ORDER BY people.ID DESC LIMIT ".$systemSetting['MaxPeople'], SafeSQL($_GET['id'], 'int'))) or die(ReportError('sql error #2 @/ajax/users/people'));
    while($follower = $getPeople->fetch_array(MYSQLI_ASSOC)) {
        // check if user follow any of them
        if($userExist) {
            $follower['FollowingHim'] = (count($userFollowings) > 0 && in_array($follower['PeopleID'], $userFollowings))? true: false;
        }
        $people[] = $follower;
    }
}

if($getPeople->num_rows == 0) {
    exit;
}

$lastNode = end($people);
$lastNode = $lastNode['ID'];

// assign variables
$smarty->assign('people', $people);
$smarty->assign('lastNode', $lastNode);

// page footer
PageFooter("ajax.users.people");

?>