<?php
/**
 * publisher uploader
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');
require($depth.'libs/class-image.php');

// check if user exist
if(!$userExist) {
    exit('Access Denied');
}

// check user verified
if($userArray['Verified'] == "N") {
    exit('Access Denied');
}

// check secret
if($_SESSION['secret'] != $_POST['secret']) {
    exit('Access Denied');
}

// define the template
$template = "ajax.upload";

$data['status'] = 0;

// collect file info
$file = $_FILES['uploadFile'];
$fileName = $file['name'];
$fileTmp  = $file['tmp_name'];
$fileType = $file['type'];
$fileSize = $file['size'];
$dirPath = $depth.'content/uploads/photos/';

// check file extension
if(ValidImg($fileName)) {
    // check file size [4MB Max]
    if($fileSize < 4096000) {
        try {
            $image = new Image($fileTmp);
        }catch (Exception $e) {
            $data['error'] = $e->getMessage();
            $data['key'] = $_POST['key'];
            $smarty->assign('data', $data);
            $smarty->display($template.".tpl");
            exit;
        }
        // generate image & thumbnail names
        $prefix = 's_'.md5(time()*rand(1, 9999));
        $imgName = $prefix.'.jpg';
        $thumbName = $prefix.'_thumbnail.jpg';
        $tmpPath = $dirPath.$fileName;
        $imgPath = $dirPath.$imgName;
        $thumPath = $dirPath.$thumbName;
        // upload the new image
        if(@move_uploaded_file($fileTmp, $tmpPath)) {
            // generate image
            $image = new Image($tmpPath);
            $image->save($imgPath);
            unlink($tmpPath);
            // generate thumbnail
            $thumbnail = new Image($imgPath);
            $thumbnail->resizeToWidth(173);
            $thumbnail->save($thumPath);
            // prepare url
            $url = SITE_URL.'/content/uploads/photos/';
            // return data
            $data['img'] = $url.$imgName;
            $data['thumbnail'] = $url.$thumbName;
            $data['status'] = 1;
        }else {
            $data['error'] = "cannot upload the file!";
        }
    }else {
        $data['error'] = "The file size is so big";
    }
}else {
    $data['error'] = "The file type is not valid image";
}
$data['key'] = $_POST['key'];

// assign variables
$smarty->assign('data', $data);

// display page templete
$smarty->display($template.".tpl");

?>