<?php
/**
 * fetch external content
 * 
 * @package Sngine
 * @author Yehia Abed
 * @version 0.3
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');
require($depth.'libs/class-scraper.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['url']) || empty($_POST['url'])) {
    exit(PopupError(ReportError('parameters error @/ajax/publisher/scraper')));
}

// check if empty
if(IsEmpty($_POST['url'])) {
    exit(PopupError('Please enter a valid (non-empty) link.'));
}

// sanitize url
$link['url'] = Scraper::Sanitize($_POST['url']);

// check if video link
try {
    $check = Scraper::IsVideo($link['url']);
}catch (Exception $e) {
    exit(PopupError($e->getMessage()));
}

if($check !== false) {
    $view = 'video';
    $link['id'] =  $check['ID'];
    $link['type'] =  $check['Type'];
    $link['thumbnail'] =  $check['Thumbnail'];
}else {
    // check if music link
    try {
        $check = Scraper::IsMusic($link['url']);
    }catch (Exception $e) {
        exit(PopupError($e->getMessage()));
    }
    if($check !== false) {
        $view = 'music';
        $link['id'] =  $check['ID'];
        $link['title'] =  $check['Title'];
        $link['description'] =  $check['Description'];
    }else {
        $view = 'link';
        // get data
        try {
            $html = Scraper::get($link['url']);
        }catch (Exception $e) {
            exit(PopupError($e->getMessage()));
        }
        // parse data
        $dom = new DOMDocument();
        @$dom->loadHTML($html);
        $xpath = new DOMXPath($dom);
        
        // title
        $link['title'] = Sanitize($dom->getElementsByTagName('title')->item(0)->textContent);
        
        // description
        $link['description'] = '';
        $metaTags = $xpath->query('/html/head/meta[@name="description"]/@content');
        if($metaTags->length > 0) {
            foreach($metaTags as $metaTag) {
                $link['description'] .=  $metaTag->value;
            }
        }else {
            $pTags = $dom->getElementsByTagName('p');
            foreach($pTags as $pTag) {
                if(strlen($link['description']) < 255) {
                    $link['description'] .= $pTag->textContent;
                }
            }
        }
        $link['description'] = Sanitize($link['description']);
        
        // host
        $link['host'] = parse_url($link['url'], PHP_URL_HOST);
        
        // images
        $images = $dom->getElementsByTagName('img');
        foreach($images as $image) {
            $src = Sanitize($image->getAttribute('src'));
            if(!preg_match("/(?:f|ht)tps?/i", parse_url($src, PHP_URL_SCHEME))) {
                continue;
            }
            if(!in_array($src, $tmp)) {
                $size = getimagesize($src);
                $img['w'] = ($size[0] && $size[0] < 90)? $size[0] : 90;
                $img['src'] = $src;
                $tmp[] = $src;
                $link['imgs'][] = $img;
            }
        }
        $link['imgsCount'] = count($link['imgs']);
        
    }
}

// assign variables
$smarty->assign('view', $view);
$smarty->assign('link', $link);

// return data
$data['status'] = 'success';
$data['value'] = $smarty->fetch("ajax.publisher.scraper.tpl");
exit(json_encode($data));

?>