<?php
/**
 * who like|dislike|favorite post
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Not Logged In</div><div class="popupContent"><div class="pt5 pb5 pr5 pl5 fs12 white">Please log in to continue.</div></div>');
}

// check user verified
if($userArray['Verified'] == "N") {
    exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Confirm Your Email Address</div><div class="popupContent"><div class="pt5 pb5 pr5 pl5"><p class="fs11 mb10 tjustify">Before you can interact with other users, you need to confirm your email address. A confirmation email has been sent to <span class="blue fwb">'.$userArray['UserEmail'].'</span>. Check your email to complete your account confirmation.</p><p><small>Don\'t see the confirmation email? <span class="uiButtonText blue resendEmail">Resend to '.$userArray['UserEmail'].'</span></small><br/><small>Don\'t have access to '.$userArray['UserEmail'].'? <span class="uiButtonText blue changeEmail">Change your contact email.</span></small></p></div></div>');
}

// check page parameters
if(!isset($_POST['id']) || !isset($_POST['view'])) {
    exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('parameters error[1] @/ajax/posts/who'.'</div>'));
}

// valid inputs
$valid['view'] = array('like', 'dislike', 'favorite');
if(!in_array($_POST['view'], $valid['view'])) {
    exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('parameters error[2] @/ajax/posts/who'.'</div>'));
}

// parse parameters
$id = ParseId($_POST['id'], 3);
if(!$id) {
    exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('parameters error[3] @/ajax/posts/who'.'</div>'));
}
$postType = $id[1];
$postId = $id[2];
$authorId = $id[3];

// check if valid post
$checkPost = $db->query(sprintf("SELECT * FROM posts WHERE PostType = %s AND PostID = %s AND UserID = %s", SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), SafeSQL($authorId, 'int') )) or die('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('sql error #1 @/ajax/posts/who'.'</div>'));
if($checkPost->num_rows == 0) {
    exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent"><div class="highlightContianer">This content is unavailable, It may be deleted by the author</div></div>');
}

// who like
if($_POST['view'] == "like") {
    $getUsers = $db->query(sprintf("SELECT user.UserID, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM users_posts_likes stats INNER JOIN users user ON stats.UserID = user.UserID WHERE stats.PostType = %s AND stats.PostID = %s AND stats.Liked = 'Y' LIMIT 0,".$systemSetting['MaxWho'], SafeSQL($postType, 'int'), SafeSQL($postId, 'int') )) or die('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('sql error #2 @/ajax/posts/who'.'</div>'));
// who dislike
}elseif ($_POST['view'] == "dislike") {
    $getUsers = $db->query(sprintf("SELECT user.UserID, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM users_posts_likes stats INNER JOIN users user ON stats.UserID = user.UserID WHERE stats.PostType = %s AND stats.PostID = %s AND stats.Liked = 'N' LIMIT 0,".$systemSetting['MaxWho'], SafeSQL($postType, 'int'), SafeSQL($postId, 'int') )) or die ('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('sql error #3 @/ajax/posts/who'.'</div>'));
// who favorite
}elseif ($_POST['view'] == "favorite") {
    $getUsers = $db->query(sprintf("SELECT user.UserID, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM users_posts_favorites stats INNER JOIN users user ON stats.UserID = user.UserID WHERE stats.PostType = %s AND stats.PostID = %s AND stats.Favorited = 'Y' LIMIT 0,".$systemSetting['MaxWho'], SafeSQL($postType, 'int'), SafeSQL($postId, 'int') )) or die('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('sql error #4 @/ajax/posts/who'.'</div>'));
}

if($getUsers->num_rows == 0) {
    exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent"><div class="errorContianer">There is no one '.$_POST['view'].'s this post right now.</div></div>');
}

while($userWho = $getUsers->fetch_array(MYSQLI_ASSOC)) {
    // check if post writer in user followings
    $userWho['FollowingHim'] = (in_array($userWho['UserID'], $userFollowings))? true: false;
    $usersWho[] = $userWho;
}

// assign variables
$smarty->assign('usersWho', $usersWho);
$smarty->assign('usersWhoNums', count($usersWho));
$smarty->assign('view', $_POST['view']);
    
// page footer
PageFooter("popup.who");

?>