<?php
/**
 * send new message
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['id']) || !isset($_POST['message'])) {
    exit(PopupError(ReportError('parameters error[1] @/ajax/messages/reply')));
}

// parse parameters
if(!preg_match('/^([0-9]+)$/', $_POST['id'])) {
    exit(PopupError(ReportError('parameters error[2] @/ajax/messages/reply')));
}

// check if user authorized
$checkAuth = $db->query(sprintf("SELECT UserID FROM messages_conversations_users WHERE ConversationID = %s AND UserID = %s", Secure($_POST['id'], 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/messages/reply')));
if($checkAuth->num_rows == 0) {
    exit(ReportError('authorization error @/ajax/messages/delete'));
}

// get recipients
$getRecipients = $db->query(sprintf("SELECT UserID FROM messages_conversations_users WHERE ConversationID = %s AND UserID != %s", Secure($_POST['id'], 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/messages/reply')));
while($recipient = $getRecipients->fetch_array(MYSQLI_ASSOC)) {
    $recipients[] = $recipient['UserID'];
}

// update the conversation
$db->query(sprintf("UPDATE messages_conversations SET LastMessage = %s, LastSenderID = %s, LastUpdate = %s WHERE ID = %s", SafeSQL($_POST['message']), SafeSQL($userArray['UserID'], 'int'), $now, SafeSQL($_POST['id'], 'int') )) or die(PopupError(ReportError('sql error #3 @/ajax/messages/reply')));

// insert message
$db->query(sprintf("INSERT INTO messages (UserID, Text, ConversationID, Time) VALUES (%s, %s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($_POST['message']), SafeSQL($_POST['id'], 'int'), $now )) or die(PopupError(ReportError('sql error #4 @/ajax/messages/reply')));
$messageId = $db->insert_id;

// update recipients
foreach($recipients as $recipient) {
    $db->query(sprintf("UPDATE messages_conversations_users SET Messages = Messages + 1, Viewed = 'N' WHERE ConversationID = %s AND UserID = %s", SafeSQL($_POST['id'], 'int'), SafeSQL($recipient, 'int'))) or die(PopupError(ReportError('sql error #5 @/ajax/messages/reply')));
    $db->query(sprintf("INSERT INTO messages_users (MessageID, UserID) VALUES (%s, %s)", SafeSQL($messageId, 'int'), SafeSQL($recipient, 'int') )) or die(PopupError(ReportError('sql error #6 @/ajax/messages/reply')));
    $db->query(sprintf("UPDATE users SET UserNewMessages = UserNewMessages + 1, UserMessaged = 'Y' WHERE UserID = %s", SafeSQL($recipient, 'int'))) or die(PopupError(ReportError('sql error #7 @/ajax/messages/reply')));
}

// update sender
$db->query(sprintf("UPDATE messages_conversations_users SET Messages = Messages + 1 WHERE ConversationID = %s AND UserID = %s", SafeSQL($_POST['id'], 'int'), SafeSQL($userArray['UserID'], 'int'))) or die(PopupError(ReportError('sql error #8 @/ajax/messages/reply')));
$db->query(sprintf("INSERT INTO messages_users (MessageID, UserID) VALUES (%s, %s)", SafeSQL($messageId, 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #9 @/ajax/messages/reply')));
$db->query(sprintf("UPDATE users SET UserMessaged = 'Y' WHERE UserID = %s", SafeSQL($userArray['UserID'], 'int'))) or die(PopupError(ReportError('sql error #10 @/ajax/messages/reply')));

// get message array
$message = array('ConversationID'=> $_POST['id'], 'ID'=> $messageId, 'Time'=> $now, 'Text'=> DecodeText($_POST['message']));
$smarty->assign('message', $message);

// return data
$data['status'] = 'success';
$data['value'] = $smarty->fetch("ajax.messages.reply.tpl");
exit(json_encode($data));

?>