<?php
/**
 * modify conversation
 * 
 * @package Sngine
 * @author Yehia Abed
 * @version 0.3
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['id']) || !isset($_POST['do'])) {
    exit(PopupError(ReportError('parameters error[1] @/ajax/messages/modify')));
}

// valid inputs
$valid['do'] = array('read', 'unread');
if(!in_array($_POST['do'], $valid['do'])) {
    exit(PopupError(ReportError('parameters error[2] @/ajax/messages/modify')));
}

// parse parameters
$id = ParseId($_POST['id']);
if(!$id) {
    exit(PopupError(ReportError('parameters error[3] @/ajax/messages/modify')));
}
$conversationId = $id[1];

// check if user authorized
$checkAuth = $db->query(sprintf("SELECT * FROM messages_conversations_users WHERE ConversationID = %s AND UserID = %s", Secure($conversationId, 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/messages/modify')));
if($checkAuth->num_rows == 0) {
    exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
}

// mark as read
if($_POST['do'] == "read") {
    $db->query(sprintf("UPDATE messages_conversations_users SET Viewed = 'Y' WHERE ConversationID = %s AND UserID = %s", SafeSQL($conversationId, 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/messages/modify')));
    $db->query(sprintf("UPDATE users SET UserMessaged = 'Y' WHERE UserID = %s", SafeSQL($userArray['UserID'], 'int'))) or die(PopupError(ReportError('sql error #3 @/ajax/messages/modify')));
// mark as unread
}else {
    $db->query(sprintf("UPDATE messages_conversations_users SET Viewed = 'N' WHERE ConversationID = %s AND UserID = %s", SafeSQL($conversationId, 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #4 @/ajax/messages/modify')));
    $db->query(sprintf("UPDATE users SET UserMessaged = 'Y' WHERE UserID = %s", SafeSQL($userArray['UserID'], 'int'))) or die(ReportError('sql error #5 @/ajax/messages/modify'));
}

?>