<?php
/**
 * send new chat message
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['to']) || !isset($_POST['message'])) {
    exit(PopupError(ReportError('parameters error[1] @/ajax/messages/chat/send')));
}

// parse parameters
if(!preg_match('/^([0-9]+)$/', $_POST['to'])) {
    exit(PopupError(ReportError('parameters error[2] @/ajax/messages/chat/send')));
}

// check if empty
if(IsEmpty($_POST['message'])) {
    exit(PopupError('Please enter a valid (non-empty) message.'));
}

// start new conversation
if(!isset($_SESSION['openChatBoxes'][$_POST['to']])) {
    // insert a new conversation
    $db->query(sprintf("INSERT INTO messages_conversations (Recipients, LastMessage, LastSenderID, LastUpdate, IsChat) VALUES (1, %s, %s, %s, 'Y')", Secure($_POST['message']), Secure($userArray['UserID'], 'int'), $now )) or die(PopupError(ReportError('sql error #1 @/ajax/messages/chat/send')));
    $conversationId = $db->insert_id;
    // insert message
    $db->query(sprintf("INSERT INTO messages (UserID, Text, ConversationID, Time) VALUES (%s, %s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), Secure($_POST['message']), SafeSQL($conversationId, 'int'), $now )) or die(PopupError(ReportError('sql error #2 @/ajax/messages/chat/send')));
    $messageId = $db->insert_id;
    // update recipient
    $db->query(sprintf("INSERT INTO messages_conversations_users (ConversationID, UserID) VALUES (%s, %s)", SafeSQL($conversationId, 'int'), Secure($_POST['to'], 'int') )) or die(PopupError(ReportError('sql error #3 @/ajax/messages/chat/send')));
    $db->query(sprintf("INSERT INTO messages_users (MessageID, UserID) VALUES (%s, %s)", SafeSQL($messageId, 'int'), Secure($_POST['to'], 'int') )) or die(PopupError(ReportError('sql error #4 @/ajax/messages/chat/send')));
    $db->query(sprintf("UPDATE users SET UserMessages = UserMessages + 1, UserMessaged = 'Y' WHERE UserID = %s", Secure($_POST['to'], 'int'))) or die(PopupError(ReportError('sql error #5 @/ajax/messages/chat/send')));
    // update sender
    $db->query(sprintf("INSERT INTO messages_conversations_users (ConversationID, UserID, Viewed) VALUES (%s, %s, 'Y')", SafeSQL($conversationId, 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #6 @/ajax/messages/chat/send')));
    $db->query(sprintf("INSERT INTO messages_users (MessageID, UserID) VALUES (%s, %s)", SafeSQL($messageId, 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #7 @/ajax/messages/chat/send')));
    $db->query(sprintf("UPDATE users SET UserMessages = UserMessages + 1, UserMessaged = 'Y' WHERE UserID = %s", SafeSQL($userArray['UserID'], 'int'))) or die(PopupError(ReportError('sql error #8 @/ajax/messages/chat/send')));
    // update session
    $_SESSION['openChatBoxes'][$_POST['to']] = $conversationId;
// update opened conversation
}else {
    // update the conversation
    $db->query(sprintf("UPDATE messages_conversations SET LastMessage = %s, LastSenderID = %s, LastUpdate = %s WHERE ID = %s", SafeSQL($_POST['message']), SafeSQL($userArray['UserID'], 'int'), $now, SafeSQL($_SESSION['openChatBoxes'][$_POST['to']], 'int') )) or die(PopupError(ReportError('sql error #9 @/ajax/messages/chat/send')));
    // insert message
    $db->query(sprintf("INSERT INTO messages (UserID, Text, ConversationID, Time) VALUES (%s, %s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($_POST['message']), SafeSQL($_SESSION['openChatBoxes'][$_POST['to']], 'int'), $now )) or die(PopupError(ReportError('sql error #10 @/ajax/messages/chat/send')));
    $messageId = $db->insert_id;
    // update recipient
    $db->query(sprintf("UPDATE messages_conversations_users SET Messages = Messages + 1, Viewed = 'N' WHERE ConversationID = %s AND UserID = %s", SafeSQL($_SESSION['openChatBoxes'][$_POST['to']], 'int'), SafeSQL($_POST['to'], 'int'))) or die(PopupError(ReportError('sql error #11 @/ajax/messages/chat/send')));
    $db->query(sprintf("INSERT INTO messages_users (MessageID, UserID) VALUES (%s, %s)", SafeSQL($messageId, 'int'), SafeSQL($_POST['to'], 'int') )) or die(PopupError(ReportError('sql error #12 @/ajax/messages/chat/send')));
    $db->query(sprintf("UPDATE users SET UserMessaged = 'Y' WHERE UserID = %s", SafeSQL($_POST['to'], 'int'))) or die(PopupError(ReportError('sql error #13 @/ajax/messages/chat/send')));
    // update sender
    $db->query(sprintf("UPDATE messages_conversations_users SET Messages = Messages + 1 WHERE ConversationID = %s AND UserID = %s", SafeSQL($_SESSION['openChatBoxes'][$_POST['to']], 'int'), SafeSQL($userArray['UserID'], 'int'))) or die(PopupError(ReportError('sql error #14 @/ajax/messages/chat/send')));
    $db->query(sprintf("INSERT INTO messages_users (MessageID, UserID) VALUES (%s, %s)", SafeSQL($messageId, 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #15 @/ajax/messages/chat/send')));
    $db->query(sprintf("UPDATE users SET UserMessaged = 'Y' WHERE UserID = %s", SafeSQL($userArray['UserID'], 'int'))) or die(PopupError(ReportError('sql error #16 @/ajax/messages/chat/send')));
}

// get message array
$message = array('Time'=> $now, 'Text'=> DecodeText($_POST['message']));
$smarty->assign('message', $message);

// return data
$data['status'] = 'success';
$data['value'] = $smarty->fetch("ajax.chat.send.tpl");
exit(json_encode($data));

?>