<?php
/**
 * get coversation messages
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist & verified
if(!$userExist || $userArray['Verified'] == "N") {
    exit();
}

// check page parameters
if(!isset($_GET['id'])) {
    exit(ReportError('parameters error[1] @/ajax/messages/chat'));
}

// parse parameters
$id = ParseId($_GET['id']);
if(!$id) {
    exit(ReportError('parameters error[2] @/ajax/messages/chat'));
}
$conversationId = $id[1];
$messageId = $id[2];

// check if user authorized
$checkAuth = $db->query(sprintf("SELECT * FROM messages_conversations_users WHERE ConversationID = %s AND UserID = %s", SafeSQL($conversationId, 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(ReportError('sql error #1 @/ajax/messages/chat'));
if($checkAuth->num_rows == 0) {
    exit(ReportError('authorization error @/ajax/messages/chat'));
}

// get messages
$getMessages = $db->query(sprintf("SELECT msg.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM messages_users msg_user INNER JOIN messages msg ON msg_user.MessageID = msg.ID INNER JOIN users user ON msg.UserID = user.UserID WHERE msg.ConversationID = %s AND msg_user.MessageID > %s AND msg_user.UserID = %s AND msg_user.Deleted = 'N' ORDER BY msg.Time ASC", SafeSQL($conversationId, 'int'), SafeSQL($messageId, 'int'), SafeSQL($userArray['UserID']) )) or die(ReportError('sql error #2 @/ajax/messages/chat'));
if($getMessages->num_rows == 0) {
    exit;
}
while($message = $getMessages->fetch_array(MYSQLI_ASSOC)) {
    $messages[] = $message;
}
$smarty->assign('messages', $messages);

// update conversation & user
$db->query(sprintf("UPDATE messages_conversations_users SET Viewed = 'Y' WHERE ConversationID = %s AND UserID = %s", SafeSQL($conversationId, 'int'), SafeSQL($userArray['UserID'], 'int'))) or die(ReportError('sql error #3 @/ajax/messages/chat'));
$db->query(sprintf("UPDATE users SET UserMessaged = 'Y' WHERE UserID = %s", SafeSQL($userArray['UserID'], 'int'))) or die(ReportError('sql error #4 @/ajax/messages/chat'));

// page footer
PageFooter("ajax.messages.chat");

?>