<?php
/**
 * modify media posts
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['id']) || !isset($_POST['do'])) {
    exit(ReportError('parameters error[1] @/ajax/media/posts/modify'));
}

// valid inputs
$valid['do'] = array('like', 'unlike', 'dislike', 'undislike', 'favorite', 'unfavorite');
if(!in_array($_POST['do'], $valid['do'])) {
    exit(ReportError('parameters error[2] @/ajax/media/posts/modify'));
}

// parse parameters
$id = ParseId($_POST['id'], 4);
if(!$id) {
    exit(ReportError('parameters error[3] @/ajax/media/posts/modify'));
}
$mediaId = $id[1];
$postType = $id[2];
$isAlbum = $id[3];
$authorId = $id[4];

// get media table
$mediaTable = GetMediaTable($postType, $isAlbum);
if(!$mediaTable) {
    exit(ReportError('parameters error[4] @/ajax/media/posts/modify'));
}
$isAlbum = ($isAlbum == 1)? 'Y' : 'N';

// check if valid post
$checkPost = $db->query(sprintf("SELECT * FROM %s WHERE ID = %s", $mediaTable, SafeSQL($mediaId, 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/media/posts/modify')));
if($checkPost->num_rows == 0) {
    exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
}

// like
if($_POST['do'] == "like") {
    // insert status
    $db->query(sprintf("INSERT INTO users_media_likes (UserID, PostType, IsAlbum, MediaID, Liked) VALUES (%s, %s, %s, %s, 'Y')", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postType, 'int'), SafeSQL($isAlbum), SafeSQL($mediaId, 'int') )) || exit;
    // update app
    $db->query(sprintf("UPDATE %s SET Likes = Likes + 1 WHERE ID = %s", $mediaTable, SafeSQL($mediaId, 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/media/posts/modify')));
    // insert notification
    if($userArray['UserID'] != $authorId) {
        $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, IsMedia, IsAlbum, Time) VALUES (%s, 2, %s, %s, %s, 'Y', %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($mediaId, 'int'), SafeSQL($isAlbum), $now )) or die(PopupError(ReportError('sql error #3 @/ajax/media/posts/modify')));
        $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #4 @/ajax/media/posts/modify')));
    }
// unlike
}elseif ($_POST['do'] == "unlike") {
    // delete status
    $db->query(sprintf("DELETE FROM users_media_likes WHERE PostType = %s AND IsAlbum = %s AND MediaID = %s AND UserID = %s", SafeSQL($postType, 'int'), SafeSQL($isAlbum), SafeSQL($mediaId, 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #5 @/ajax/media/posts/modify')));
    // check affected rows
    if($db->affected_rows > 0) {
        // update app
        $db->query(sprintf("UPDATE %s SET Likes = IF(Likes=0,0,Likes-1) WHERE ID = %s", $mediaTable, SafeSQL($mediaId, 'int') )) or die(PopupError(ReportError('sql error #6 @/ajax/media/posts/modify')));
        // delete notification
        if($userArray['UserID'] != $authorId) {
            $db->query(sprintf("DELETE FROM notifications WHERE UserID = %s AND Action = 2 AND PostType = %s AND PostID = %s AND Type = 'P' AND IsMedia = 'Y' AND IsAlbum = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postType, 'int'), SafeSQL($mediaId, 'int'), SafeSQL($isAlbum) )) or die(PopupError(ReportError('sql error #7 @/ajax/media/posts/modify')));
            $db->query(sprintf("UPDATE users SET UserNotifications = IF(UserNotifications=0,0,UserNotifications-1), UserNewNotifications = IF(UserNewNotifications=0,0,UserNewNotifications-1) WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #8 @/ajax/media/posts/modify')));
        }
    }
// dislike
}elseif ($_POST['do'] == "dislike") {
    // insert status
    $db->query(sprintf("INSERT INTO users_media_likes (UserID, PostType, IsAlbum, MediaID, Liked) VALUES (%s, %s, %s, %s, 'N')", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postType, 'int'), SafeSQL($isAlbum), SafeSQL($mediaId, 'int') )) || exit;
    // update app
    $db->query(sprintf("UPDATE %s SET Dislikes = Dislikes + 1 WHERE ID = %s", $mediaTable, SafeSQL($mediaId, 'int') )) or die(PopupError(ReportError('sql error #9 @/ajax/media/posts/modify')));
    // insert notification
    if($userArray['UserID'] != $authorId) {
        $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, IsMedia, IsAlbum, Time) VALUES (%s, 3, %s, %s, %s, 'Y', %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($mediaId, 'int'), SafeSQL($isAlbum), $now )) or die(PopupError(ReportError('sql error #10 @/ajax/media/posts/modify')));
        $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #11 @/ajax/media/posts/modify')));
    }
// undislike
}elseif ($_POST['do'] == "undislike") {
    // delete status
    $db->query(sprintf("DELETE FROM users_media_likes WHERE PostType = %s AND IsAlbum = %s AND MediaID = %s AND UserID = %s", SafeSQL($postType, 'int'), SafeSQL($isAlbum), SafeSQL($mediaId, 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #12 @/ajax/media/posts/modify')));
    if($db->affected_rows > 0) {
        // update app
        $db->query(sprintf("UPDATE %s SET Dislikes = IF(Dislikes=0,0,Dislikes-1) WHERE ID = %s", $mediaTable, SafeSQL($mediaId, 'int') )) or die(PopupError(ReportError('sql error #13 @/ajax/media/posts/modify')));
        // delete notification
        if($userArray['UserID'] != $authorId) {
            $db->query(sprintf("DELETE FROM notifications WHERE UserID = %s AND Action = 3 AND PostType = %s AND PostID = %s AND Type = 'P' AND IsMedia = 'Y' AND IsAlbum = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postType, 'int'), SafeSQL($mediaId, 'int'), SafeSQL($isAlbum) )) or die(PopupError(ReportError('sql error #14 @/ajax/media/posts/modify')));
            $db->query(sprintf("UPDATE users SET UserNotifications = IF(UserNotifications=0,0,UserNotifications-1), UserNewNotifications = IF(UserNewNotifications=0,0,UserNewNotifications-1) WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #15 @/ajax/media/posts/modify')));
        }
    }
// favorite
}elseif ($_POST['do'] == "favorite") {
    // insert status
    $db->query(sprintf("INSERT INTO users_media_favorites (UserID, PostType, IsAlbum, MediaID, Favorited) VALUES (%s, %s, %s, %s, 'Y')", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postType, 'int'), SafeSQL($isAlbum), SafeSQL($mediaId, 'int') )) || exit;
    // update app
    $db->query(sprintf("UPDATE %s SET Favorits = Favorits + 1 WHERE ID = %s", $mediaTable, SafeSQL($mediaId, 'int') )) or die(PopupError(ReportError('sql error #16 @/ajax/media/posts/modify')));
    // insert notification
    if($userArray['UserID'] != $authorId) {
        $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, IsMedia, IsAlbum, Time) VALUES (%s, 4, %s, %s, %s, 'Y', %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($mediaId, 'int'), SafeSQL($isAlbum), $now )) or die(PopupError(ReportError('sql error #17 @/ajax/media/posts/modify')));
        $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #18 @/ajax/media/posts/modify')));
    }
// unfavorite
}elseif ($_POST['do'] == "unfavorite") {
    // delete status
    $db->query(sprintf("DELETE FROM users_media_favorites WHERE PostType = %s AND IsAlbum = %s AND MediaID = %s AND UserID = %s", SafeSQL($postType, 'int'), SafeSQL($isAlbum), SafeSQL($mediaId, 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #19 @/ajax/media/posts/modify')));
    if($db->affected_rows > 0) {
        // update app
        $db->query(sprintf("UPDATE %s SET Favorits = IF(Favorits=0,0,Favorits-1) WHERE ID = %s", $mediaTable, SafeSQL($mediaId, 'int') )) or die(PopupError(ReportError('sql error #20 @/ajax/media/posts/modify')));
        // delete notification
        if($userArray['UserID'] != $authorId) {
            $db->query(sprintf("DELETE FROM notifications WHERE UserID = %s AND Action = 4 AND PostType = %s AND PostID = %s AND Type = 'P' AND IsMedia = 'Y' AND IsAlbum = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postType, 'int'), SafeSQL($mediaId, 'int'), SafeSQL($isAlbum) )) or die(PopupError(ReportError('sql error #21 @/ajax/media/posts/modify')));
            $db->query(sprintf("UPDATE users SET UserNotifications = IF(UserNotifications=0,0,UserNotifications-1), UserNewNotifications = IF(UserNewNotifications=0,0,UserNewNotifications-1) WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #22 @/ajax/media/posts/modify')));
        }
    }
}

?>