<?php
/**
 * delete media posts
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['id']) || !isset($_POST['type'])) {
    exit(PopupError(ReportError('parameters error[1] @/ajax/media/posts/delete')));
}

// valid inputs
$valid['type'] = array('photo', 'video');
if(!in_array($_POST['type'], $valid['type'])) {
    exit(PopupError(ReportError('parameters error[2] @/ajax/media/posts/delete')));
}

// parse parameters
$id = ParseId($_POST['id']);
if(!$id) {
    exit(PopupError(ReportError('parameters error[3] @/ajax/media/posts/delete')));
}
$albumId = $id[1];
$sourceId = $id[2];

// prepare tables
if($_POST['type'] == "photo") {
    $postType = 3;
    $postTable = 'posts_photos';
    $albumTable = 'posts_photos_albums';
    $sourceTable = 'posts_photos_sources';
}else {
    $postType = 4;
    $postTable = 'posts_videos';
    $albumTable = 'posts_videos_albums';
    $sourceTable = 'posts_videos_sources';
}

// get media
$getMedia = $db->query(sprintf("SELECT source.ID, album.UserID, album.ThumbnailID, album.IsWall FROM %s source INNER JOIN %s album ON source.AlbumID = album.ID WHERE album.ID = %s AND source.ID = %s", $sourceTable, $albumTable, SafeSQL($albumId, 'int'), SafeSQL($sourceId, 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/media/posts/delete')));
if($getMedia->num_rows == 0) {
    exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
}
$media = $getMedia->fetch_array(MYSQLI_ASSOC);
$thumbnailId = ($media['ThumbnailID'] == $sourceId)? 0 : $media['ThumbnailID'];

// check if user authorized
if($media['UserID'] != $userArray['UserID'] && $userArray['UserGroup'] == 3) {
    SystemError("This content is currently unavailable", "The page you requested cannot be displayed right now. It may be temporarily unavailable, the link you clicked on may have expired, or you may not have permission to view this page.");
}

// delete media
$db->query(sprintf("DELETE FROM %s WHERE ID = %s", $sourceTable, SafeSQL($sourceId, 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/media/posts/delete')));

// update album
$db->query(sprintf("UPDATE %s SET ThumbnailID = %s, Total = IF(Total=0,0,Total-1) WHERE ID = %s", $albumTable, SafeSQL($thumbnailId), SafeSQL($albumId, 'int') )) or die(PopupError(ReportError('sql error #3 @/ajax/media/posts/delete')));

// delete post if in wall album
if($media['IsWall'] == "Y") {
    $db->query(sprintf("DELETE FROM posts WHERE PostType = %s AND PostID = (SELECT ID FROM %s WHERE IsAlbum = 'N' AND MediaID = %s)", $postType, $postTable, SafeSQL($media['ID'], 'int') )) or die(PopupError(ReportError('sql error #4 @/ajax/media/posts/delete')));
    $db->query(sprintf("DELETE FROM %s WHERE IsAlbum = 'N' AND MediaID = %s", $postTable, SafeSQL($media['ID'], 'int') )) or die(PopupError(ReportError('sql error #5 @/ajax/media/posts/delete')));
}

?>