<?php
/**
 * post new media comment|reply
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['id']) || !isset($_POST['text']) || !isset($_POST['type'])) {
    exit(PopupError(ReportError('parameters error[1] @/ajax/media/comments/post')));
}

// valid inputs
$valid['type'] = array('reply', 'comment');
if(!in_array($_POST['type'], $valid['type'])) {
    exit(PopupError(ReportError('parameters error[2] @/ajax/media/comments/post')));
}

// parse parameters
$id = ParseId($_POST['id'], 4);
if(!$id) {
    exit(PopupError(ReportError('parameters error[3] @/ajax/media/comments/post')));
}

// check if empty
if(IsEmpty($_POST['text'])) {
    exit(PopupError('Please enter a valid (non-empty) comment.'));
}

// check length
if(strlen($_POST['text']) > 1024) {
    exit(PopupError('Your comment is too long. The maximum length is 1024 characters.'));
}

// sanitize inputs
$_POST['text'] = Sanitize($_POST['text']);

if($_POST['type'] == "reply") {
    
    // parse parameters
    $commentId = $id[1];
    $postType = $id[2];
    $mediaId = $id[3];
    $authorId = $id[4];
    
    // parse parameters
    $pid = ParseId($_POST['pid'], 4);
    if(!$pid) {
        exit(PopupError(ReportError('parameters error[4] @/ajax/media/comments/post')));
    }
    $isAlbum = $pid[3];
    $postAuthorId = $pid[4];
    
    // get media table
    $mediaTable = GetMediaTable($postType, $isAlbum);
    if(!$mediaTable) {
        exit(PopupError(ReportError('parameters error[5] @/ajax/media/comments/post')));
    }
    $isAlbum = ($isAlbum == 1)? 'Y' : 'N';
    
    // check if valid comment
    $checkPost = $db->query(sprintf("SELECT * FROM posts_comments_media WHERE ID = %s AND UserID = %s AND PostType = %s AND IsAlbum = %s AND MediaID = %s", SafeSQL($commentId, 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($isAlbum), SafeSQL($mediaId, 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/comments/post')));
    if($checkPost->num_rows == 0) {
        exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
    }
    
    // insert comment
    $db->query(sprintf("UPDATE posts_comments_media SET Replies = Replies + 1 WHERE ID = %s", SafeSQL($commentId, 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/media/comments/post')));
    $db->query(sprintf("INSERT INTO posts_comments_media (UserID, PostType, IsAlbum, MediaID, Text, Time, ParentNodeID) VALUES (%s, %s, %s, %s, %s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postType, 'int'), SafeSQL($isAlbum), SafeSQL($mediaId, 'int'), SafeSQL($_POST['text']), $now, SafeSQL($commentId, 'int') )) or die(PopupError(ReportError('sql error #3 @/ajax/media/comments/post')));
    $commentId = $db->insert_id;
    
    // update post
    $db->query(sprintf("UPDATE %s SET Comments = Comments + 1 WHERE ID = %s", $mediaTable, SafeSQL($mediaId, 'int') )) or die(PopupError(ReportError('sql error #4 @/ajax/media/comments/post')));
    
    // insert notification | comment author
    if($userArray['UserID'] != $authorId) {
        $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, Type, IsMedia, IsAlbum, Time) VALUES (%s, 5, %s, %s, %s, 'C', 'Y', %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($mediaId, 'int'), SafeSQL($isAlbum), $now )) or die(PopupError(ReportError('sql error #5 @/ajax/media/comments/post')));
        $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #6 @/ajax/media/comments/post')));
    }
    
    // insert notification | post author
    if($userArray['UserID'] != $postAuthorId) {
        $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, IsMedia, IsAlbum, Time) VALUES (%s, 5, %s, %s, %s, 'Y', %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postAuthorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($mediaId, 'int'), SafeSQL($isAlbum), $now )) or die(PopupError(ReportError('sql error #7 @/ajax/media/comments/post')));
        $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", SafeSQL($postAuthorId, 'int'))) or die(PopupError(ReportError('sql error #8 @/ajax/media/comments/post')));
    }
    
}else {
    
    // parse parameters
    $mediaId = $id[1];
    $postType = $id[2];
    $isAlbum = $id[3];
    $authorId = $id[4];
    
    // get media table
    $mediaTable = GetMediaTable($postType, $isAlbum);
    if(!$mediaTable) {
        exit(PopupError(ReportError('parameters error[6] @/ajax/media/comments/post')));
    }
    $isAlbum = ($isAlbum == 1)? 'Y' : 'N';
    
    // check if valid post
    $checkPost = $db->query(sprintf("SELECT * FROM %s WHERE ID = %s", $mediaTable, SafeSQL($mediaId, 'int') )) or die(PopupError(ReportError('sql error #9 @/ajax/comments/post')));
    if($checkPost->num_rows == 0) {
        exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
    }
    
    // insert comment
    $db->query(sprintf("INSERT INTO posts_comments_media (UserID, PostType, IsAlbum, MediaID, Text, Time) VALUES (%s, %s, %s, %s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postType, 'int'), SafeSQL($isAlbum), SafeSQL($mediaId, 'int'), SafeSQL($_POST['text']), $now )) or die(PopupError(ReportError('sql error #10 @/ajax/media/comments/post')));
    $commentId = $db->insert_id;
    
    // update post
    $db->query(sprintf("UPDATE %s SET Comments = Comments + 1, PComments = PComments + 1 WHERE ID = %s", $mediaTable, SafeSQL($mediaId, 'int') )) or die(PopupError(ReportError('sql error #11 @/ajax/media/comments/post')));
    
    // insert notification
    if($userArray['UserID'] != $authorId) {
        $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, IsMedia, IsAlbum, Time) VALUES (%s, 5, %s, %s, %s, 'Y', %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($mediaId, 'int'), SafeSQL($isAlbum), $now )) or die(PopupError(ReportError('sql error #12 @/ajax/media/comments/post')));
        $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #13 @/ajax/media/comments/post')));
    }
    
}

$post['PostType'] = $postType;
$post['PostID'] = $mediaId;
$comment['ID'] = $commentId;
$comment['Time'] = $now;
$comment['Text'] = DecodeText($_POST['text']);

// assigne variables
$smarty->assign('post', $post);
$smarty->assign('comment', $comment);
$smarty->assign('type', $_POST['type']);

// return data
$data['status'] = 'success';
$data['value'] = $smarty->fetch("ajax.comments.post.tpl");
exit(json_encode($data));

?>