<?php
/**
 * modify media comments
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['id']) || !isset($_POST['do'])) {
    exit(PopupError(ReportError('parameters error[1] @/ajax/media/comments/modify')));
}

// valid inputs
$valid['do'] = array('like', 'unlike', 'dislike', 'undislike');
if(!in_array($_POST['do'], $valid['do'])) {
    exit(PopupError(ReportError('parameters error[2] @/ajax/media/comments/modify')));
}

// parse parameters
$id = ParseId($_POST['id'], 5);
if(!$id) {
    exit(PopupError(ReportError('parameters error[3] @/ajax/media/comments/modify')));
}
$commentId = $id[1];
$postType = $id[2];
$mediaId = $id[3];
$authorId = $id[4];
$isAlbum = $id[5];

$isAlbum = ($isAlbum == 1)? 'Y' : 'N';

// check if valid comment
$checkComment = $db->query(sprintf("SELECT * FROM posts_comments_media WHERE ID = %s AND UserID = %s AND PostType = %s AND IsAlbum = %s AND MediaID = %s", SafeSQL($commentId, 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($isAlbum), SafeSQL($mediaId, 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/media/comments/modify')));
if($checkComment->num_rows == 0) {
    exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
}

// like
if($_POST['do'] == "like") {
    // insert status
    $db->query(sprintf("INSERT INTO users_comments_media_likes (UserID, CommentID, Liked) VALUES (%s, %s, 'Y')", SafeSQL($userArray['UserID'], 'int'), SafeSQL($commentId, 'int') )) || exit;
    // update comments
    $db->query(sprintf("UPDATE posts_comments_media SET Likes = Likes + 1 WHERE ID = %s", SafeSQL($commentId, 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/media/comments/modify')));
    // insert notification
    if($userArray['UserID'] != $authorId) {
        $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, Type, IsMedia, IsAlbum, Time) VALUES (%s, 2, %s, %s, %s, 'C', 'Y', %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($mediaId, 'int'), SafeSQL($isAlbum), $now )) or die(PopupError(ReportError('sql error #3 @/ajax/media/comments/modify')));
        $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #4 @/ajax/media/comments/modify')));
    }
// unlike
}elseif ($_POST['do'] == "unlike") {
    // delete status
    $db->query(sprintf("DELETE FROM users_comments_media_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($commentId, 'int'))) or die(PopupError(ReportError('sql error #5 @/ajax/media/comments/modify')));
    // check affected rows
    if($db->affected_rows > 0) {
        // update comments
        $db->query(sprintf("UPDATE posts_comments_media SET Likes = IF(Likes=0,0,Likes-1) WHERE ID = %s", SafeSQL($commentId, 'int'))) or die(PopupError(ReportError('sql error #6 @/ajax/media/comments/modify')));
        // delete notification
        if($userArray['UserID'] != $authorId) {
            $db->query(sprintf("DELETE FROM notifications WHERE UserID = %s AND Action = 2 AND PostType = %s AND PostID = %s AND Type = 'C' AND IsMedia = 'Y' AND IsAlbum = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postType, 'int'), SafeSQL($mediaId, 'int'), SafeSQL($isAlbum) )) or die(PopupError(ReportError('sql error #7 @/ajax/posts/modify')));
            $db->query(sprintf("UPDATE users SET UserNotifications = IF(UserNotifications=0,0,UserNotifications-1), UserNewNotifications = IF(UserNewNotifications=0,0,UserNewNotifications-1) WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #8 @/ajax/posts/modify')));
        }
    }
// dislike
}elseif ($_POST['do'] == "dislike") {
    // insert status
    $db->query(sprintf("INSERT INTO users_comments_media_likes (UserID, CommentID, Liked) VALUES (%s, %s, 'N')", SafeSQL($userArray['UserID'], 'int'), SafeSQL($commentId, 'int') )) || exit;
    // update comments
    $db->query(sprintf("UPDATE posts_comments_media SET Dislikes = Dislikes + 1 WHERE ID = %s", SafeSQL($commentId, 'int') )) or die(PopupError(ReportError('sql error #9 @/ajax/media/comments/modify')));
    // insert notification
    if($userArray['UserID'] != $authorId) {
        $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, Type, IsMedia, IsAlbum, Time) VALUES (%s, 3, %s, %s, %s, 'C', 'Y', %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($mediaId, 'int'), SafeSQL($isAlbum), $now )) or die(PopupError(ReportError('sql error #10 @/ajax/media/comments/modify')));
        $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #11 @/ajax/media/comments/modify')));
    }
// undislike
}elseif ($_POST['do'] == "undislike") {
    // delete status
    $db->query(sprintf("DELETE FROM users_comments_media_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($commentId, 'int'))) or die(PopupError(ReportError('sql error #12 @/ajax/media/comments/modify')));
    // check affected rows
    if($db->affected_rows > 0) {
        // update comments
        $db->query(sprintf("UPDATE posts_comments_media SET Dislikes = IF(Dislikes=0,0,Dislikes-1) WHERE ID = %s", SafeSQL($commentId, 'int'))) or die(PopupError(ReportError('sql error #13 @/ajax/media/comments/modify')));
        // delete notification
        if($userArray['UserID'] != $authorId) {
            $db->query(sprintf("DELETE FROM notifications WHERE UserID = %s AND Action = 3 AND PostType = %s AND PostID = %s AND Type = 'C' AND IsMedia = 'Y' AND IsAlbum = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postType, 'int'), SafeSQL($mediaId, 'int'), SafeSQL($isAlbum) )) or die(PopupError(ReportError('sql error #14 @/ajax/posts/modify')));
            $db->query(sprintf("UPDATE users SET UserNotifications = IF(UserNotifications=0,0,UserNotifications-1), UserNewNotifications = IF(UserNewNotifications=0,0,UserNewNotifications-1) WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #15 @/ajax/posts/modify')));
        }
    }
}

?>