<?php
/**
 * delete media comments
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['id'])) {
    exit(PopupError(ReportError('parameters error[1] @/ajax/media/comments/delete')));
}

// parse parameters
$id = ParseId($_POST['id'], 4);
if(!$id) {
    exit(PopupError(ReportError('parameters error[2] @/ajax/media/comments/delete')));
}
$commentId = $id[1];
$postType = $id[2];
$mediaId = $id[3];
$authorId = $id[4];

// check if valid comment
$checkAuth = $db->query(sprintf("SELECT * FROM posts_comments_media WHERE PostType = %s AND MediaID = %s AND UserID = %s AND ID = %s", SafeSQL($postType, 'int'), SafeSQL($mediaId, 'int'), SafeSQL($authorId, 'int'), SafeSQL($commentId, 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/media/comments/delete')));
if($checkAuth->num_rows == 0) {
    exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
}

// check if user authorized
if($authorId != $userArray['UserID'] && $userArray['UserGroup'] == 3) {
    exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
}

// get comment
$comment = $checkAuth->fetch_array(MYSQLI_ASSOC);
$isAlbum = ($comment['IsAlbum'] == 'Y')? 1 : 0;

// get media table
$mediaTable = GetMediaTable($postType, $isAlbum);
if(!$mediaTable) {
    exit(PopupError(ReportError('parameters error[4] @/ajax/media/comments/delete')));
}

// delete comment
$db->query(sprintf("DELETE FROM posts_comments_media WHERE ID = %s", SafeSQL($commentId, 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/media/comments/delete')));

// update parent comment & post
if($comment['ParentNodeID'] != 0) {
    $db->query(sprintf("UPDATE posts_comments_media SET Replies = IF(Replies=0,0,Replies-1) WHERE ID = %s", SafeSQL($comment['ParentNodeID'], 'int') )) or die(PopupError(ReportError('sql error #3 @/ajax/media/comments/delete')));
    $db->query(sprintf("UPDATE %s SET Comments = IF(Comments=0,0,Comments-1) WHERE ID = %s", $mediaTable, SafeSQL($mediaId, 'int') )) or die(PopupError(ReportError('sql error #4 @/ajax/media/comments/delete')));
}else {
    $db->query(sprintf("UPDATE %s SET Comments = IF(Comments=0,0,Comments-1-%s), PComments = IF(PComments=0,0,PComments-1) WHERE ID = %s", $mediaTable, SafeSQL($comment['Replies'], 'int'), SafeSQL($mediaId, 'int') )) or die(PopupError(ReportError('sql error #5 @/ajax/media/comments/delete')));
}

?>