<?php
/**
 * fetch external content
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../../';
require($depth.'kernal.php');
require_once($depth.'libs/class-scraper.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['url']) || empty($_POST['url'])) {
    exit(PopupError(PopupError('Please enter a valid (non-empty) link.')));
}

// check if empty
if(IsEmpty($_POST['url'])) {
    exit(PopupError('Please enter a valid (non-empty) link.'));
}

// sanitize url
$link['url'] = Scraper::Sanitize($_POST['url']);

// check if video link
try {
    $check = Scraper::IsVideo($link['url']);
}catch (Exception $e) {
    exit(PopupError($e->getMessage()));
}

if($check !== false) {
    $link['id'] =  $check['ID'];
    $link['type'] =  $check['Type'];
    $link['thumbnail'] =  $check['Thumbnail'];
}else {
    exit(PopupError('Please enter a valid video link.'));
}

// return data
$data['status'] = 'success';
$data['value'] = $link;
exit(json_encode($data));

?>