<?php
/**
 * delete album
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['id']) || !isset($_POST['type'])) {
    exit(PopupError(ReportError('parameters error[1] @/ajax/media/albums/delete')));
}

// valid inputs
$valid['type'] = array('photo', 'video');
if(!in_array($_POST['type'], $valid['type'])) {
    exit(PopupError(ReportError('parameters error[2] @/ajax/media/albums/delete')));
}

// parse parameters
if(!preg_match('/^([0-9]+)$/', $_POST['id'])) {
    exit(PopupError(ReportError('parameters error[3] @/ajax/media/albums/delete')));
}

// prepare tables
if($_POST['type'] == "photo") {
    $postType = 3;
    $postTable = 'posts_photos';
    $albumTable = 'posts_photos_albums';
    $sourceTable = 'posts_photos_sources';
}else {
    $postType = 4;
    $postTable = 'posts_videos';
    $albumTable = 'posts_videos_albums';
    $sourceTable = 'posts_videos_sources';
}

// get album
$getAlbum = $db->query(sprintf("SELECT * FROM %s WHERE ID = %s", $albumTable, Secure($_POST['id'], 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/media/albums/delete')));
if($getAlbum->num_rows == 0) {
    exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
}
$album = $getAlbum->fetch_array(MYSQLI_ASSOC);

// check if user authorized
if($album['UserID'] != $userArray['UserID'] && $userArray['UserGroup'] == 3) {
    SystemError("This content is currently unavailable", "The page you requested cannot be displayed right now. It may be temporarily unavailable, the link you clicked on may have expired, or you may not have permission to view this page.");
}

// check if published
if($album['IsWall'] == 'N') {
    $checkPost = $db->query(sprintf("SELECT ID FROM %s WHERE IsAlbum = 'Y' AND MediaID = %s", $postTable, SafeSQL($album['ID'], 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/media/albums/delete')));
    if($checkPost->num_rows == 0) {
        $album['published'] = false;
    }else {
        $album['published'] = true;
    }
}else {
    exit(PopupError('<div class="errorContianer">You can not delete your wall album</div>'));
}

// delete album
$db->query(sprintf("DELETE FROM %s WHERE ID = %s", $albumTable, SafeSQL($_POST['id'], 'int') )) or die(PopupError(ReportError('sql error #3 @/ajax/media/albums/delete')));

// delete album resources
$db->query(sprintf("DELETE FROM %s WHERE AlbumID = %s", $sourceTable, SafeSQL($_POST['id'], 'int') )) or die(PopupError(ReportError('sql error #4 @/ajax/media/albums/delete')));

// delete post
if($album['published']) {
    $post = $checkPost->fetch_array(MYSQLI_ASSOC);
    $db->query(sprintf("DELETE FROM posts WHERE PostType = %s AND PostID = %s", $postType, SafeSQL($post['ID'], 'int') )) or die(PopupError(ReportError('sql error #5 @/ajax/media/albums/delete')));
    $db->query(sprintf("DELETE FROM %s WHERE IsAlbum = 'Y' AND MediaID = %s", $postTable, SafeSQL($_POST['id'], 'int') )) or die(PopupError(ReportError('sql error #6 @/ajax/media/albums/delete')));
}

?>