<?php
/**
 * tricker
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist & verified
if(!$userExist || $userArray['Verified'] == "N") {
    exit();
}

// check page parameters
if(!isset($_GET['get'])) {
    exit(ReportError('parameters error[1] @/ajax/live/tricker'));
}

// valid inputs
$valid['get'] = array('all', 'new');
if(!in_array($_GET['get'], $valid['get'])) {
    exit(ReportError('parameters error[2] @/ajax/live/tricker'));
}

// prepare where statement
if(count($userBlockedUsers) > 0) {
    $whereStatement = ' WHERE notifi.UserID NOT IN (' . implode(',', $userBlockedUsers) . ')';
}

if($_GET['get'] == "new") {
    $checkNew = $db->query(sprintf("SELECT * FROM notifications WHERE ID > %s", Secure($_GET['startPoint'], 'int') )) or die(ReportError('sql error #1 @/ajax/live/tricker'));
    if($checkNew->num_rows == 0) {
        exit;
    }
}

// function to get author name
function getAuthor($userId) {
    global $db;
    $getAuthor = $db->query(sprintf("SELECT UserFirstName, UserLastName FROM users WHERE UserID = %s", Secure($userId, 'int'))) or die(ReportError('sql error #2 @/ajax/live/tricker'));
    $author = $getAuthor->fetch_array(MYSQLI_ASSOC);
    return $author['UserFirstName'].' '.$author['UserLastName'];
}

// get notifications
$getNotifications = $db->query("SELECT notifi.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathSmall AS UserAvatarPath FROM notifications notifi INNER JOIN users user ON notifi.UserID = user.UserID ".$whereStatement." ORDER BY notifi.ID DESC LIMIT 5") or die(ReportError('sql error #3 @/ajax/live/tricker'));
if($getNotifications->num_rows == 0) {
    exit;
}
while($notification = $getNotifications->fetch_array(MYSQLI_ASSOC)) {
    // follow
    if($notification['Action'] == 1) {
        $notification['link'] = SITE_URL."/".$notification['UserName'];
        $author = getAuthor($notification['AuthorID']);
        $notification['message'] = 'now follow '.$author;
    // like post|comment|answer
    }elseif ($notification['Action'] == 2) {
        $author = getAuthor($notification['AuthorID']);
        if($notification['Type'] == 'P') {
            $message = GetNotification($notification['PostType'], $notification['PostID'], $notification['IsMedia'], $notification['IsAlbum']);
            $notification['link'] = $message['link'];
            $notification['message'] = 'likes '.$author.' '.$message['app'];
        }elseif ($notification['Type'] == 'C') {
            $message = GetNotification($notification['PostType'], $notification['PostID'], $notification['IsMedia'], $notification['IsAlbum']);
            $notification['link'] = $message['link'];
            $notification['message'] = 'likes '.$author.' comment';
        }else {
            $notification['message'] = 'voted '.$author.' answer up';
        }
    // dislike post|comment|answer
    }elseif ($notification['Action'] == 3) {
        $author = getAuthor($notification['AuthorID']);
        if($notification['Type'] == 'P') {
            $message = GetNotification($notification['PostType'], $notification['PostID'], $notification['IsMedia'], $notification['IsAlbum']);
            $notification['link'] = $message['link'];
            $notification['message'] = 'dislikes '.$author.' '.$message['app'];
        }elseif ($notification['Type'] == 'C') {
            $message = GetNotification($notification['PostType'], $notification['PostID'], $notification['IsMedia'], $notification['IsAlbum']);
            $notification['link'] = $message['link'];
            $notification['message'] = 'dislikes '.$author.' comment';
        }else {
            $notification['message'] = 'voted '.$author.' answer down';
        }
    // favorite
    }elseif ($notification['Action'] == 4) {
        $author = getAuthor($notification['AuthorID']);
        $message = GetNotification($notification['PostType'], $notification['PostID'], $notification['IsMedia'], $notification['IsAlbum']);
        $notification['link'] = $message['link'];
        $notification['message'] = 'favorites '.$author.' '.$message['app'];
    // comment|reply
    }elseif ($notification['Action'] == 5) {
        $author = getAuthor($notification['AuthorID']);
        $message = GetNotification($notification['PostType'], $notification['PostID'], $notification['IsMedia'], $notification['IsAlbum']);
        $notification['link'] = $message['link'];
        if($notification['Type'] == 'P') {
            $notification['message'] = 'commented on '.$author.' '.$message['app'];
        }else {
            $notification['message'] = 'reply to '.$author.' comment';
        }
    // answer
    }elseif ($notification['Action'] == 6) {
        $author = getAuthor($notification['AuthorID']);
        $message = GetNotification($notification['PostType'], $notification['PostID']);
        $notification['link'] = $message['link'];
        $notification['message'] = 'answered '.$author.' '.$message['app'];
    // noted
    }elseif ($notification['Action'] == 7) {
        $author = getAuthor($notification['AuthorID']);
        $message = GetNotification($notification['PostType'], $notification['PostID']);
        $notification['link'] = $message['link'];
        $notification['message'] = 'added a note to '.$author.' answer';
    // poll
    }elseif ($notification['Action'] == 8) {
        $author = getAuthor($notification['AuthorID']);
        $message = GetNotification($notification['PostType'], $notification['PostID']);
        $notification['link'] = $message['link'];
        $notification['message'] = 'voted in '.$author.' poll';
    // @mention
    }elseif ($notification['Action'] == 9) {
        $author = getAuthor($notification['AuthorID']);
        if($notification['Type'] == 'P') {
            $message = GetNotification($notification['PostType'], $notification['PostID']);
            $notification['link'] = $message['link'];
            $notification['message'] = 'posted on '.$author.' wall';
        }elseif ($notification['Type'] == 'C') {
            $message = GetNotification($notification['PostType'], $notification['PostID']);
            $notification['link'] = $message['link'];
            $notification['message'] = 'mention '.$author.' in a comment';
        }
    }
    $notifications[] = $notification;
}

// get firs
$firstNode = $notifications[0]['ID'];

// assign variables
$smarty->assign('firstNode', $firstNode);
$smarty->assign('notifications', $notifications);

// page footer
PageFooter("ajax.live.tricker");

?>