<?php
/**
 * reset messages|notifications
 * 
 * @package Sngine
 * @author Yehia Abed
 * @version 0.3
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist & verified
if(!$userExist || $userArray['Verified'] == "N") {
    exit();
}

// check page parameters
if(!isset($_POST['app'])) {
    exit(ReportError('parameters error[1] @/ajax/live/reset'));
}

// valid inputs
$valid['app'] = array('messages', 'notifications');
if(!in_array($_POST['app'], $valid['app'])) {
    exit(ReportError('parameters error[2] @/ajax/live/reset'));
}

// reset messages
if($_POST['app'] == "messages") {
    if($userArray['UserNewMessages'] == 0) {
        exit;
    }
    $db->query(sprintf("UPDATE users SET UserNewMessages = 0 WHERE UserID = %s", SafeSQL($userArray['UserID'], 'int') )) or die(ReportError('sql error #1 @/ajax/live/reset'));
// reset notifications
}else {
    if($userArray['UserNewNotifications'] == 0) {
        exit;
    }
    $db->query(sprintf("UPDATE users SET UserNewNotifications = 0 WHERE UserID = %s", SafeSQL($userArray['UserID'], 'int') )) or die(ReportError('sql error #2 @/ajax/live/reset'));
    // make all viewed
    $getNotifications = $db->query(sprintf("SELECT * FROM notifications WHERE AuthorID = %s AND Viewed = 'N'", SafeSQL($userArray['UserID'], 'int') )) or die(ReportError('sql error #3 @/ajax/live/reset'));
    if($getNotifications->num_rows > 0) {
        while($notification = $getNotifications->fetch_array(MYSQLI_ASSOC)) {
            $db->query(sprintf("UPDATE notifications SET Viewed = 'Y' WHERE ID = %s", SafeSQL($notification['ID'], 'int') )) or die(ReportError('sql error #4 @/ajax/live/reset'));
        }
    }
}

?>