<?php
/**
 * notifications
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist & verified
if(!$userExist || $userArray['Verified'] == "N") {
    exit();
}

// check page parameters
if(!isset($_GET['get']) || !isset($_GET['counter'])) {
    exit(ReportError('parameters error[1] @/ajax/live/notifications'));
}

// valid inputs
$valid['get'] = array('all', 'new');
if(!in_array($_GET['get'], $valid['get'])) {
    exit(ReportError('parameters error[2] @/ajax/live/notifications'));
}

// parse parameters
if(!preg_match('/^([0-9]+)$/', $_GET['counter'])) {
    exit(ReportError('parameters error[3] @/ajax/live/notifications'));
}

// check user notifications
if($userArray['UserNotifications'] == 0) {
    exit;
}
if($_GET['get'] == "new" && $userArray['UserNewNotifications'] <= $_GET['counter']) {
    if($userArray['UserNewNotifications'] == 0) {
        echo "reseted";
    }
    exit;
}

// block spammers
if(count($userBlockedUsers) > 0) {
    $whereStatement = ' AND notifi.UserID NOT IN (' . implode(',', $userBlockedUsers) . ')';
}

// get notifications
$getNotifications = $db->query(sprintf("SELECT notifi.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathSmall AS UserAvatarPath FROM notifications notifi INNER JOIN users user ON notifi.UserID = user.UserID WHERE notifi.AuthorID = %s ".$whereStatement." ORDER BY notifi.Time DESC LIMIT 5", SafeSQL($userArray['UserID'], 'int') )) or die(ReportError('sql error #1 @/ajax/live/notifications'));
if($getNotifications->num_rows == 0) {
    exit;
}
while($notification = $getNotifications->fetch_array(MYSQLI_ASSOC)) {
    // follow
    if($notification['Action'] == 1) {
        $notification['link'] = SITE_URL."/".$notification['UserName'];
        $notification['message'] = 'now follow you';
    // like post|comment|answer
    }elseif ($notification['Action'] == 2) {
        if($notification['Type'] == 'P') {
            $message = GetNotification($notification['PostType'], $notification['PostID'], $notification['IsMedia'], $notification['IsAlbum']);
            $notification['link'] = $message['link'];
            $notification['message'] = 'likes your '.$message['app'];
        }elseif ($notification['Type'] == 'C') {
            $message = GetNotification($notification['PostType'], $notification['PostID'], $notification['IsMedia'], $notification['IsAlbum']);
            $notification['link'] = $message['link'];
            $notification['message'] = 'likes your comment';
        }else {
            $notification['message'] = 'voted your answer up';
        }
    // dislike post|comment|answer
    }elseif ($notification['Action'] == 3) {
        if($notification['Type'] == 'P') {
            $message = GetNotification($notification['PostType'], $notification['PostID'], $notification['IsMedia'], $notification['IsAlbum']);
            $notification['link'] = $message['link'];
            $notification['message'] = 'dislikes your '.$message['app'];
        }elseif ($notification['Type'] == 'C') {
            $message = GetNotification($notification['PostType'], $notification['PostID'], $notification['IsMedia'], $notification['IsAlbum']);
            $notification['link'] = $message['link'];
            $notification['message'] = 'dislikes your comment';
        }else {
            $notification['message'] = 'voted your answer down';
        }
    // favorite
    }elseif ($notification['Action'] == 4) {
        $message = GetNotification($notification['PostType'], $notification['PostID'], $notification['IsMedia'], $notification['IsAlbum']);
        $notification['link'] = $message['link'];
        $notification['message'] = 'favorites your '.$message['app'];
    // comment|reply
    }elseif ($notification['Action'] == 5) {
        $message = GetNotification($notification['PostType'], $notification['PostID'], $notification['IsMedia'], $notification['IsAlbum']);
        $notification['link'] = $message['link'];
        if($notification['Type'] == 'P') {
            $notification['message'] = 'commented on your '.$message['app'];
        }else {
            $notification['message'] = 'reply to your comment';
        }
    // answer
    }elseif ($notification['Action'] == 6) {
        $message = GetNotification($notification['PostType'], $notification['PostID']);
        $notification['link'] = $message['link'];
        $notification['message'] = 'answered your '.$message['app'];
    // noted
    }elseif ($notification['Action'] == 7) {
        $message = GetNotification($notification['PostType'], $notification['PostID']);
        $notification['link'] = $message['link'];
        $notification['message'] = 'added a note to your answer';
    // poll
    }elseif ($notification['Action'] == 8) {
        $message = GetNotification($notification['PostType'], $notification['PostID']);
        $notification['link'] = $message['link'];
        $notification['message'] = 'voted in your poll';
    // @mention
    }elseif ($notification['Action'] == 9) {
        if($notification['Type'] == 'P') {
            $message = GetNotification($notification['PostType'], $notification['PostID']);
            $notification['link'] = $message['link'];
            $notification['message'] = 'posted on your wall';
        }elseif ($notification['Type'] == 'C') {
            $message = GetNotification($notification['PostType'], $notification['PostID']);
            $notification['link'] = $message['link'];
            $notification['message'] = 'mention you in a comment';
        }
    }
    $notifications[] = $notification;
}
$smarty->assign('notifications', $notifications);

// page footer
PageFooter("ajax.live.notifications");

?>