<?php

/**
 * (C)Copyright 2011. All Rights Reserved.
 * This software has been designed and developed by Yehia Abed
 *
 * Sngine -> ajax -> comments -> who.php - who like|dislike|favorite comment
 *
 * Version 0.2 [Start Date: 04/01/2009]
 */
    
    // define the page
    $page = "popup.who";
    
    // fetch required files
    $depth = '../../';
    require_once($depth.'kernal.php');
    
    // check user exist
    if(!$userExist) {
        exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Not Logged In</div><div class="popupContent"><div class="pt5 pb5 pr5 pl5 fs12 white">Please log in to continue.</div></div>');
    }
    
    // check user verified
    if($userArray['Verified'] == "N") {
        exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Confirm Your Email Address</div><div class="popupContent"><div class="pt5 pb5 pr5 pl5"><p class="fs11 mb10 tjustify">Before you can interact with other users, you need to confirm your email address. A confirmation email has been sent to <span class="blue fwb">'.$userArray['UserEmail'].'</span>. Check your email to complete your account confirmation.</p><p><small>Don\'t see the confirmation email? <span class="uiButtonText blue resendEmail">Resend to '.$userArray['UserEmail'].'</span></small><br/><small>Don\'t have access to '.$userArray['UserEmail'].'? <span class="uiButtonText blue changeEmail">Change your contact email.</span></small></p></div></div>');
    }
    
    // check page parameters
    if(!isset($_POST['id']) || !isset($_POST['view'])) {
        exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('parameters error[1] @/ajax/comments/who'.'</div>'));
    }
    
    // valid inputs
    $valid['view'] = array('like', 'dislike');
    if(!in_array($_POST['view'], $valid['view'])) {
        exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('parameters error[2] @/ajax/comments/who'.'</div>'));
    }
    
    // parse parameters
    if(!preg_match('/^([0-9]+)$/', $_POST['id'])) {
        exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('parameters error[3] @/ajax/comments/who'.'</div>'));
    }
    
    // check if valid comment
    $checkComment = $db->query(sprintf("SELECT * FROM posts_comments WHERE ID = %s", SafeSQL($_POST['id'], 'int') )) or die('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('sql error #1 @/ajax/comments/who'.'</div>'));
    if($checkComment->num_rows == 0) {
        exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent"><div class="highlightContianer">This content is unavailable, It may be deleted by the author</div></div>');
    }
    
    // who like
    if($_POST['view'] == "like") {
        $getUsers = $db->query(sprintf("SELECT user.UserID, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM users_comments_likes stats INNER JOIN users user ON stats.UserID = user.UserID WHERE stats.CommentID = %s AND stats.Liked = 'Y' LIMIT 0,".$systemSetting['MaxWho'], SafeSQL($_POST['id'], 'int') )) or die('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('sql error #2 @/ajax/comments/who'.'</div>'));
    // who dislike
    }elseif ($_POST['view'] == "dislike") {
        $getUsers = $db->query(sprintf("SELECT user.UserID, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM users_comments_likes stats INNER JOIN users user ON stats.UserID = user.UserID WHERE stats.CommentID = %s AND stats.Liked = 'N' LIMIT 0,".$systemSetting['MaxWho'], SafeSQL($_POST['id'], 'int') )) or die('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('sql error #3 @/ajax/comments/who'.'</div>'));
    }
    
    if($getUsers->num_rows == 0) {
        exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent"><div class="errorContianer">There is no one '.$_POST['view'].'s this comment right now.</div></div>');
    }
    
    while($userWho = $getUsers->fetch_array(MYSQLI_ASSOC)) {
        
        // check if post writer in user followings
        $userWho['FollowingHim'] = (in_array($userWho['UserID'], $userFollowings))? true: false;
        
        $usersWho[] = $userWho;
    }
    
    $smarty->assign('usersWho', $usersWho);
    $smarty->assign('usersWhoNums', count($usersWho));
    $smarty->assign('view', $_POST['view']);
    
    // display page templete
    $smarty->display("$page.tpl");
    
?>