<?php

/**
 * (C)Copyright 2011. All Rights Reserved.
 * This software has been designed and developed by Yehia Abed
 *
 * Sngine -> ajax -> comments -> delete.php - delete comments
 *
 * Version 0.2 [Start Date: 04/01/2009]
 */
    
    // fetch required files
    $depth = '../../';
    require_once($depth.'kernal.php');
    
    // check user exist
    if(!$userExist) {
        exit(PopupError('Please log in to continue.', 'Not Logged In'));
    }
    
    // check user verified
    if($userArray['Verified'] == "N") {
        VerifyError();
    }
    
    // check page parameters
    if(!isset($_POST['id'])) {
        exit(PopupError(ReportError('parameters error[1] @/ajax/comments/delete')));
    }
    
    // parse parameters
    $id = ParseId($_POST['id'], 4);
    if(!$id) {
        exit(PopupError(ReportError('parameters error[2] @/ajax/comments/delete')));
    }
    $commentId = $id[1];
    $postType = $id[2];
    $postId = $id[3];
    $authorId = $id[4];
    
    // check if valid comment
    $checkComment = $db->query(sprintf("SELECT * FROM posts_comments WHERE PostType = %s AND PostID = %s AND UserID = %s AND ID = %s", SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), SafeSQL($authorId, 'int'), SafeSQL($commentId, 'int') )) or die(ReportError('sql error #1 @/ajax/comments/delete'));
    if($checkComment->num_rows == 0) {
        exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
    }
    
    // check if user authorized
    if($authorId != $userArray['UserID'] && $userArray['UserGroup'] == 3) {
        exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
    }
    
    // get comment
    $comment = $checkComment->fetch_array(MYSQLI_ASSOC);
    
    // delete comment
    $db->query(sprintf("DELETE FROM posts_comments WHERE ID = %s", SafeSQL($commentId, 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/comments/delete')));
    
    // update parent comment & post
    if($comment['ParentNodeID'] != 0) {
        $db->query(sprintf("UPDATE posts_comments SET Replies = IF(Replies=0,0,Replies-1) WHERE ID = %s", SafeSQL($comment['ParentNodeID'], 'int') )) or die(PopupError(ReportError('sql error #3 @/ajax/comments/delete')));
        $db->query(sprintf("UPDATE posts SET Comments = IF(Comments=0,0,Comments-1) WHERE PostType = %s AND PostID = %s", SafeSQL($postType, 'int'), SafeSQL($postId, 'int') )) or die(PopupError(ReportError('sql error #4 @/ajax/comments/delete')));
    }else {
        if($comment['Replies'] > 0) {
            $db->query(sprintf("DELETE FROM posts_comments WHERE ParentNodeID = %s", SafeSQL($commentId, 'int') )) or die(PopupError(ReportError('sql error #5 @/ajax/comments/delete')));
        }
        $db->query(sprintf("UPDATE posts SET Comments = IF(Comments=0,0,Comments-1-%s), PComments = IF(PComments=0,0,PComments-1) WHERE PostType = %s AND PostID = %s", SafeSQL($comment['Replies'], 'int'), SafeSQL($postType, 'int'), SafeSQL($postId, 'int') )) or die(PopupError(ReportError('sql error #6 @/ajax/comments/delete')));
    }
    
?>