<?php
/**
 * index
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
require('kernal.php');

// check admin exist
if(!$adminExist) {
    GetLogin($translate->__("You have to login to access this page"));
}

if(!isset($_GET['tab']) || $_GET['tab'] == "dashboard") {
    $view = "dashboard";
    PageHeader($translate->__("Dashboard"));
    
    // get insights
    $getUsers = $db->query("SELECT * FROM users");
    $insights['totalUsers'] = $getUsers->num_rows;
    
    $getOnlines = $db->query("SELECT * FROM users_online");
    $insights['onlines'] = $getOnlines->num_rows;
    
    $lastMonth = $now - (4*7*24*60*60);
    $getActiveUsers = $db->query("SELECT * FROM users WHERE UserLastLogin > ".$lastMonth);
    $insights['activeUsers'] = $getActiveUsers->num_rows;
    $insights['activeUsersPercent'] = round(($insights['activeUsers']/$insights['totalUsers'])*100, 2);
    
    $getNotVerified = $db->query("SELECT * FROM users WHERE Verified = 'N'");
    $insights['notVerifiedUsers'] = $getNotVerified->num_rows;
    $insights['notVerifiedUsersPercent'] = round(($insights['notVerifiedUsers']/$insights['totalUsers'])*100, 2);
    
    $getNotUpdated = $db->query("SELECT * FROM users WHERE Updated = 'N'");
    $insights['notUpdatedUsers'] = $getNotUpdated->num_rows;
    $insights['notUpdatedUsersPercent'] = round(($insights['notUpdatedUsers']/$insights['totalUsers'])*100, 2);
    
    $insights['updatedUsers'] = $insights['totalUsers'] - $insights['notUpdatedUsers'];
    $insights['updatedUsersPercent'] = round(($insights['updatedUsers']/$insights['totalUsers'])*100, 2);
    
    $getBlocked = $db->query("SELECT * FROM users WHERE Blocked = 'Y'");
    $insights['blockedUsers'] = $getBlocked->num_rows;
    
    $getMale = $db->query("SELECT * FROM users WHERE UserSex = 'M'");
    $insights['maleUsers'] = $getMale->num_rows;
    $getFemale = $db->query("SELECT * FROM users WHERE UserSex = 'F'");
    $insights['femaleUsers'] = $getFemale->num_rows;
    $insights['malePercent'] = round(($insights['maleUsers']/ ($insights['maleUsers'] + $insights['femaleUsers']) )*100, 2);
    $insights['femalePercent'] = round(($insights['femaleUsers']/ ($insights['maleUsers'] + $insights['femaleUsers']) )*100, 2);
    
    $getUsersConnections = $db->query("SELECT * FROM users_followings");
    $insights['usersConnections'] = $getUsersConnections->num_rows;
    
    $getMessages = $db->query("SELECT * FROM messages");
    $insights['messages'] = $getMessages->num_rows;
    
    $getNotifications = $db->query("SELECT * FROM notifications");
    $insights['notifications'] = $getNotifications->num_rows;
    
    $getPosts = $db->query("SELECT * FROM posts");
    $insights['posts'] = $getPosts->num_rows;
    
    $getPComments = $db->query("SELECT * FROM posts_comments");
    $getMComments = $db->query("SELECT * FROM posts_comments_media");
    $insights['pcomments'] = $getPComments->num_rows;
    $insights['mcomments'] = $getMComments->num_rows;
    $insights['comments'] = $insights['pcomments'] + $insights['mcomments'];
    
    $insights['totPosts'] = $insights['posts'] + $insights['comments'];
    
    $getFavorites = $db->query("SELECT * FROM users_posts_favorites");
    $insights['favorites'] = $getFavorites->num_rows;
    
    $getPostsLikes = $db->query("SELECT * FROM users_posts_likes");
    $insights['postsLikes'] = $getPostsLikes->num_rows;
    
    $getCLikes = $db->query("SELECT * FROM users_comments_likes");
    $getCMLikes = $db->query("SELECT * FROM users_comments_media_likes");
    $insights['clikes'] = $getCLikes->num_rows;
    $insights['cmlikes'] = $getCMLikes->num_rows;
    $insights['commentsLikes'] = $insights['clikes'] + $insights['cmlikes'];
    
    $insights['totLikes'] = $insights['postsLikes'] + $insights['commentsLikes'];
    
    // assign variables
    $smarty->assign('insights', $insights);
    
}elseif ($_GET['tab'] == "settings") {
    $view = "settings";
    PageHeader($translate->__("Settings"));
    if(isset($_POST['submit'])) {
        // prepare settings
        $_POST['site_active'] = ($_POST['site_active'] == "Y")? "Y" : "N";
        $_POST['registration_active'] = ($_POST['registration_active'] == "Y")? "Y" : "N";
        // update settings
        $db->query(sprintf("UPDATE system_settings SET SystemLive = %s, SystemMessage = %s, RegistrationLive = %s, SystemTitle = %s, SystemDescription = %s, SystemDomain = %s, SystemURL = %s, RECAPTCHA_PUBLICKEY = %s, RECAPTCHA_PRIVATEKEY = %s, TW_APPID = %s, TW_SECRET = %s, FB_APPID = %s, FB_SECRET = %s, MaxResults = %s, MaxFeeds = %s, MaxMediaFeeds = %s, MaxQComments = %s, MaxQCommentsViewed = %s, MaxComments = %s, MaxReplies = %s, MaxAnswers = %s, MaxNotes = %s, MaxWho = %s, MaxPeople = %s, MaxConversations = %s", Secure($_POST['site_active']), Secure($_POST['shutdown_message']), Secure($_POST['registration_active']), Secure($_POST['SystemTitle']), Secure($_POST['SystemDescription']), Secure($_POST['SystemDomain']), Secure($_POST['SystemURL']), Secure($_POST['RECAPTCHA_PUBLICKEY']), Secure($_POST['RECAPTCHA_PRIVATEKEY']), Secure($_POST['TW_APPID']), Secure($_POST['TW_SECRET']), Secure($_POST['FB_APPID']), Secure($_POST['FB_SECRET']), Secure($_POST['MaxResults'], 'int'), Secure($_POST['MaxFeeds'], 'int'), Secure($_POST['MaxMediaFeeds'], 'int'), Secure($_POST['MaxQComments'], 'int'), Secure($_POST['MaxQCommentsViewed'], 'int'), Secure($_POST['MaxComments'], 'int'), Secure($_POST['MaxReplies'], 'int'), Secure($_POST['MaxAnswers'], 'int'), Secure($_POST['MaxNotes'], 'int'), Secure($_POST['MaxWho'], 'int'), Secure($_POST['MaxPeople'], 'int'), Secure($_POST['MaxConversations'], 'int') )) or SQLError();
        header('Location: '.SITE_URL.'/admin/index.php?tab=settings&saved');
    }
    if(isset($_GET['saved'])) {
        $smarty->assign('highlight', $translate->__("Saved Settings Successfully"));
    }
}else {
    SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
}

// assign variables
$smarty->assign('view', $view);

// page footer
PageFooter("index");

?>