<?php
/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @since         3.3.3
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 */
namespace Cake\Test\TestCase\TestSuite;

use Cake\Mailer\Email;
use Cake\Mailer\TransportFactory;
use Cake\Mailer\Transport\DebugTransport;
use Cake\TestSuite\EmailAssertTrait;
use Cake\TestSuite\TestCase;
use TestApp\Mailer\TestUserMailer;

class EmailAssertTraitTest extends TestCase
{
    use EmailAssertTrait;

    public function setUp()
    {
        parent::setUp();
        TransportFactory::setConfig('debug', ['className' => DebugTransport::class]);
    }

    public function tearDown()
    {
        parent::tearDown();
        TransportFactory::drop('debug');
    }

    public function testFunctional()
    {
        $mailer = $this->getMockForMailer(TestUserMailer::class);
        $email = $mailer->getEmailForAssertion();
        $this->assertSame($this->_email, $email);

        $mailer->invite('lorenzo@cakephp.org');
        $this->assertEmailSubject('CakePHP');
        $this->assertEmailFrom('jadb@cakephp.org');
        $this->assertEmailTo('lorenzo@cakephp.org');
        $this->assertEmailToContains('lorenzo@cakephp.org');
        $this->assertEmailToContains('lorenzo@cakephp.org', 'lorenzo@cakephp.org');
        $this->assertEmailCcContains('markstory@cakephp.org');
        $this->assertEmailCcContains('admad@cakephp.org', 'Adnan');
        $this->assertEmailBccContains('dereuromark@cakephp.org');
        $this->assertEmailBccContains('antograssiot@cakephp.org');
        $this->assertEmailTextMessageContains('Hello lorenzo@cakephp.org');
        $this->assertEmailAttachmentsContains('TestUserMailer.php');
        $this->assertEmailAttachmentsContains('TestMailer.php', [
            'file' => dirname(dirname(__DIR__)) . DS . 'test_app' . DS . 'TestApp' . DS . 'Mailer' . DS . 'TestMailer.php',
            'mimetype' => 'text/x-php',
        ]);
    }
}
