<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
global $post;
?>

<div class="blog_template bdp_blog_template overlay_horizontal blog-wrap lb-item" data-id="<?php echo get_the_date('d/m/Y'); ?>" data-description="<?php echo get_the_title(); ?>">
    <?php do_action('bdp_before_post_content'); ?>
    <div class="post_hentry">
        <div class="post_content_wrap">

            <div class="photo post-image">
                <?php
                if (has_post_thumbnail()) {
                    ?>
                    <a href="<?php echo get_permalink($post->ID); ?>">
                        <?php
                        $url = wp_get_attachment_url(get_post_thumbnail_id());
                        $width = isset($bdp_settings['item_width']) ? $bdp_settings['item_width'] : 400;
                        $height = isset($bdp_settings['item_height']) ? $bdp_settings['item_height'] : 570;
                        $resizedImage = bdp_resize($url, $width, $height, true);
                        echo '<img src="' . $resizedImage["url"] . '" width="' . $resizedImage["width"] . '" height="' . $resizedImage["height"] . '" title="' . $post->post_title . '" alt="' . $post->post_title . '" />';
                        ?>
                    </a>
                    <?php
                    if (isset($bdp_settings['pinterest_image_share']) && $bdp_settings['pinterest_image_share'] == 1) {
                        echo bdp_pinterest($post->ID);
                    }
                    ?>
                    <?php
                } elseif (isset($bdp_settings['bdp_default_image_id']) && $bdp_settings['bdp_default_image_id'] != '') {
                    ?>
                    <a href="<?php echo get_permalink($post->ID); ?>">
                        <?php
                        $url = wp_get_attachment_url($bdp_settings['bdp_default_image_id']);
                        $width = isset($bdp_settings['item_width']) ? $bdp_settings['item_width'] : 400;
                        $height = isset($bdp_settings['item_height']) ? $bdp_settings['item_height'] : 570;
                        $resizedImage = bdp_resize($url, $width, $height, true);
                        echo '<img src="' . $resizedImage["url"] . '" width="' . $resizedImage["width"] . '" height="' . $resizedImage["height"] . '" title="' . $post->post_title . '" alt="' . $post->post_title . '" />';
                        ?>
                    </a>
                    <?php
                }
                ?>
            </div>
            <div class="lb-overlay"> </div>
            <div class="post-content-area">
                <div class="metadatabox">
                    <?php
                    $display_date = $bdp_settings['display_date'];
                    if ($display_date == 1) {
                        $date_link = (isset($bdp_settings['disable_link_date']) && $bdp_settings['disable_link_date'] == 1) ? false : true;
                        $date_format = get_option('date_format');
                        $ar_year = get_the_time('Y');
                        $ar_month = get_the_time('m');
                        $ar_day = get_the_time('d');
                        ?>
                        <span class="mdate">                            
                            <?php
                            echo ($date_link) ? '<a href="' . get_day_link($ar_year, $ar_month, $ar_day) . '">' : '';
                            echo '<i class="fa fa-calendar-o"></i>';
                            echo apply_filters('bdp_date_format', get_the_time($date_format, $post->ID), $post->ID);
                            echo ($date_link) ? '</a>' : '';
                            ?>
                        </span>
                        <?php
                    }
                    if ($bdp_settings['display_author'] == 1) {
                        $author_link = (isset($bdp_settings['disable_link_author']) && $bdp_settings['disable_link_author'] == 1) ? false : true;
                        ?>
                        <span class="mauthor">
                            <i class="fa fa-user"></i>
                            <?php
                            echo ($author_link) ? '<a href="' . get_author_posts_url(get_the_author_meta('ID')) . '">' : '';
                            printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_author());
                            echo ($author_link) ? '</a>' : '';
                            ?>
                        </span>
                        <?php
                    }
                    if ($bdp_settings['display_comment_count'] == 1) {
                        if (!post_password_required() && ( comments_open() || get_comments_number() )) :
                            ?>
                            <span class="comment">
                                <i class="fa fa-comments"></i> 
                                <?php
                                if (isset($bdp_settings['disable_link_comment']) && $bdp_settings['disable_link_comment'] == 1) {
                                    comments_number('0', '1', '%');
                                } else {
                                    comments_popup_link('0', '1', '%');
                                }
                                ?>
                            </span>
                            <?php
                        endif;
                    }
                    if (isset($bdp_settings['display_postlike']) && $bdp_settings['display_postlike'] == 1) {
                        echo do_shortcode('[likebtn_shortcode]');
                    }
                    ?>
                </div>
                <div class="post-title">
                    <?php
                    $bdp_post_title_link = isset($bdp_settings['bdp_post_title_link']) ? $bdp_settings['bdp_post_title_link'] : 1;
                    if ($bdp_post_title_link == 1) {
                        echo '<a href="' . get_the_permalink() . '" title="' . get_the_title() . '">';
                    }
                    printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_title());
                    if ($bdp_post_title_link == 1) {
                        echo '</a>';
                    }
                    ?>
                </div>
                <div class="post_content">
                    <?php
                    echo bdp_get_content($post->ID, $bdp_settings['rss_use_excerpt'], $bdp_settings['txtExcerptlength'], $bdp_settings);
                    ?>
                </div>                
                <div class="blog_footer">
                    <?php
                    if ($bdp_settings['txtReadmoretext'] != '' && $bdp_settings['rss_use_excerpt'] == 1) {
                        echo '<div class="read-more-div"><a class="more-tag" href="' . get_permalink($post->ID) . '">' . $bdp_settings['txtReadmoretext'] . ' </a></div>';
                    }
                    if ($bdp_settings['custom_post_type'] == 'post') {
                        if (isset($bdp_settings['display_category']) && $bdp_settings['display_category'] == 1) {
                            ?>
                            <div class="categories">
                                <i class="fa fa-folder"></i>
                                <?php
                                $categories_list = get_the_category_list(', ');
                                $categories_link = (isset($bdp_settings['disable_link_category']) && $bdp_settings['disable_link_category'] == 1) ? true : false;
                                if ($categories_link) {
                                    $categories_list = strip_tags($categories_list);
                                }
                                if ($categories_list) {
                                    printf(__('Categories : %2$s', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $categories_list);
                                }
                                ?>
                            </div>
                            <?php
                        }
                        if (isset($bdp_settings['display_tag']) && $bdp_settings['display_tag'] == 1) {
                            $tags_list = get_the_tag_list('', ', ');
                            $tag_link = (isset($bdp_settings['disable_link_tag']) && $bdp_settings['disable_link_tag'] == 1) ? true : false;
                            if ($tag_link) {
                                $tags_list = strip_tags($tags_list);
                            }
                            if ($tags_list) {
                                ?>
                                <div class="tags">
                                    <i class="fa fa-bookmark"></i>
                                    <?php printf(__('Tags : %2$s', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $tags_list); ?>
                                </div>
                                <?php
                            }
                        }
                    } else {
                        $taxonomy_names = get_object_taxonomies($bdp_settings['custom_post_type']);
                        foreach ($taxonomy_names as $taxonomy) {
                            $sep = 1;
                            if (isset($bdp_settings["display_taxonomy_" . $taxonomy]) && $bdp_settings["display_taxonomy_" . $taxonomy] == 1) {
                                $term_list = wp_get_post_terms(get_the_ID(), $taxonomy, array("fields" => "all"));
                                $taxonomy_link = (isset($bdp_settings['disable_link_taxonomy_' . $taxonomy]) && $bdp_settings['disable_link_taxonomy_' . $taxonomy] == 1) ? false : true;
                                if (isset($taxonomy)) {
                                    if (isset($term_list) && !empty($term_list)) {
                                        ?>
                                        <div class="category">
                                            <i class="fa fa-bookmark"></i>
                                            <?php
                                            _e('Categories', BLOGDESIGNERPRO_TEXTDOMAIN);
                                            foreach ($term_list as $term_nm) {
                                                $term_link = get_term_link($term_nm);
                                                if ($sep != 1) {
                                                    ?><span class="seperater"><?php echo ', '; ?></span><?php
                                                }
                                                echo ($taxonomy_link) ? '<a href="' . $term_link . '">' : '';
                                                printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), $term_nm->name);
                                                echo ($taxonomy_link) ? '</a>' : '';
                                                $sep++;
                                            }
                                            ?>
                                        </div>
                                        <?php
                                    }
                                }
                            }
                        }
                    }
                    bdp_get_social_icons($bdp_settings);
                    ?>
                </div>
            </div>
        </div>
    </div>
    <?php do_action('bdp_after_post_content'); ?>
</div>
<?php
do_action('bdp_separator_after_post');
