<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
global $post;

$format = get_post_format($post->ID);
$post_format = '';
if ($format == "status") {
    $post_format = 'fa fa-comment';
} elseif ($format == "aside") {
    $post_format = 'fa fa-file-text';
} elseif ($format == "image") {
    $post_format = 'fa fa-file-image-o';
} elseif ($format == "gallery") {
    $post_format = 'fa fa-file-image-o';
} elseif ($format == "link") {
    $post_format = 'fa fa-link';
} elseif ($format == "quote") {
    $post_format = 'fa fa-quote-left';
} elseif ($format == "audio") {
    $post_format = 'fa fa-music';
} elseif ($format == "video") {
    $post_format = 'fa fa-video-camera';
} elseif ($format == "chat") {
    $post_format = 'fa fa-wechat';
} else {
    $post_format = 'fa fa-thumb-tack';
}
?>
<div class="bdp_blog_template elina-post-wrapper">
    <?php do_action('bdp_before_post_content'); ?>

    <div class="post-media">
        <div class="elina-postthumb">

            <?php
            if ($bdp_settings['display_author'] == 1 || $bdp_settings['display_date'] == 1) {
                ?>
                <div class="author-metabox">
                    <?php
                    if ($bdp_settings['display_author'] == 1) {
                        $author_link = (isset($bdp_settings['disable_link_author']) && $bdp_settings['disable_link_author'] == 1) ? false : true;
                        echo ($author_link) ? '<a href="' . get_author_posts_url(get_the_author_meta('ID')) . '" class="author-img" >' : '';
                        echo get_avatar(get_the_author_meta('ID'), 51);
                        echo ($author_link) ? '</a>' : '';
                    }
                    ?>
                    <div class="author-name">
                        <?php
                        if ($bdp_settings['display_author'] == 1) {
                            $author_link = (isset($bdp_settings['disable_link_author']) && $bdp_settings['disable_link_author'] == 1) ? false : true;
                            echo ($author_link) ? '<a href="' . get_author_posts_url(get_the_author_meta('ID')) . '">' : '';
                            printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_author());
                            echo ($author_link) ? '</a>' : '';
                        }

                        if ($bdp_settings['display_date'] == 1) {
                            $date_link = (isset($bdp_settings['disable_link_date']) && $bdp_settings['disable_link_date'] == 1) ? false : true;
                            ?>
                            <div class="mdate">
                                <?php
                                $date_format = get_option('date_format');
                                $ar_year = get_the_time('Y');
                                $ar_month = get_the_time('m');
                                $ar_day = get_the_time('d');

                                echo ($date_link) ? '<a class="mdate" href="' . get_day_link($ar_year, $ar_month, $ar_day) . '">' : '';
                                echo apply_filters('bdp_date_format', get_the_time($date_format, $post->ID), $post->ID);
                                echo ($date_link) ? '</a>' : '';
                                ?>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                </div>
                <?php
            }

            $post_thumbnail = 'full';
            $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
            $bdp_post_image_link = (isset($bdp_settings['bdp_post_image_link']) && $bdp_settings['bdp_post_image_link'] == 0) ? false : true;
            if (!empty($thumbnail)) {
                echo ($bdp_post_image_link) ? '<a href="' . get_permalink($post->ID) . '">' : '';
                echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                echo ($bdp_post_image_link) ? '</a>' : '';
            }

            if (isset($bdp_settings['pinterest_image_share']) && $bdp_settings['pinterest_image_share'] == 1) {
                ?>
                <div class="bdp-pinterest-share-image">
                    <?php $img_url = wp_get_attachment_url(get_post_thumbnail_id($post->ID)); ?>
                    <a target="_blank" href="<?php echo 'https://pinterest.com/pin/create/button/?url=' . get_permalink($post->ID) . '&media=' . $img_url; ?>"></a>
                </div>
                <?php
            }
            ?>
        </div>
    </div>

    <div class="post-content-area">
        <div class="elina-postformate <?php echo $post_format; ?>"></div>
        <div class="post-title">
            <?php
            $bdp_post_title_link = isset($bdp_settings['bdp_post_title_link']) ? $bdp_settings['bdp_post_title_link'] : 1;
            if ($bdp_post_title_link == 1) {
                echo '<a href="' . get_the_permalink() . '" title="' . get_the_title() . '">';
            }
            printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_title());
            if ($bdp_post_title_link == 1) {
                echo '</a>';
            }
            ?>
        </div>

        <?php
        if ($bdp_settings['custom_post_type'] == 'post' && $bdp_settings['display_category'] == 1) {
            ?>
            <div class="categories-outer">
                <div class="categories">
                    <div class="categories-inner">
                        <?php
                        $categories_list = get_the_category_list(', ');
                        $categories_link = (isset($bdp_settings['disable_link_category']) && $bdp_settings['disable_link_category'] == 1) ? true : false;
                        if ($categories_link) {
                            $categories_list = strip_tags($categories_list);
                        }
                        if ($categories_list) {
                            printf(__('%2$s', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $categories_list);
                        }
                        ?>
                    </div>
                </div>
            </div>
            <?php
        } else {
            $taxonomy_names = get_object_taxonomies($bdp_settings['custom_post_type']);
            foreach ($taxonomy_names as $taxonomy) {
                $sep = 1;
                if ($bdp_settings["display_taxonomy_" . $taxonomy] == 1) {
                    $term_list = wp_get_post_terms(get_the_ID(), $taxonomy, array("fields" => "all"));
                    $taxonomy_link = (isset($bdp_settings['disable_link_taxonomy_' . $taxonomy]) && $bdp_settings['disable_link_taxonomy_' . $taxonomy] == 1) ? false : true;
                    if (isset($taxonomy)) {
                        if (isset($term_list) && !empty($term_list)) {
                            ?>
                            <div class="categories-outer">
                                <div class="categories">
                                    <div class="categories-inner">
                                        <?php
                                        foreach ($term_list as $term_nm) {
                                            $term_link = get_term_link($term_nm);

                                            if ($sep != 1) {
                                                ?> <span class="seperater"><?php echo ', '; ?></span> <?php
                                            }
                                            echo ($taxonomy_link) ? '<a href="' . $term_link . '">' : '';
                                            printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), $term_nm->name);
                                            echo ($taxonomy_link) ? '</a>' : '';
                                            $sep++;
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                    }
                }
            }
        }
        ?>

        <div class="post_content">
            <?php
            echo bdp_get_content($post->ID, $bdp_settings['rss_use_excerpt'], $bdp_settings['txtExcerptlength'], $bdp_settings);
            ?>
        </div>
        <?php
        if ($bdp_settings['display_tag'] == 1) {
            if ($bdp_settings['custom_post_type'] == 'post') {
                $tags_list = get_the_tag_list('', ', ');
                $tag_link = (isset($bdp_settings['disable_link_tag']) && $bdp_settings['disable_link_tag'] == 1) ? true : false;
                if ($tag_link) {
                    $tags_list = strip_tags($tags_list);
                }
                if ($tags_list) {
                    ?>
                    <div class="tags">
                        <i class="fa fa-bookmark"></i>
                        <?php printf(__('Tags : %2$s', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $tags_list); ?>
                    </div>
                    <?php
                }
            }
        }

        if (get_the_content() != '') {
            if ($bdp_settings['txtReadmoretext'] != '' && $bdp_settings['rss_use_excerpt'] == 1) {
                echo '<div class="read-more-div"><a class="more-tag" href="' . get_permalink($post->ID) . '">' . $bdp_settings['txtReadmoretext'] . ' </a></div>';
            }
        }
        ?>
    </div>

    <div class="elina-postfooter">
        <div class="elina-footer">
            <?php
            if (isset($bdp_settings['display_postlike']) && $bdp_settings['display_postlike'] == 1) {
                echo do_shortcode('[likebtn_shortcode]');
            }
            if ($bdp_settings['display_comment_count'] == 1) {
                ?>
                <div class="post-comment">
                    <i class="fa fa-comment"></i>
                    <?php
                    if (isset($bdp_settings['disable_link_comment']) && $bdp_settings['disable_link_comment'] == 1) {
                        comments_number(__('No Comments', BLOGDESIGNERPRO_TEXTDOMAIN), __('1 comment', BLOGDESIGNERPRO_TEXTDOMAIN), __('% comments', BLOGDESIGNERPRO_TEXTDOMAIN));
                    } else {
                        comments_popup_link(__('Leave a Comment', BLOGDESIGNERPRO_TEXTDOMAIN), __('1 comment', BLOGDESIGNERPRO_TEXTDOMAIN), __('% comments', BLOGDESIGNERPRO_TEXTDOMAIN), 'comments-link', __('Comments are off', BLOGDESIGNERPRO_TEXTDOMAIN));
                    }
                    ?>
                </div>
                <?php
            }
            if (($bdp_settings['facebook_link'] == 1) || ($bdp_settings['twitter_link'] == 1) || ($bdp_settings['google_link'] == 1) || ($bdp_settings['linkedin_link'] == 1) || ($bdp_settings['instagram_link'] == 1) || ( $bdp_settings['pinterest_link'] == 1) || ( $bdp_settings['whatsapp_link'] == 1)) {
                ?>
                <div class="post-share-div">
                    <i class="fa fa-share-square-o"></i>
                    <a class="post-share" href="javascript:void(0)" title="<?php _ex('SHARE', BLOGDESIGNERPRO_TEXTDOMAIN); ?>">
                        <?php _ex('SHARE', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                    </a>
                </div>
                <?php
            }
            bdp_get_social_icons($bdp_settings);
            ?>
        </div>
    </div>

    <?php do_action('bdp_after_post_content'); ?>
    <div class="fakegb"></div>
</div>

<?php
do_action('bdp_separator_after_post');
