<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
global $post;

$total_col = $bdp_settings['template_columns'];
if (isset($bdp_settings['blog_unique_design']) && $bdp_settings['blog_unique_design'] != "") {
    $blog_unique_design = $bdp_settings['blog_unique_design'];
} else {
    $blog_unique_design = 0;
}
$unique_design_option = isset($bdp_settings['unique_design_option']) ? $bdp_settings['unique_design_option'] : '';

$col_class = '';
if ($total_col == 2) {
    $col_class = "two_column";
}
if ($total_col == 3) {
    $col_class = "three_column";
}
if ($total_col == 4) {
    $col_class = "four_column";
}
if ($blog_unique_design == 1) {
    if ($unique_design_option == 'first_post' && $prev_year == 0 && $alter_val == 1 && $paged == 1) {
        $class_name = "blog_wrap bdp_blog_template first_post";
        $col_class .= ' bb bt';
    } elseif ($unique_design_option == 'first_post' && $prev_year == 1 && $alter_val != 1 && $paged == 1) {
        if (($alter_val - 1) % $total_col != 0) {
            $col_class .= " br";
        }
        $col_class .= " bb";
        if (($alter_val - 1) <= $total_col) {
            $col_class .= " bt";
        }
        $class_name = "blog_wrap bdp_blog_template";
    } elseif ($unique_design_option == 'first_post' && $prev_year == 1 && $paged != 1) {
        if (($alter_val) % $total_col != 0) {
            $col_class .= " br";
        }
        $col_class .= " bb";
        if (($alter_val) <= $total_col) {
            $col_class .= " bt";
        }
        $class_name = "blog_wrap bdp_blog_template";
    } elseif ($unique_design_option == 'featured_posts' && $prev_year == 0 && $alter_val <= $count_sticky && $paged == 1) {
        $class_name = "blog_wrap bdp_blog_template first_post";
        $col_class .= ' bb bt';
    } elseif ($unique_design_option == 'featured_posts' && $prev_year == 1 && $alter_val > $count_sticky && $paged == 1) {
        if (($alter_val - $count_sticky) % $total_col != 0) {
            $col_class .= " br";
        }
        $col_class .= " bb";
        if (($alter_class - $count_sticky) <= $total_col) {
            $col_class .= " bt";
        }
        $class_name = "blog_wrap bdp_blog_template";
    } elseif ($unique_design_option == 'featured_posts' && $prev_year == 1 && $paged != 1) {
        if (($alter_val) % $total_col != 0) {
            $col_class .= " br";
        }
        $col_class .= " bb";
        if (($alter_val) <= $total_col) {
            $col_class .= " bt";
        }
        $class_name = "blog_wrap bdp_blog_template";
    }
} else {
    if ($alter_class % $total_col != 0) {
        $col_class .= " br";
    }
    $col_class .= " bb";

    if ($alter_class <= $total_col) {
        $col_class .= " bt";
    }
    $class_name = "blog_wrap bdp_blog_template";
}
if ($col_class != '') {
    $class_name .= " " . $col_class;
}
?>

<li class="<?php echo $class_name; ?>">
    <?php do_action('bdp_before_post_content'); ?>
    <div class="post-meta">
        <?php
        $display_date = $bdp_settings['display_date'];
        $ar_year = get_the_time('Y');
        $ar_month = get_the_time('m');
        $ar_day = get_the_time('d');

        if ($display_date == 1) {
            $date_link = (isset($bdp_settings['disable_link_date']) && $bdp_settings['disable_link_date'] == 1) ? false : true;
            ?>
            <div class="postdate">
                <?php echo ($date_link) ? '<a href="' . get_day_link($ar_year, $ar_month, $ar_day) . '">' : ''; ?>
                <span class="month"><?php the_time('M d'); ?></span>
                <span class="year"><?php the_time('Y'); ?></span>
                <?php echo ($date_link) ? '</a>' : ''; ?>
            </div>
            <?php
        }
        if ($bdp_settings['display_comment_count'] == 1) {
            if (comments_open()) {
                ?>
                <span class="post-comment">
                    <i class="fa fa-comment"></i>
                    <?php
                    if (isset($bdp_settings['disable_link_comment']) && $bdp_settings['disable_link_comment'] == 1) {
                        comments_number('0', '1', '%');
                    } else {
                        comments_popup_link('0', '1', '%');
                    }
                    ?>
                </span>

                <?php
            }
        }
        ?>
    </div>
    <div class="post-media">
        <?php
        if (bdp_get_first_embed_media($post->ID) && $bdp_settings['rss_use_excerpt'] == 1) {
            ?>
            <div class="bdp-post-image post-video">
                <?php echo bdp_get_first_embed_media($post->ID); ?>
            </div>
            <?php
        } else {
            ?>
            <div class="bdp-post-image">
                <?php
                $post_thumbnail = 'invert-grid-thumb';
                $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                $bdp_post_image_link = (isset($bdp_settings['bdp_post_image_link']) && $bdp_settings['bdp_post_image_link'] == 0) ? false : true;

                echo ($bdp_post_image_link) ? '<a href="' . get_permalink($post->ID) . '" class="deport-img-link">' : '';
                echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                echo ($bdp_post_image_link) ? '</a>' : '';

                if (isset($bdp_settings['pinterest_image_share']) && $bdp_settings['pinterest_image_share'] == 1 && has_post_thumbnail()) {
                    ?>
                    <div class="bdp-pinterest-share-image">
                        <?php
                        $img_url = wp_get_attachment_url(get_post_thumbnail_id($post->ID));
                        ?>
                        <a target="_blank" href="<?php echo 'https://pinterest.com/pin/create/button/?url=' . get_permalink($post->ID) . '&media=' . $img_url; ?>"></a>
                    </div>
                <?php } ?>
            </div>
            <?php
        }
        $display_author = $bdp_settings['display_author'];
        if ($display_author == 1) {
            $author_link = (isset($bdp_settings['disable_link_author']) && $bdp_settings['disable_link_author'] == 1) ? false : true;
            $author_class = (bdp_get_first_embed_media($post->ID) && $bdp_settings['rss_use_excerpt'] == 1 && get_post_format($post->ID) != 'gallery') ? 'class="post-video-format"' : '';
            echo ($author_link) ? '<a href="' . get_author_posts_url(get_the_author_meta('ID')) . '" ' . $author_class . '>' : '';
            ?>
            <span class="author">
                <?php printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_author()); ?>
            </span>
            <?php
            echo ($author_link) ? '</a>' : '';
        }
        ?>
    </div>
    <div class="post_summary_outer">
        <div class="blog_header">
            <h2>
                <?php
                $bdp_post_title_link = isset($bdp_settings['bdp_post_title_link']) ? $bdp_settings['bdp_post_title_link'] : 1;
                if ($bdp_post_title_link == 1) {
                    ?>
                    <a href="<?php the_permalink(); ?>">
                    <?php } ?>
                    <?php
                    printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_title());
                    if ($bdp_post_title_link == 1) {
                        ?>
                    </a>
                <?php } ?>
            </h2>
        </div>
        <div class="post_content">
            <?php
            echo bdp_get_content($post->ID, $bdp_settings['rss_use_excerpt'], $bdp_settings['txtExcerptlength'], $bdp_settings);
            if (($bdp_settings['txtReadmoretext'] != '' && $bdp_settings['rss_use_excerpt'] == 1) || (isset($bdp_settings['display_postlike']) && $bdp_settings['display_postlike'] == 1)) {
                echo '<div class="content-footer">';
                if ($bdp_settings['txtReadmoretext'] != '' && $bdp_settings['rss_use_excerpt'] == 1) {
                    ?>
                    <div class="read-more">
                        <?php
                        echo '<a class="more-tag" href="' . get_permalink($post->ID) . '"><i class="fa fa-link"></i>' . $bdp_settings['txtReadmoretext'] . ' </a>';
                        ?>
                    </div>
                    <?php
                }
                if (isset($bdp_settings['display_postlike']) && $bdp_settings['display_postlike'] == 1) {
                    echo do_shortcode('[likebtn_shortcode]');
                }
                echo '</div>';
            }
            ?>

        </div>
    </div>

    <?php
    if($bdp_settings['display_category'] == 1 || $bdp_settings['display_tag'] == 1) {
        ?>
        <div class="blog_footer">

            <div class="footer_meta">
                <?php
                if ($bdp_settings['custom_post_type'] == 'post') {
                    if ($bdp_settings['display_category'] == 1) {
                        ?>
                        <span class="category-link">
                            <i class="fa fa-folder"></i>
                            <?php _e('Category', BLOGDESIGNERPRO_TEXTDOMAIN); ?>&nbsp;:&nbsp;<?php
                            $categories_list = get_the_category_list(', ');
                            $categories_link = (isset($bdp_settings['disable_link_category']) && $bdp_settings['disable_link_category'] == 1) ? true : false;
                            if ($categories_link) {
                                $categories_list = strip_tags($categories_list);
                            }
                            if ($categories_list):
                                printf(__(' %2$s', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $categories_list);
                                $show_sep = true;
                            endif;
                            ?>
                        </span>
                        <?php
                    }
                } else {
                    $taxonomy_names = get_object_taxonomies($bdp_settings['custom_post_type']);
                    foreach ($taxonomy_names as $taxonomy) {
                        $sep = 1;
                        if ($bdp_settings["display_taxonomy_" . $taxonomy] == 1) {
                            $term_list = wp_get_post_terms(get_the_ID(), $taxonomy, array("fields" => "all"));
                            $taxonomy_link = (isset($bdp_settings['disable_link_taxonomy_' . $taxonomy]) && $bdp_settings['disable_link_taxonomy_' . $taxonomy] == 1) ? false : true;
                            if (isset($taxonomy)) {
                                if (isset($term_list) && !empty($term_list)) {
                                    ?>
                                    <span class="category-link">
                                        <i class="fa fa-folder"></i>
                                        <?php _e('Category', BLOGDESIGNERPRO_TEXTDOMAIN); ?>&nbsp;:&nbsp;<?php
                                        foreach ($term_list as $term_nm) {
                                            $term_link = get_term_link($term_nm);

                                            if ($sep != 1) {
                                                ?> <span class="seperater"><?php echo ', '; ?></span> <?php
                                            }
                                            echo ($taxonomy_link) ? '<a href="' . $term_link . '">' : '';
                                            printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), $term_nm->name);
                                            echo ($taxonomy_link) ? '</a>' : '';
                                            $sep++;
                                        }
                                        ?>
                                    </span>
                                    <?php
                                }
                            }
                        }
                    }
                }

                if ($bdp_settings['custom_post_type'] == 'post') {
                    if ($bdp_settings['display_tag'] == 1) {
                        $tags_list = get_the_tag_list('', ', ');
                        $tag_link = (isset($bdp_settings['disable_link_tag']) && $bdp_settings['disable_link_tag'] == 1) ? true : false;
                        if ($tag_link) {
                            $tags_list = strip_tags($tags_list);
                        }
                        if ($tags_list):
                            ?>
                            <div class="tags">
                                <i class="fa fa-bookmark"></i>
                                <?php _e('Tag', BLOGDESIGNERPRO_TEXTDOMAIN); ?>&nbsp;:&nbsp;<?php
                                printf(__(' %2$s', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $tags_list);
                                $show_sep = true;
                                ?>
                            </div>
                            <?php
                        endif;
                    }
                }
                ?>
            </div>
        </div>
        <?php
    }
    ?>
    <?php bdp_get_social_icons($bdp_settings); ?>
    <?php do_action('bdp_after_post_content'); ?>
</li>
<?php
do_action('bdp_separator_after_post');
