<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
add_action('bd_archive_design_format_function', 'bdp_archive_winter_template', 10, 2);
if (!function_exists('bdp_archive_winter_template')) {

    /**
     *
     * @global type $post
     * @param type $alterclass
     */
    function bdp_archive_winter_template($bdp_settings, $alterclass) {
        global $post;
        $class_name = "blog_template bdp_blog_template winter";
        if ($alterclass != '') {
            $class_name .= " " . $alterclass;
        }
        ?>
        <div class="<?php echo $class_name; ?>">
            <?php do_action('bdp_before_archive_post_content'); ?>
            <div class="blog_header">
                <div class="metadatabox"><?php
                    $display_date = $bdp_settings['display_date'];
                    $display_author = $bdp_settings['display_author'];
                    $ar_year = get_the_time('Y');
                    $ar_month = get_the_time('m');
                    $ar_day = get_the_time('d');
                    if ($display_date == 1) {
                        $date_link = (isset($bdp_settings['disable_link_date']) && $bdp_settings['disable_link_date'] == 1) ? false : true;
                        $date_format = get_option('date_format');
                        ?>
                        <time datetime="" class="datetime">
                            <?php
                            echo ($date_link) ? '<a href="' . get_day_link($ar_year, $ar_month, $ar_day) . '">' : '';
                            echo apply_filters('bdp_date_format', get_the_time($date_format, $post->ID), $post->ID);
                            echo '</a>';
                            ?>
                        </time><?php
                    }
                    if ($display_date == 1 && ($bdp_settings['display_tag'] == 1 && has_tag())) {
                        echo '<span>-</span>';
                    }
                    if ($bdp_settings['display_tag'] == 1) {
                        $tags_list = get_the_tag_list('', ', ');
                        $tag_link = (isset($bdp_settings['disable_link_tag']) && $bdp_settings['disable_link_tag'] == 1) ? true : false;
                        if ($tag_link) {
                            $tags_list = strip_tags($tags_list);
                        }
                        if ($tags_list):
                            ?>
                            <div class="tags"><?php
                                printf(__(' %2$s', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $tags_list);
                                $show_sep = true;
                                ?>
                            </div><?php
                        endif;
                    }
                    ?>
                    <h2 class="post-title">
                        <?php
                        $bdp_post_title_link = isset($bdp_settings['bdp_post_title_link']) ? $bdp_settings['bdp_post_title_link'] : 1;
                        if ($bdp_post_title_link == 1) {
                            ?>
                            <a href="<?php the_permalink(); ?>">
                            <?php } ?>
                            <?php
                            printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_title());
                            if ($bdp_post_title_link == 1) {
                                ?>
                            </a>
                        <?php } ?>
                    </h2>
                    <?php
                    if ($display_author == 1) {
                        $author_link = (isset($bdp_settings['disable_link_author']) && $bdp_settings['disable_link_author'] == 1) ? false : true;
                        ?>
                        <div class="posted_by">
                            <span><?php _e('By', BLOGDESIGNERPRO_TEXTDOMAIN); ?> </span>
                            <?php
                            echo ($author_link) ? '<a href="' . get_author_posts_url(get_the_author_meta('ID')) . '">' : '<span class="auther-inner">';
                            printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_author());
                            echo ($author_link) ? '</a>' : '</span>';
                            ?>
                        </div><?php
                    }
                    if ($bdp_settings['display_comment_count'] == 1 || ( isset($bdp_settings['display_postlike']) && $bdp_settings['display_postlike'] == 1)) {
                        ?>
                        <div class="metacomments">
                            <?php
                            if ($bdp_settings['display_comment_count'] == 1) {
                                if (isset($bdp_settings['disable_link_comment']) && $bdp_settings['disable_link_comment'] == 1) {
                                    comments_number(__('No Comments', BLOGDESIGNERPRO_TEXTDOMAIN), __('1 comment', BLOGDESIGNERPRO_TEXTDOMAIN), __('% comments', BLOGDESIGNERPRO_TEXTDOMAIN));
                                } else {
                                    comments_popup_link(__('Leave a Comment', BLOGDESIGNERPRO_TEXTDOMAIN), __('1 Comment', BLOGDESIGNERPRO_TEXTDOMAIN), __('% comments', BLOGDESIGNERPRO_TEXTDOMAIN), 'comments-link', __('Comments Are Off', BLOGDESIGNERPRO_TEXTDOMAIN));
                                }
                            }
                            if (isset($bdp_settings['display_postlike']) && $bdp_settings['display_postlike'] == 1) {
                                echo do_shortcode('[likebtn_shortcode]');
                            }
                            ?>
                        </div>
                    <?php }
                    ?>
                </div>
            </div>
            <div class="bdp-post-image"><?php
                $no_image = 'winter-no-image-post';
                $post_thumbnail = 'full';
                $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                $bdp_post_image_link = (isset($bdp_settings['bdp_post_image_link']) && $bdp_settings['bdp_post_image_link'] == 0) ? false : true;
                if (!empty($thumbnail)) {
                    $no_image = '';
                }
                if ($bdp_settings['display_category'] == 1) {
                    $categories_list = get_the_category_list(', ');
                    $categories_link = (isset($bdp_settings['disable_link_category']) && $bdp_settings['disable_link_category'] == 1) ? true : false;
                    if ($categories_link) {
                        $categories_list = strip_tags($categories_list);
                    }
                    if ($categories_list):
                        echo '<div class="category-link ' . $no_image . ' ">';
                        printf(__(' %2$s', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $categories_list);
                        $show_sep = true;
                        echo '</div>';
                    endif;
                }
                if (bdp_get_first_embed_media($post->ID) && $bdp_settings['rss_use_excerpt'] == 1) {
                    ?>
                    <div class="post-video">
                        <?php echo bdp_get_first_embed_media($post->ID); ?>
                    </div><?php
                } else {
                    if (!empty($thumbnail)) {
                        echo ($bdp_post_image_link) ? '<a href="' . get_permalink($post->ID) . '" class="deport-img-link">' : '';
                        echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                        if (isset($bdp_settings['pinterest_image_share']) && $bdp_settings['pinterest_image_share'] == 1) {
                            echo bdp_pinterest($post->ID);
                        }
                        echo ($bdp_post_image_link) ? '</a>' : '';
                    }
                }
                ?>
            </div>
            <div class="post_content_wrap">
                <div class="post_content">
                    <p><?php echo bdp_get_content($post->ID, $bdp_settings['rss_use_excerpt'], $bdp_settings['txtExcerptlength'], $bdp_settings); ?></p><?php
                    if ($bdp_settings['txtReadmoretext'] != '' && $bdp_settings['rss_use_excerpt'] != 0) {
                        echo '<a class="more-tag" href="' . get_permalink($post->ID) . '">' . $bdp_settings['txtReadmoretext'] . ' </a>';
                    }
                    ?>
                </div>
                <?php bdp_get_social_icons($bdp_settings); ?>
            </div>
            <?php do_action('bdp_after_archive_post_content'); ?>
        </div><?php
        do_action('bdp_archive_separator_after_post');
    }

}