<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

add_action('bd_archive_design_format_function', 'bdp_archive_tagly_template', 10, 5);

if (!function_exists('bdp_archive_tagly_template')) {

    function bdp_archive_tagly_template($bdp_settings, $alterclass, $prev_year, $alter_val, $paged) {
        global $post;
        $left_after = '';
        ?>
        <div class="blog_template bdp_blog_template tagly">
            <?php do_action('bdp_before_post_content'); ?>
            <?php if (bdp_get_first_embed_media($post->ID) && $bdp_settings['rss_use_excerpt'] == 1) { ?>
                <div class="bdp-post-image post-video">
                    <?php
                    if (get_post_format() == 'quote') {
                        if (has_post_thumbnail()) {
                            $post_thumbnail = 'full';
                            $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                            echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                            echo '<div class="upper_image_wrapper">';
                            echo bdp_get_first_embed_media($post->ID);
                            echo '</div>';
                        }
                    } else if (get_post_format() == 'link') {
                        if (has_post_thumbnail()) {
                            $post_thumbnail = 'full';
                            $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                            echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                            echo '<div class="upper_image_wrapper bdp_link_post_format">';
                            echo bdp_get_first_embed_media($post->ID);
                            echo '</div>';
                        }
                    } else {
                        echo bdp_get_first_embed_media($post->ID);
                    }
                    ?>                
                </div>
                <?php
            } else {
                $post_thumbnail = 'full';
                $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                if (!empty($thumbnail)) {
                    $bdp_post_image_link = (isset($bdp_settings['bdp_post_image_link']) && $bdp_settings['bdp_post_image_link'] == 0) ? false : true;
                    $left_after = 'post-has-image';
                    ?>
                    <div class="bdp-post-image post-has-image">
                        <?php
                        echo ($bdp_post_image_link) ? '<a href="' . get_permalink($post->ID) . '">' : '';
                        echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                        echo ($bdp_post_image_link) ? '</a>' : '';

                        if (isset($bdp_settings['pinterest_image_share']) && $bdp_settings['pinterest_image_share'] == 1 && has_post_thumbnail()) {
                            echo bdp_pinterest($post->ID);
                        }
                        ?>
                    </div>
                    <?php
                }
            }
            ?>
            <div class="post-content-wrapper">
                <div class="left-side-area">
                    <?php
                    if (isset($bdp_settings['display_postlike']) && $bdp_settings['display_postlike'] == 1) {
                        echo do_shortcode('[likebtn_shortcode]');
                    }
                    if ($bdp_settings['display_comment_count'] == 1) {
                        if (!post_password_required() && ( comments_open() || get_comments_number() )) :
                            ?>
                            <span class="comment">
                                <?php
                                if (isset($bdp_settings['disable_link_comment']) && $bdp_settings['disable_link_comment'] == 1) {
                                    ?>
                                    <a href="#">                        
                                    <?php } else { ?>                        
                                        <a href="<?php comments_link(); ?>">
                                        <?php } ?>
                                        <i class="fa fa-comment-o"></i>
                                    </a>
                            </span>
                            <?php
                        endif;
                    }
                    ?>
                    <div class="social-share">
                        <i class="fa fa-send-o"></i>
                        <?php bdp_get_social_icons($bdp_settings); ?>
                    </div>            
                </div>
                <div class="right-side-area">
                    <?php
                    if ($bdp_settings['display_category'] == 1) {
                        ?>
                        <span class="categories">                    
                            <?php
                            $categories_list = get_the_category_list(', ');
                            $categories_link = (isset($bdp_settings['disable_link_category']) && $bdp_settings['disable_link_category'] == 1) ? true : false;
                            if ($categories_link) {
                                $categories_list = strip_tags($categories_list);
                            }
                            if ($categories_list):
                                printf(__(' %2$s ', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $categories_list);
                                $show_sep = true;
                            endif;
                            ?>
                        </span>
                        <?php
                    }
                    ?>
                    <h2 class="bdp_post_title">
                        <?php
                        $bdp_post_title_link = isset($bdp_settings['bdp_post_title_link']) ? $bdp_settings['bdp_post_title_link'] : 1;
                        if ($bdp_post_title_link == 1) {
                            ?>
                            <a href="<?php the_permalink(); ?>">
                            <?php } ?>
                            <?php
                            printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_title());
                            if ($bdp_post_title_link == 1) {
                                ?>
                            </a>
                        <?php } ?>
                    </h2>
                    <?php
                    $display_author = $bdp_settings['display_author'];
                    if ($display_author == 1 || $bdp_settings['display_date'] == 1 || $bdp_settings['display_comment_count'] == 1) {
                        ?>
                        <div class="metadatabox">
                            <?php
                            if ($bdp_settings['display_author'] == 1) {
                                $author_link = (isset($bdp_settings['disable_link_author']) && $bdp_settings['disable_link_author'] == 1) ? false : true;
                                ?>
                                <span class="author">
                                    <i class="fa fa-user"></i>
                                    <?php
                                    echo ($author_link) ? '<a href="' . get_author_posts_url(get_the_author_meta('ID')) . '">' : '';
                                    printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_author());
                                    echo ($author_link) ? '</a>' : '';
                                    ?>
                                </span>
                                <?php
                            }
                            if ($bdp_settings['display_date'] == 1) {
                                $date_link = (isset($bdp_settings['disable_link_date']) && $bdp_settings['disable_link_date'] == 1) ? false : true;
                                $ar_year = get_the_time('Y');
                                $ar_month = get_the_time('m');
                                $ar_day = get_the_time('d');
                                echo '<span class="date"><i class="fa fa-clock-o"></i>';
                                echo ($date_link) ? '<a href="' . get_day_link($ar_year, $ar_month, $ar_day) . '">' : '';
                                $date_format = get_option('date_format');
                                echo apply_filters('bdp_date_format', get_the_time($date_format, $post->ID), $post->ID);
                                echo ($date_link) ? '</a>' : '';
                                echo '</span>';
                            }
                            if ($bdp_settings['display_comment_count'] == 1) {
                                if (!post_password_required() && ( comments_open() || get_comments_number() )) :
                                    ?>
                                    <span class="comment">                                
                                        <i class="fa fa-comment"></i>
                                        <?php
                                        $comment_link = (isset($bdp_settings['disable_link_comment']) && $bdp_settings['disable_link_comment'] == 1) ? false : true;
                                        bdp_comment_count($comment_link); //comments_popup_link('0', '1', '%');  
                                        ?>                                
                                    </span>
                                    <?php
                                endif;
                            }
                            ?>                    
                        </div>
                    <?php } ?>
                    <div class="post_content">
                        <?php echo bdp_get_content($post->ID, $bdp_settings['rss_use_excerpt'], $bdp_settings['txtExcerptlength'], $bdp_settings); ?>
                    </div>
                    <?php
                    if ($bdp_settings['display_tag'] == 1) {
                        $tags_list = (isset($bdp_settings['disable_link_tag']) && $bdp_settings['disable_link_tag'] == 1) ? get_the_tag_list('', ', ') : get_the_tag_list('', ', ');
                        $tag_link = (isset($bdp_settings['disable_link_tag']) && $bdp_settings['disable_link_tag'] == 1) ? true : false;
                        if ($tag_link) {
                            $tags_list = strip_tags($tags_list);
                        }
                        if ($tags_list):
                            ?>
                            <div class="tags">
                                <i class="fa fa-tags"></i>&nbsp;&nbsp;&nbsp;&nbsp;<?php
                                printf(__('%2$s', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $tags_list);
                                $show_sep = true;
                                ?>
                            </div>
                            <?php
                        endif;
                    }
                    ?>   
                    <?php if ($bdp_settings['rss_use_excerpt'] == 1 && $bdp_settings['txtReadmoretext'] != ''): ?>
                        <div class="read-more">
                            <a href="<?php echo get_permalink($post->ID); ?>">
                                <?php echo $bdp_settings['txtReadmoretext']; ?>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php do_action('bdp_after_post_content'); ?>
        </div>
        <?php
        do_action('bdp_separator_after_post');
    }

}