<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
add_action('bd_archive_design_format_function', 'bdp_archive_offer_blog_template', 10, 1);
if (!function_exists('bdp_archive_offer_blog_template')) {

    /**
     *
     * @global type $post
     * @param type $alterclass
     * @return html display offer_blog design
     */
    function bdp_archive_offer_blog_template($bdp_settings) {
        global $post;
        ?>
        <div class="blog_template bdp_blog_template offer_blog">
            <?php do_action('bdp_before_archive_post_content'); ?>
            <div class="middle-title">
                <div class="gravatar-img">
                    <?php $user_email = get_the_author_meta('user_email'); ?>
                    <?php echo get_avatar($user_email, 100); ?>
                </div>
                <div class="blog-title-meta">
                    <h2 class="post-title">
                        <?php
                        $bdp_post_title_link = isset($bdp_settings['bdp_post_title_link']) ? $bdp_settings['bdp_post_title_link'] : 1;
                        if ($bdp_post_title_link == 1) {
                            ?>
                            <a href="<?php the_permalink(); ?>">
                            <?php } ?>
                            <?php
                            printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_title());
                            if ($bdp_post_title_link == 1) {
                                ?>
                            </a>
                        <?php } ?>

                    </h2>
                    <div class="post-entry-meta">
                        <?php
                        if ($bdp_settings['display_author'] == 1) {
                            $author_link = (isset($bdp_settings['disable_link_author']) && $bdp_settings['disable_link_author'] == 1) ? false : true;
                            ?>
                            <span class="author">
                                <i class="fa fa-user"></i>
                                <?php
                                echo ($author_link) ? '<a href="' . get_author_posts_url(get_the_author_meta('ID')) . '">' : '';
                                ?>
                                <span class="author-name">
                                    <?php printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_author()); ?>
                                </span>
                                <?php
                                echo ($author_link) ? '</a>' : '';
                                ?>
                            </span>
                            <?php
                        }
                        if ($bdp_settings['display_date'] == 1) {
                            $date_link = (isset($bdp_settings['disable_link_date']) && $bdp_settings['disable_link_date'] == 1) ? false : true;
                            ?>
                            <span class="date">
                                <i class="fa fa-clock-o"></i>
                                <span class="number-date"><?php
                                    $date_format = get_option('date_format');
                                    $ar_year = get_the_time('Y');
                                    $ar_month = get_the_time('m');
                                    $ar_day = get_the_time('d');

                                    echo ($date_link) ? '<a class="mdate" href="' . get_day_link($ar_year, $ar_month, $ar_day) . '">' : '';
                                    the_time('l');
                                    echo ", ";
                                    echo apply_filters('bdp_date_format', get_the_time($date_format, $post->ID), $post->ID);
                                    echo ($date_link) ? '</a>' : '';
                                    ?>
                                </span>
                            </span><?php
                        }
                        if ($bdp_settings['display_category'] == 1) {
                            ?>
                            <span class="post-category">
                                <i class="fa fa-folder-open"></i><?php
                                $categories_list = get_the_category_list(', ');
                                $categories_link = (isset($bdp_settings['disable_link_category']) && $bdp_settings['disable_link_category'] == 1) ? true : false;
                                if ($categories_link) {
                                    $categories_list = strip_tags($categories_list);
                                }
                                if ($categories_list):
                                    printf(__('%2$s', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $categories_list);
                                    $show_sep = true;
                                endif;
                                ?>
                            </span><?php
                        }
                        if ($bdp_settings['display_comment_count'] == 1) {
                            if (!post_password_required() && ( comments_open() || get_comments_number() )) :
                                ?>
                                <span class="comment">
                                    <span class="icon_cnt">
                                        <i class="fa fa-comments"></i>
                                        <?php
                                        $comment_link = (isset($bdp_settings['disable_link_comment']) && $bdp_settings['disable_link_comment'] == 1) ? false : true;
                                        bdp_comment_count($comment_link); //comments_popup_link('0', '1', '%');
                                        ?>
                                    </span>
                                </span><?php
                            endif;
                        }
                        if (isset($bdp_settings['display_postlike']) && $bdp_settings['display_postlike'] == 1) {
                            echo do_shortcode('[likebtn_shortcode]');
                        }
                        ?>
                    </div>
                </div>
            </div>
            <?php if (bdp_get_first_embed_media($post->ID) && $bdp_settings['rss_use_excerpt'] == 1) { ?>
                <div class="post-video">
                    <?php
                    if (get_post_format() == 'quote') {
                        if (has_post_thumbnail()) {
                            $post_thumbnail = 'full';
                            $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                            echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                            echo '<div class="upper_image_wrapper">';
                            echo bdp_get_first_embed_media($post->ID);
                            echo '</div>';
                        }
                    } else if (get_post_format() == 'link') {
                        if (has_post_thumbnail()) {
                            $post_thumbnail = 'full';
                            $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                            echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                            echo '<div class="upper_image_wrapper bdp_link_post_format">';
                            echo bdp_get_first_embed_media($post->ID);
                            echo '</div>';
                        }
                    } else {
                        echo bdp_get_first_embed_media($post->ID);
                    }
                    ?>
                </div><?php
            } else {
                $post_thumbnail = 'full';
                $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                $bdp_post_image_link = (isset($bdp_settings['bdp_post_image_link']) && $bdp_settings['bdp_post_image_link'] == 0) ? false : true;
                if (!empty($thumbnail)) {
                    ?>
                    <div class="text-center">
                        <div class="bdp-post-image">
                            <?php
                            echo ($bdp_post_image_link) ? '<a href="' . get_permalink($post->ID) . '">' : '';
                            echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                            echo ($bdp_post_image_link) ? '</a>' : '';
                            if (isset($bdp_settings['pinterest_image_share']) && $bdp_settings['pinterest_image_share'] == 1) {
                                echo bdp_pinterest($post->ID);
                            }
                            ?>

                        </div>
                    </div>
                    <?php
                }
            }
            ?>
            <div class="post-content-body post_content">
                <?php echo bdp_get_content($post->ID, $bdp_settings['rss_use_excerpt'], $bdp_settings['txtExcerptlength'], $bdp_settings); ?>
            </div>
            <?php if ($bdp_settings['rss_use_excerpt'] == 1 && $bdp_settings['txtReadmoretext'] != ''): ?>
                <div class="post-bottom">
                    <?php
                    echo '<a href="' . get_permalink($post->ID) . '">' . $bdp_settings['txtReadmoretext'] . ' </a>';
                    ?>
                </div><?php
            endif;
            if ($bdp_settings['display_tag'] == 1) {
                $tags_list = get_the_tag_list('', ' ');
                $tag_link = (isset($bdp_settings['disable_link_tag']) && $bdp_settings['disable_link_tag'] == 1) ? true : false;
                if ($tag_link) {
                    $tags_list = strip_tags($tags_list);
                }
                if ($tags_list):
                    ?>
                    <span class="tags">
                        <span><?php echo _e('Tags', BLOGDESIGNERPRO_TEXTDOMAIN); ?>&nbsp;:&nbsp;</span><?php printf(__('%2$s', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $tags_list); ?>
                    </span><?php
                endif;
            }
            bdp_get_social_icons($bdp_settings);
            do_action('bdp_after_archive_post_content');
            ?>
        </div><?php
        do_action('bdp_archive_separator_after_post');
    }

}