<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
add_action('bd_archive_design_format_function', 'bdp_archive_lightbreeze_template', 10, 2);
if (!function_exists('bdp_archive_lightbreeze_template')) {

    /**
     *
     * @global type $post
     * @return html display lightbreeze design
     */
    function bdp_archive_lightbreeze_template($bdp_settings, $alterclass) {
        global $post;
        $class_name = "blog_template bdp_blog_template box-template active lightbreeze";
        if ($alterclass != '') {
            $class_name .= " " . $alterclass;
        }
        ?>
        <div class="<?php
        echo $class_name;
        if ($bdp_settings['display_category'] == 0) {
            echo ' no-category-display';
        }
        ?>">
                 <?php do_action('bdp_before_archive_post_content'); ?>
                 <?php if (bdp_get_first_embed_media($post->ID) && $bdp_settings['rss_use_excerpt'] == 1) { ?>
                <div class="bdp-post-image post-video">
                    <?php
                    if (get_post_format() == 'quote') {
                        if (has_post_thumbnail()) {
                            $post_thumbnail = 'full';
                            $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                            echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                            echo '<div class="upper_image_wrapper">';
                            echo bdp_get_first_embed_media($post->ID);
                            echo '</div>';
                        }
                    } else if (get_post_format() == 'link') {
                        if (has_post_thumbnail()) {
                            $post_thumbnail = 'full';
                            $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                            echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                            echo '<div class="upper_image_wrapper bdp_link_post_format">';
                            echo bdp_get_first_embed_media($post->ID);
                            echo '</div>';
                        }
                    } else {
                        echo bdp_get_first_embed_media($post->ID);
                    }
                    ?>
                </div>
                <?php
            } else {
                $post_thumbnail = 'full';
                $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                if (!empty($thumbnail)) {
                    $bdp_post_image_link = (isset($bdp_settings['bdp_post_image_link']) && $bdp_settings['bdp_post_image_link'] == 0) ? false : true;
                    ?>
                    <div class="bdp-post-image">
                        <?php
                        echo ($bdp_post_image_link) ? '<a href="' . get_permalink($post->ID) . '">' : '';
                        echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                        echo ($bdp_post_image_link) ? '</a>' : '';

                        if (isset($bdp_settings['pinterest_image_share']) && $bdp_settings['pinterest_image_share'] == 1 && has_post_thumbnail()) {
                            echo bdp_pinterest($post->ID);
                        }
                        ?>
                    </div>
                    <?php
                }
            }

            if (isset($bdp_settings['image_corner_selection']) && $bdp_settings['image_corner_selection'] == 1) {
                $image_corner_class = 'square_style';
            } else if (isset($bdp_settings['image_corner_selection']) && $bdp_settings['image_corner_selection'] == 2) {
                $image_corner_class = 'round_style';
            } else {
                $image_corner_class = 'triangle_style';
            }

            if (has_post_thumbnail() || (isset($bdp_settings['bdp_default_image_id']) && $bdp_settings['bdp_default_image_id'] != '')) {
                ?>
                <?php
                if ($bdp_settings['display_category'] == 1) {
                    $categories_list = get_the_category_list(', ');
                    $categories_link = (isset($bdp_settings['disable_link_category']) && $bdp_settings['disable_link_category'] == 1) ? true : false;
                    if ($categories_link) {
                        $categories_list = strip_tags($categories_list);
                    }
                    if ($categories_list):
                        echo '<div class="category-list-wrap ' . $image_corner_class . '">';
                        echo '<div class="category-main-wrap">';
                        echo '<div class="category-list category-main">';
                        printf(__('%2$s', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $categories_list);
                        $show_sep = true;
                        echo '</div></div></div>';
                    endif;
                }
                ?>
            <?php } else { ?>

                <?php
                if ($bdp_settings['display_category'] == 1) {
                    ?>
                    <div class="metadatabox">
                        <div class="metacats">
                            <?php
                            $categories_list = get_the_category_list(', ');
                            $categories_link = (isset($bdp_settings['disable_link_category']) && $bdp_settings['disable_link_category'] == 1) ? true : false;
                            if ($categories_link) {
                                $categories_list = strip_tags($categories_list);
                            }
                            if ($categories_list):
                                printf(__('%2$s', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $categories_list);
                                $show_sep = true;
                            endif;
                            ?>
                        </div>
                    </div>
                    <?php
                }
                ?>
            <?php } ?>
            <div class="blog_header <?php
            if (has_post_thumbnail() || (isset($bdp_settings['bdp_default_image_id']) && $bdp_settings['bdp_default_image_id'] != '')) {
                echo "blog_header_img";
            }
            ?>">
                <h2 class="post-title">
                    <?php
                    $bdp_post_title_link = isset($bdp_settings['bdp_post_title_link']) ? $bdp_settings['bdp_post_title_link'] : 1;
                    if ($bdp_post_title_link == 1) {
                        ?>
                        <a href="<?php the_permalink(); ?>">
                        <?php } ?>
                        <?php
                        printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_title());
                        if ($bdp_post_title_link == 1) {
                            ?>
                        </a>
                    <?php } ?>
                    </a>
                </h2>
                <?php if ($bdp_settings['display_date'] == 1 || $bdp_settings['display_postlike'] == 1 || $bdp_settings['display_tag'] == 1 || $bdp_settings['display_author'] == 1 || $bdp_settings['display_category'] == 1 || $bdp_settings['display_comment_count'] == 1) { ?>
                    <div class="meta_data_box metadatabox">
                        <?php
                        $display_date = $bdp_settings['display_date'];
                        $display_author = $bdp_settings['display_author'];
                        if ($display_author == 1) {
                            $author_link = (isset($bdp_settings['disable_link_author']) && $bdp_settings['disable_link_author'] == 1) ? false : true;
                            ?>
                            <div class="metadate">
                                <i class="fa fa-user"></i>
                                <?php
                                _e('Posted by ', BLOGDESIGNERPRO_TEXTDOMAIN);
                                echo ($author_link) ? '<a href="' . get_author_posts_url(get_the_author_meta('ID')) . '">' : '';
                                printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_author());
                                echo ($author_link) ? '</a>' : '';
                                ?>
                                <br />
                            </div>
                            <?php
                        }
                        if ($display_date == 1) {
                            $date_link = (isset($bdp_settings['disable_link_date']) && $bdp_settings['disable_link_date'] == 1) ? false : true;
                            $ar_year = get_the_time('Y');
                            $ar_month = get_the_time('m');
                            $ar_day = get_the_time('d');
                            ?>
                            <div class="metauser">
                                <?php $date_format = get_option('date_format'); ?>
                                <span class="mdate">
                                    <i class="fa fa-calendar"></i>
                                    <?php
                                    echo ($date_link) ? '<a href="' . get_day_link($ar_year, $ar_month, $ar_day) . '">' : '';
                                    echo apply_filters('bdp_date_format', get_the_time($date_format, $post->ID), $post->ID);
                                    echo ($date_link) ? '</a>' : '';
                                    ?>
                                </span>
                            </div>
                            <?php
                        }

                        if ($bdp_settings['display_comment_count'] == 1) {
                            ?>
                            <div class="metacomments">
                                <!--<div class="icon-comment"></div>-->
                                <i class="fa fa-comment"></i>
                                <?php
                                if (isset($bdp_settings['disable_link_comment']) && $bdp_settings['disable_link_comment'] == 1) {
                                    comments_number(__('No Comments', BLOGDESIGNERPRO_TEXTDOMAIN), __('1 Comment', BLOGDESIGNERPRO_TEXTDOMAIN), __('% Comments', BLOGDESIGNERPRO_TEXTDOMAIN));
                                } else {
                                    comments_popup_link(__('No Comments', BLOGDESIGNERPRO_TEXTDOMAIN), __('1 Comment', BLOGDESIGNERPRO_TEXTDOMAIN), __('% Comments', BLOGDESIGNERPRO_TEXTDOMAIN));
                                }
                                ?>
                            </div>
                            <?php
                        }
                        if (isset($bdp_settings['display_postlike']) && $bdp_settings['display_postlike'] == 1) {
                            echo do_shortcode('[likebtn_shortcode]');
                        }
                        if ($bdp_settings['display_tag'] == 1) {
                            $tags_list = get_the_tag_list('', ', ');
                            $tag_link = (isset($bdp_settings['disable_link_tag']) && $bdp_settings['disable_link_tag'] == 1) ? true : false;
                            if ($tag_link) {
                                $tags_list = strip_tags($tags_list);
                            }
                            if ($tags_list):
                                ?>
                                <div class="tags">
                                    <i class="fa fa-tags"></i>
                                    <?php
                                    printf(__('%2$s', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $tags_list);
                                    $show_sep = true;
                                    ?>
                                </div>
                                <?php
                            endif;
                        }
                        ?>
                    </div>
                <?php } ?>
            </div>
            <div class="post_content">
                <?php
                echo bdp_get_content($post->ID, $bdp_settings['rss_use_excerpt'], $bdp_settings['txtExcerptlength'], $bdp_settings);
                ?>
            </div>
            <?php if ($bdp_settings['rss_use_excerpt'] == 1 && $bdp_settings['txtReadmoretext'] != ''): ?>
                <div class="read-more">
                    <a href="<?php echo get_permalink($post->ID); ?>">
                        <?php
                        echo $bdp_settings['txtReadmoretext'];
                        ?>
                    </a>
                </div>
            <?php endif; ?>

            <?php bdp_get_social_icons($bdp_settings); ?>
            <?php do_action('bdp_after_archive_post_content'); ?>
        </div>
        <?php
        do_action('bdp_archive_separator_after_post');
    }

}