<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
add_action('bd_archive_design_format_function', 'bdp_archive_classical_template', 10, 1);
if (!function_exists('bdp_archive_classical_template')) {

    /**
     * @global type $post
     * @return html display classical design
     */
    function bdp_archive_classical_template($bdp_settings) {
        global $post;
        ?>
        <div class="blog_template bdp_blog_template classical">

            <?php do_action('bdp_before_archive_post_content'); ?>
            <div class="entry-container">
                <div class="blog_header">
                    <div class="pull-left">
                        <h2>
                            <?php
                            $bdp_post_title_link = isset($bdp_settings['bdp_post_title_link']) ? $bdp_settings['bdp_post_title_link'] : 1;
                            if ($bdp_post_title_link == 1) {
                                ?>
                                <a href="<?php the_permalink(); ?>">
                                <?php } ?>
                                <?php
                                printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_title());
                                if ($bdp_post_title_link == 1) {
                                    ?>
                                </a>
                            <?php } ?>
                        </h2>
                        <?php
                        $display_date = $bdp_settings['display_date'];
                        $display_author = $bdp_settings['display_author'];
                        $date_format = get_option('date_format');
                        $display_comment_count = $bdp_settings['display_comment_count'];
                        $ar_year = get_the_time('Y');
                        $ar_month = get_the_time('m');
                        $ar_day = get_the_time('d');
                        if ($display_date == 1 || $bdp_settings['display_postlike'] == 1 || $display_author == 1 || $date_format == 1 || $display_comment_count == 1) {
                            ?>
                            <div class="metadatabox">
                                <?php
                                if ($display_author == 1 && $display_date == 1) {
                                    $author_link = (isset($bdp_settings['disable_link_author']) && $bdp_settings['disable_link_author'] == 1) ? false : true;
                                    _e('Posted by ', BLOGDESIGNERPRO_TEXTDOMAIN);
                                    echo ($author_link) ? '<a href="' . get_author_posts_url(get_the_author_meta('ID')) . '">' : '';
                                    ?><span><?php
                                        printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_author());
                                        ?></span><?php
                                    echo ($author_link) ? '</a>' : '';

                                    $date_link = (isset($bdp_settings['disable_link_date']) && $bdp_settings['disable_link_date'] == 1) ? false : true;
                                    _e(' on ', BLOGDESIGNERPRO_TEXTDOMAIN);
                                    echo ($date_link) ? '<a href="' . get_day_link($ar_year, $ar_month, $ar_day) . '">' : '';
                                    echo apply_filters('bdp_date_format', get_the_time($date_format, $post->ID), $post->ID);
                                    echo ($date_link) ? '</a>' : '';
                                } elseif ($display_author == 1) {
                                    $author_link = (isset($bdp_settings['disable_link_author']) && $bdp_settings['disable_link_author'] == 1) ? false : true;
                                    _e('Posted by ', BLOGDESIGNERPRO_TEXTDOMAIN);
                                    echo ($author_link) ? '<a href="' . get_author_posts_url(get_the_author_meta('ID')) . '">' : '';
                                    ?><span><?php
                                            printf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_author());
                                            ?></span><?php
                                    echo ($author_link) ? '</a>' : '';
                                } elseif ($display_date == 1) {
                                    $date_link = (isset($bdp_settings['disable_link_date']) && $bdp_settings['disable_link_date'] == 1) ? false : true;
                                    _e('Posted on ', BLOGDESIGNERPRO_TEXTDOMAIN);
                                    echo ($date_link) ? '<a href="' . get_day_link($ar_year, $ar_month, $ar_day) . '">' : '';
                                    echo apply_filters('bdp_date_format', get_the_time($date_format, $post->ID), $post->ID);
                                    echo ($date_link) ? '</a>' : '';
                                }
                                if ($display_comment_count == 1) {
                                    echo ($display_date == 1 || $display_author == 1 || $date_format == 1) ? "&nbsp;/&nbsp;" : "";
                                    ?>

                                    <div class="metacomments">
                                        <i class="fa fa-comment"></i>
                                        <?php
                                        if (isset($bdp_settings['disable_link_comment']) && $bdp_settings['disable_link_comment'] == 1) {
                                            comments_number('0', '1', '%');
                                        } else {
                                            comments_popup_link('0', '1', '%');
                                        }
                                        ?>
                                    </div>
                                    <?php
                                }
                                if (isset($bdp_settings['display_postlike']) && $bdp_settings['display_postlike'] == 1) {
                                    echo do_shortcode('[likebtn_shortcode]');
                                }
                                ?>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="blog-header-avatar">
                        <?php echo get_avatar(get_the_author_meta('ID'), 70); ?>
                    </div>
                </div>
                <?php if (bdp_get_first_embed_media($post->ID) && $bdp_settings['rss_use_excerpt'] == 1) { ?>
                    <div class="bdp-post-image post-video">
                        <?php
                        if (get_post_format() == 'quote') {
                            if (has_post_thumbnail()) {
                                $post_thumbnail = 'full';
                                $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                                echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                                echo '<div class="upper_image_wrapper">';
                                echo bdp_get_first_embed_media($post->ID);
                                echo '</div>';
                            }
                        } else if (get_post_format() == 'link') {
                            if (has_post_thumbnail()) {
                                $post_thumbnail = 'full';
                                $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                                echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                                echo '<div class="upper_image_wrapper bdp_link_post_format">';
                                echo bdp_get_first_embed_media($post->ID);
                                echo '</div>';
                            }
                        } else {
                            echo bdp_get_first_embed_media($post->ID);
                        }
                        ?>
                    </div>
                    <?php
                } else {
                    $post_thumbnail = 'full';
                    $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                    if (!empty($thumbnail)) {
                        $bdp_post_image_link = (isset($bdp_settings['bdp_post_image_link']) && $bdp_settings['bdp_post_image_link'] == 0) ? false : true;
                        ?>
                        <div class="bdp-post-image">
                            <?php
                            echo ($bdp_post_image_link) ? '<a href="' . get_permalink($post->ID) . '">' : '';
                            echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                            echo ($bdp_post_image_link) ? '</a>' : '';

                            if (isset($bdp_settings['pinterest_image_share']) && $bdp_settings['pinterest_image_share'] == 1 && has_post_thumbnail()) {
                                echo bdp_pinterest($post->ID);
                            }
                            ?>
                        </div>
                        <?php
                    }
                }
                $tags_list = get_the_tag_list('', ', ');
                $categories_list = get_the_category_list(', ');
                if (( $bdp_settings['display_category'] == 1 && $categories_list ) || ( $bdp_settings['display_tag'] == 1 && $tags_list )) {
                    echo '<div class="post-meta-cats-tags">';
                }
                if ($bdp_settings['display_category'] == 1 && $categories_list) {
                    ?>
                    <div class="category-link">
                        <?php _e('Category', BLOGDESIGNERPRO_TEXTDOMAIN); ?> : <?php
                        $categories_link = (isset($bdp_settings['disable_link_category']) && $bdp_settings['disable_link_category'] == 1) ? true : false;
                        if ($categories_link) {
                            $categories_list = strip_tags($categories_list);
                        }
                        if ($categories_list):
                            printf(__(' %2$s', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $categories_list);
                            $show_sep = true;
                        endif;
                        ?>
                    </div>
                    <?php
                }
                if ($bdp_settings['display_tag'] == 1 && $tags_list) {
                    $tag_link = (isset($bdp_settings['disable_link_tag']) && $bdp_settings['disable_link_tag'] == 1) ? true : false;
                    if ($tag_link) {
                        $tags_list = strip_tags($tags_list);
                    }
                    if ($tags_list):
                        ?>
                        <div class="tags">
                            <?php _e('Tags', BLOGDESIGNERPRO_TEXTDOMAIN); ?> : <?php
                            printf(__('%2$s', BLOGDESIGNERPRO_TEXTDOMAIN), 'entry-utility-prep entry-utility-prep-tag-links', $tags_list);
                            $show_sep = true;
                            ?>
                        </div>
                        <?php
                    endif;
                }
                if (( $bdp_settings['display_category'] == 1 && $categories_list ) || ( $bdp_settings['display_tag'] == 1 && $tags_list )) {
                    echo '</div>';
                }
                ?>
                <div class="post_content">
                    <?php echo bdp_get_content($post->ID, $bdp_settings['rss_use_excerpt'], $bdp_settings['txtExcerptlength'], $bdp_settings); ?>
                </div>
            </div>
            <div class="entry-meta clearfix">
                <div class="up_arrow"></div>
                <div class="pull-left">
                    <?php if ($bdp_settings['rss_use_excerpt'] == 1 && $bdp_settings['txtReadmoretext'] != ''): ?>
                        <div class="read-more">
                            <a href="<?php echo get_permalink($post->ID); ?>">
                                <?php echo $bdp_settings['txtReadmoretext']; ?>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="pull-right social-component-count-<?php echo $bdp_settings['social_count_position']; ?>">
                    <?php bdp_get_social_icons($bdp_settings); ?>
                </div>
            </div>
            <?php do_action('bdp_after_archive_post_content'); ?>
        </div>
        <?php
    }

}