<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 * Initialise an array of all recognized font faces.
 * @return array $default
 */
if (!function_exists('bdp_default_recognized_font_faces')) {

    function bdp_default_recognized_font_faces() {
        $default = array(
            //Serif Fonts
            array('type' => 'websafe', 'version' => __('Serif Fonts', BLOGDESIGNERPRO_TEXTDOMAIN), 'label' => 'Georgia, serif'),
            array('type' => 'websafe', 'version' => __('Serif Fonts', BLOGDESIGNERPRO_TEXTDOMAIN), 'label' => '"Palatino Linotype", "Book Antiqua", Palatino, serif'),
            array('type' => 'websafe', 'version' => __('Serif Fonts', BLOGDESIGNERPRO_TEXTDOMAIN), 'label' => '"Times New Roman", Times, serif'),
            //Sans-Serif Fonts
            array('type' => 'websafe', 'version' => __('Sans-Serif Fonts', BLOGDESIGNERPRO_TEXTDOMAIN), 'label' => 'Arial, Helvetica, sans-serif'),
            array('type' => 'websafe', 'version' => __('Sans-Serif Fonts', BLOGDESIGNERPRO_TEXTDOMAIN), 'label' => '"Arial Black", Gadget, sans-serif'),
            array('type' => 'websafe', 'version' => __('Sans-Serif Fonts', BLOGDESIGNERPRO_TEXTDOMAIN), 'label' => '"Comic Sans MS", cursive, sans-serif'),
            array('type' => 'websafe', 'version' => __('Sans-Serif Fonts', BLOGDESIGNERPRO_TEXTDOMAIN), 'label' => 'Impact, Charcoal, sans-serif'),
            array('type' => 'websafe', 'version' => __('Sans-Serif Fonts', BLOGDESIGNERPRO_TEXTDOMAIN), 'label' => '"Lucida Sans Unicode", "Lucida Grande", sans-serif'),
            array('type' => 'websafe', 'version' => __('Sans-Serif Fonts', BLOGDESIGNERPRO_TEXTDOMAIN), 'label' => 'Tahoma, Geneva, sans-serif'),
            array('type' => 'websafe', 'version' => __('Sans-Serif Fonts', BLOGDESIGNERPRO_TEXTDOMAIN), 'label' => '"Trebuchet MS", Helvetica, sans-serif'),
            array('type' => 'websafe', 'version' => __('Sans-Serif Fonts', BLOGDESIGNERPRO_TEXTDOMAIN), 'label' => 'Verdana, Geneva, sans-serif'),
            //Monospace Fonts
            array('type' => 'websafe', 'version' => __('Monospace Fonts', BLOGDESIGNERPRO_TEXTDOMAIN), 'label' => '"Courier New", Courier, monospace'),
            array('type' => 'websafe', 'version' => __('Monospace Fonts', BLOGDESIGNERPRO_TEXTDOMAIN), 'label' => '"Lucida Console", Monaco, monospace')
        );

        include_once 'assets/google_fonts_collection.php';

        foreach ($googlefontsArr as $f => $val) {
            $default[] = array('type' => 'googlefont', 'version' => __('Google Fonts', BLOGDESIGNERPRO_TEXTDOMAIN), 'label' => $f, 'variants' => $val['variants'], 'subsets' => $val['subsets']);
        }
        return $default;
    }

}

/*
 *  Add social share icons
 */
if (!function_exists('bdp_get_social_icons')) {

    function bdp_get_social_icons($bdp_settings) {
        if (($bdp_settings['facebook_link'] == 1) || ($bdp_settings['twitter_link'] == 1) ||
                ($bdp_settings['google_link'] == 1) || ($bdp_settings['linkedin_link'] == 1) ||
                ($bdp_settings['instagram_link'] == 1) || ( $bdp_settings['pinterest_link'] == 1) || ( isset($bdp_settings['telegram_link']) && $bdp_settings['telegram_link'] == 1) || ( isset($bdp_settings['pocket_link']) && $bdp_settings['pocket_link'] == 1) || ( $bdp_settings['whatsapp_link'] == 1)) {
            $social_theme = ' default_social_style_1 ';
            if (isset($bdp_settings['default_icon_theme']) && isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) {
                $social_theme = ' default_social_style_' . $bdp_settings['default_icon_theme'] . ' ';
            }
            ?>
            <div class="social-component<?php echo $social_theme; ?><?php echo 'bdp_social_count_'. get_the_ID(); ?><?php
            if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 0) {
                if (isset($bdp_settings['social_icon_size']) && $bdp_settings['social_icon_size'] == 0) {
                    echo ' large ';
                } elseif (isset($bdp_settings['social_icon_size']) && $bdp_settings['social_icon_size'] == 2) {
                    echo ' extra_small ';
                }
            }
            ?> <?php
            if (isset($bdp_settings['social_count_position'])) {
                echo $bdp_settings['social_count_position'];
            }
            ?>">
                     <?php
                     if ($bdp_settings['facebook_link'] == 1) {

                         if (isset($bdp_settings['facebook_link_with_count']) && $bdp_settings['facebook_link_with_count'] == 1) {
                             ?>
                             <?php if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) { ?>
                            <div class="social-share">
                                <a href="<?php echo 'https://www.facebook.com/sharer/sharer.php?u=' . get_the_permalink(); ?>" target= _blank class="bdp-facebook-share social-share-default">
                                </a>
                            </div>
                        <?php } else { ?>
                            <div class="social-share">
                                <a href="<?php echo 'https://www.facebook.com/sharer/sharer.php?u=' . get_the_permalink(); ?>" target= _blank class="bdp-facebook-share facebook-share">
                                    <i class="fa fa-facebook"></i>
                                </a>
                            </div>
                        <?php } ?>
                    <?php } else { ?>
                        <div class="social-share">
                            <?php
                            if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) {
                                if (isset($bdp_settings['social_count_position']) && $bdp_settings['social_count_position'] == 'top') {
                                    ?>
                                    <div class="count c_facebook facebook-count">0</div><?php } ?>
                                <a href="<?php echo 'https://www.facebook.com/sharer/sharer.php?u=' . get_the_permalink(); ?>" target= _blank class="bdp-facebook-share social-share-default">
                                </a>
                                <?php
                            } else {
                                if (isset($bdp_settings['social_count_position']) && $bdp_settings['social_count_position'] == 'top') {
                                    ?>
                                    <div class="count c_facebook facebook-count">0</div><?php }
                                ?>
                                <a href="<?php echo 'https://www.facebook.com/sharer/sharer.php?u=' . get_the_permalink(); ?>" target= _blank class="bdp-facebook-share facebook-share">
                                    <i class="fa fa-facebook"></i>
                                </a>
                                <?php
                            }
                            if ((isset($bdp_settings['social_count_position']) && $bdp_settings['social_count_position'] == 'bottom') || (isset($bdp_settings['social_count_position']) && $bdp_settings['social_count_position'] == 'right')) {
                                ?>
                                <div class="count c_facebook facebook-count">0</div><?php } ?>
                        </div>
                        <?php
                    }
                }
                if ($bdp_settings['google_link'] == 1) {
                    if (isset($bdp_settings['google_link_with_count']) && $bdp_settings['google_link_with_count'] == 1) {
                        ?>
                        <div class="social-share">
                            <?php if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) { ?>
                                <a href="<?php echo 'https://plus.google.com/share?url=' . get_the_permalink(); ?>" target= _blank class="bdp-google-share social-share-default">
                                </a>
                            <?php } else { ?>
                                <a href="<?php echo 'https://plus.google.com/share?url=' . get_the_permalink(); ?>" target= _blank class="bdp-google-share">
                                    <i class="fa fa-google-plus"></i>
                                </a>
                            <?php } ?>
                        </div>
                    <?php } else {
                        ?>
                        <div class="social-share">
                            <?php
                            if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) {
                                if (isset($bdp_settings['social_count_position']) && $bdp_settings['social_count_position'] == 'top') {
                                    ?>
                                    <div class="count c_plus google-count">0</div> <?php }
                                ?>
                                <a href="<?php echo 'https://plus.google.com/share?url=' . get_the_permalink(); ?>" target= _blank class="bdp-google-share social-share-default">
                                </a>
                                <?php
                            } else {
                                if (isset($bdp_settings['social_count_position']) && $bdp_settings['social_count_position'] == 'top') {
                                    ?>
                                    <div class="count c_plus google-count">0</div><?php }
                                ?>
                                <a href="<?php echo 'https://plus.google.com/share?url=' . get_the_permalink(); ?>" target= _blank class="bdp-google-share">
                                    <i class="fa fa-google-plus"></i>
                                </a>
                                <?php
                            }
                            if ((isset($bdp_settings['social_count_position']) && $bdp_settings['social_count_position'] == 'bottom') || (isset($bdp_settings['social_count_position']) && $bdp_settings['social_count_position'] == 'right')) {
                                ?>
                                <div class="count c_plus google-count">0</div><?php } ?>
                        </div>
                        <?php
                    }
                }
                if ($bdp_settings['twitter_link'] == 1) {
                    echo '<div class="social-share">';
                    if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) {
                        ?>
                        <a href="<?php echo 'https://twitter.com/share?text=' . get_the_title() . '&url=' . get_the_permalink(); ?>" target= _blank class="bdp-twitter-share social-share-default">
                        </a>
                    <?php } else { ?>
                        <a href="<?php echo 'https://twitter.com/share?text=' . get_the_title() . '&url=' . get_the_permalink(); ?>" target= _blank class="bdp-twitter-share">
                            <i class="fa fa-twitter"></i>
                        </a>
                        <?php
                    }
                    echo '</div>';
                }
                if ($bdp_settings['linkedin_link'] == 1) {
                    if (isset($bdp_settings['linkedin_link_with_count']) && $bdp_settings['linkedin_link_with_count'] == 1) {
                        ?>
                        <div class="social-share">
                            <?php if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) { ?>
                                <a href="<?php echo 'https://www.linkedin.com/shareArticle?url=' . get_the_permalink(); ?>" target= _blank class="bdp-linkedin-share social-share-default">
                                </a>
                            <?php } else { ?>
                                <a href="<?php echo 'https://www.linkedin.com/shareArticle?url=' . get_the_permalink(); ?>" target= _blank class="bdp-linkedin-share">
                                    <i class="fa fa-linkedin"></i>
                                </a>
                            <?php } ?>
                        </div>
                    <?php } else {
                        ?>

                        <div class="social-share">
                            <?php
                            if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) {
                                if (isset($bdp_settings['social_count_position']) && $bdp_settings['social_count_position'] == 'top') {
                                    ?>
                                    <div class="count c_linkedin linkedin-count">0</div> <?php }
                                ?>
                                <a href="<?php echo 'https://www.linkedin.com/shareArticle?url=' . get_the_permalink(); ?>" target= _blank class="bdp-linkedin-share social-share-default">
                                </a>
                                <?php
                            } else {
                                if (isset($bdp_settings['social_count_position']) && $bdp_settings['social_count_position'] == 'top') {
                                    ?>
                                    <div class="count c_linkedin linkedin-count">0</div> <?php }
                                ?>
                                <a href="<?php echo 'https://www.linkedin.com/shareArticle?url=' . get_the_permalink(); ?>" target= _blank class="bdp-linkedin-share">
                                    <i class="fa fa-linkedin"></i>
                                </a>
                                <?php
                            }
                            if ((isset($bdp_settings['social_count_position']) && $bdp_settings['social_count_position'] == 'bottom') || (isset($bdp_settings['social_count_position']) && $bdp_settings['social_count_position'] == 'right')) {
                                ?>
                                <div class="count c_linkedin linkedin-count">0</div><?php } ?>
                        </div>
                        <?php
                    }
                }
                if ($bdp_settings['pinterest_link'] == 1) {
                    $pinterestimage = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
                    if (isset($bdp_settings['pinterest_link_with_count']) && $bdp_settings['pinterest_link_with_count'] == 1) {
                        ?>
                        <div class="social-share">
                            <?php if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) { ?>
                                <a href="<?php echo '//pinterest.com/pin/create/button/?url=' . get_the_permalink() . '&media=' . $pinterestimage[0] . '&description=' . get_the_title(); ?>" target= _blank class="bdp-pinterest-share social-share-default">
                                </a>
                            <?php } else { ?>
                                <a href="<?php echo '//pinterest.com/pin/create/button/?url=' . get_the_permalink() . '&media=' . $pinterestimage[0] . '&description=' . get_the_title(); ?>" target= _blank class="bdp-pinterest-share">
                                    <i class="fa fa-pinterest"></i>
                                </a>
                            <?php } ?>

                        </div>
                    <?php } else {
                        ?>
                        <div class="social-share">
                            <?php
                            if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) {
                                if (isset($bdp_settings['social_count_position']) && $bdp_settings['social_count_position'] == 'top') {
                                    ?>
                                    <div class="count c_pinterest pinterest-count">0</div> <?php }
                                ?>
                                <a href="<?php echo '//pinterest.com/pin/create/button/?url=' . get_the_permalink() . '&media=' . $pinterestimage[0] . '&description=' . get_the_title(); ?>" target= _blank class="bdp-pinterest-share social-share-default">
                                </a>
                                <?php
                            } else {
                                if (isset($bdp_settings['social_count_position']) && $bdp_settings['social_count_position'] == 'top') {
                                    ?>
                                    <div class="count c_pinterest pinterest-count">0</div> <?php }
                                ?>
                                <a href="<?php echo '//pinterest.com/pin/create/button/?url=' . get_the_permalink() . '&media=' . $pinterestimage[0] . '&description=' . get_the_title(); ?>" target= _blank class="bdp-pinterest-share">
                                    <i class="fa fa-pinterest"></i>
                                </a>
                                <?php
                            }
                            if ((isset($bdp_settings['social_count_position']) && $bdp_settings['social_count_position'] == 'bottom') || (isset($bdp_settings['social_count_position']) && $bdp_settings['social_count_position'] == 'right')) {
                                ?>
                                <div class="count c_pinterest pinterest-count">0</div><?php } ?>
                        </div>
                        <?php
                    }
                }

                if (isset($bdp_settings['telegram_link']) && $bdp_settings['telegram_link'] == 1) {
                    echo '<div class="social-share">';
                    if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) {
                        ?>
                        <a href="<?php echo 'https://telegram.me/share/url?url=' . get_the_permalink() . '&text=' . get_the_title(); ?>" target= _blank class="bdp-telegram-share social-share-default">
                        </a>
                    <?php } else { ?>
                        <a href="<?php echo 'https://telegram.me/share/url?url=' . get_the_permalink() . '&text=' . get_the_title(); ?>" target= _blank class="bdp-telegram-share">
                            <i class="fa fa-paper-plane"></i>
                        </a>
                        <?php
                    }
                    echo '</div>';
                }

                if (isset($bdp_settings['pocket_link']) && $bdp_settings['pocket_link'] == 1) {
                    echo '<div class="social-share">';
                    if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) {
                        ?>
                        <a href="<?php echo 'https://getpocket.com/save?url=' . get_the_permalink() . '&title=' . get_the_title(); ?>" target= _blank class="bdp-pocket-share social-share-default">
                        </a>
                    <?php } else { ?>
                        <a href="<?php echo 'https://getpocket.com/save?url=' . get_the_permalink() . '&title=' . get_the_title(); ?>" target= _blank class="bdp-pocket-share">
                            <i class="fa fa-get-pocket"></i>
                        </a>
                        <?php
                    }
                    echo '</div>';
                }

                if (isset($bdp_settings['reddit_link']) && $bdp_settings['reddit_link'] == 1) {
                    echo '<div class="social-share">';
                    if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) {
                        ?>
                        <a href="<?php echo 'http://www.reddit.com/submit?url=' . get_the_permalink() . '&title=' . get_the_title(); ?>" target= _blank class="bdp-reddit-share social-share-default">
                        </a>
                    <?php } else { ?>
                        <a href="<?php echo 'http://www.reddit.com/submit?url=' . get_the_permalink() . '&title=' . get_the_title(); ?>" target= _blank class="bdp-reddit-share">
                            <i class="fa fa-reddit-alien"></i>
                        </a>
                        <?php
                    }
                    echo '</div>';
                }


                if (isset($bdp_settings['instagram_link']) && $bdp_settings['instagram_link'] == 1) {
                    echo '<div class="social-share">';
                    $text = strip_shortcodes(get_the_content());
                    $text = apply_filters('the_content', $text);
                    $text = str_replace(']]>', ']]&gt;', $text);
                    $small_text = wp_trim_words($text, 20, '');
                    ?>
                    <?php if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) { ?>
                        <a href="<?php echo 'mailto: ?subject=Blog Designer: Blog Topic - ' . get_the_title() . '&body=' . __("My Dear friends,%0D%0A%0D%0AI read one good blog link and I would link to share that same link for you. That might useful for you.%0D%0A%0D%0ALink: ", BLOGDESIGNERPRO_TEXTDOMAIN) . get_the_permalink() . "%0D%0A%0D%0ABest Regards, %0D%0ABlog Designer"; ?>" onclick="window.open(this.href, '_blank');
                            return false;" class="bdp-email-share social-share-default">
                        </a>
                    <?php } else { ?>
                        <a href="<?php echo 'mailto: ?subject=Blog Designer: Blog Topic - ' . get_the_title() . '&body=' . __("My Dear friends,%0D%0A%0D%0AI read one good blog link and I would link to share that same link for you. That might useful for you.%0D%0A%0D%0ALink: ", BLOGDESIGNERPRO_TEXTDOMAIN) . get_the_permalink() . "%0D%0A%0D%0ABest Regards,%0D%0ABlog Designer"; ?>" onclick="window.open(this.href, '_blank');
                            return false;" class="bdp-email-share">
                            <i class="fa fa-envelope-o"></i>
                        </a>
                    <?php } ?>
                    <?php
                    echo '</div>';
                }
                if (isset($bdp_settings['whatsapp_link']) && $bdp_settings['whatsapp_link'] == 1) {
                    echo '<div class="social-share whatsapp_share">';
                    if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) {
                        ?>
                        <a href="<?php echo 'whatsapp://send?text=' . get_the_title() . ' ' . get_the_permalink() . '&url=' . get_the_permalink(); ?>" target= _blank class="bdp-whatsapp-share social-share-default">
                        </a>
                    <?php } else { ?>
                        <a href="<?php echo 'whatsapp://send?text=' . get_the_title() . ' ' . get_the_permalink() . '&url=' . get_the_permalink(); ?>" data-action="share/whatsapp/share" target= _blank class="bdp-whatsapp-share">
                            <i class="fa fa-whatsapp"></i>
                        </a>
                        <?php
                    }
                    echo '</div>';
                }
                if ((!isset($bdp_settings['pinterest_link_with_count']) ) ||
                        (!isset($bdp_settings['linkedin_link_with_count']) ) ||
                        (!isset($bdp_settings['google_link_with_count']) ) ||
                        (!isset($bdp_settings['facebook_link_with_count']))
                ) {
                    if (get_the_title() != '') {
                        ?>
                        <script type="text/javascript">
                            jQuery(document).ready(function () {
                                jQuery('.<?php echo 'bdp_social_count_'. get_the_ID(); ?> .count').ShareCounter({
                                    url: '<?php echo get_the_permalink(); ?>'
                                });
                            });
                        </script>
                        <?php
                    }
                }
                ?>
            </div>
            <?php
        }
    }

}

/**
 * @param int $id
 * @param string $page
 * @return array $classes
 */
if (!function_exists('bdp_postbox_classes')) {

    function bdp_postbox_classes($id, $page) {
        if ($closed = get_user_option('bdpclosedbdpboxes_' . $page)) {
            if (!is_array($closed)) {
                $classes = array('');
            } else {
                $classes = in_array($id, $closed) ? array('closed') : array('');
            }
        } else {
            $classes = array('');
        }
        return implode(' ', $classes);
    }

}

/**
 * Get setting from database from shortcode id
 * @param int $shortcode_id
 * @global object $wpdb
 * @return boolean, null or array
 */
if (!function_exists('bdp_get_shortcode_settings')) {

    function bdp_get_shortcode_settings($shortcode_id) {
        global $wpdb;
        $tableName = $wpdb->prefix . 'blog_designer_pro_shortcodes';
        $get_settings_query = "SELECT * FROM $tableName WHERE bdid = " . $shortcode_id;
        $settings_val = $wpdb->get_results($get_settings_query, ARRAY_A);
        if (!$settings_val) {
            return;
        }
        $allsettings = $settings_val[0]['bdsettings'];
        if (is_serialized($allsettings)) {
            return $bdp_settings = unserialize($allsettings);
        }
        return false;
    }

}

/**
 * include Blog template
 * @param string $theme
 * @param array $bdp_settings
 * @param atring $alter_class
 */
if (!function_exists('bdp_get_blog_template')) {

    function bdp_get_blog_template($theme, $bdp_settings, $alter_class, $prev_year, $paged, $count_sticky, $alter_val) {
        ob_start();
        $themePath = get_stylesheet_directory() . '/bdp_templates/' . $theme;
        if (!file_exists($themePath)) {
            $themePath = BLOGDESIGNERPRO_DIR . 'bdp_templates/' . $theme;
        }
        if (file_exists($themePath)) {
            include $themePath;
        }
        return ob_get_clean();
    }

}

/**
 * include Blog load more template
 * @param string $theme
 * @param array $bdp_settings
 * @param atring $alter_class
 */
if (!function_exists('bdp_get_blog_loadmore_template')) {

    function bdp_get_blog_loadmore_template($theme, $bdp_settings, $alter_class, $prev_year, $paged, $count_sticky) {
        $themePath = get_stylesheet_directory() . '/bdp_templates/' . $theme;
        if (!file_exists($themePath)) {
            $themePath = BLOGDESIGNERPRO_DIR . 'bdp_templates/' . $theme;
        }
        if (file_exists($themePath)) {
            include $themePath;
        }
    }

}

/**
 * include selected template
 * @param string $theme
 */
if (!function_exists('bdp_get_template')) {

    function bdp_get_template($theme) {
        $themePath = get_stylesheet_directory() . '/bdp_templates/' . $theme;
        if (!file_exists($themePath)) {
            $themePath = BLOGDESIGNERPRO_DIR . 'bdp_templates/' . $theme;
        }
        if (file_exists($themePath)) {
            include $themePath;
        }
    }

}

/**
 * @return int
 */
if (!function_exists('bdp_paged')) {

    function bdp_paged() {
        if (strstr($_SERVER['REQUEST_URI'], 'paged') || strstr($_SERVER['REQUEST_URI'], 'page')) {
            if (isset($_REQUEST['paged'])) {
                $paged = $_REQUEST['paged'];
            } else {
                $uri = explode('/', $_SERVER['REQUEST_URI']);
                $uri = array_reverse($uri);
                $paged = $uri[1];
            }
        } else {
            $paged = 1;
        }
        return $paged;
    }

}

/**
 * add pagination
 * @return pagination
 */
if (!function_exists('bdp_standard_paging_nav')) {

    function bdp_standard_paging_nav() {
        // Don't print empty markup if there's only one page.
        if ($GLOBALS['wp_query']->max_num_pages < 2) {
            return;
        }
        $navigation = '';
        $paged = get_query_var('paged') ? intval(get_query_var('paged')) : 1;
        $pagenum_link = html_entity_decode(get_pagenum_link());
        $query_args = array();
        $url_parts = explode('?', $pagenum_link);

        if (isset($url_parts[1])) {
            wp_parse_str($url_parts[1], $query_args);
        }

        $pagenum_link = remove_query_arg(array_keys($query_args), $pagenum_link);
        $pagenum_link = trailingslashit($pagenum_link) . '%_%';

        $format = $GLOBALS['wp_rewrite']->using_index_permalinks() && !strpos($pagenum_link, 'index.php') ? 'index.php/' : '';
        $format .= $GLOBALS['wp_rewrite']->using_permalinks() ? user_trailingslashit('page/%#%', 'paged') : '?paged=%#%';

        // Set up paginated links.
        $links = paginate_links(array(
            'base' => $pagenum_link,
            'format' => $format,
            'total' => $GLOBALS['wp_query']->max_num_pages,
            'current' => $paged,
            'mid_size' => 1,
            'add_args' => array_map('urlencode', $query_args),
            'prev_text' => __('&larr; Previous', BLOGDESIGNERPRO_TEXTDOMAIN),
            'next_text' => __('Next &rarr;', BLOGDESIGNERPRO_TEXTDOMAIN),
            'type' => 'list',
        ));

        if ($links) :
            $navigation .= '<nav class="navigation paging-navigation" role="navigation">';
            $navigation .= $links;
            $navigation .= '</nav>';
        endif;
        return $navigation;
    }

}

/**
 * Display total downloads of plugin
 */
if (!function_exists('bdp_get_total_downloads')) {

    function bdp_get_total_downloads() {
        // Set the arguments. For brevity of code, I will set only a few fields.
        $plugins = $response = "";
        $args = array(
            'author' => 'solwininfotech',
            'fields' => array(
                'downloaded' => true,
                'downloadlink' => true
            )
        );
        // Make request and extract plug-in object. Action is query_plugins
        $response = wp_remote_post(
                'https://api.wordpress.org/plugins/info/1.0/', array(
            'body' => array(
                'action' => 'query_plugins',
                'request' => serialize((object) $args)
            )
                )
        );
        if (!is_wp_error($response)) {
            $returned_object = unserialize(wp_remote_retrieve_body($response));
            $plugins = $returned_object->plugins;
        }
        $current_slug = 'blog-designer';
        if ($plugins) {
            foreach ($plugins as $plugin) {
                if ($current_slug == $plugin->slug) {
                    if ($plugin->downloaded) {
                        ?>
                        <span class="total-downloads">
                            <span class="download-number"><?php echo $plugin->downloaded; ?></span>
                        </span>
                        <?php
                    }
                }
            }
        }
    }

}

/**
 * Display rating of plugin
 */
if (!function_exists('bdp_custom_star_rating')) {

    function bdp_custom_star_rating($args = array()) {
        $plugins = $response = "";
        $args = array(
            'author' => 'solwininfotech',
            'fields' => array(
                'downloaded' => true,
                'downloadlink' => true
            )
        );
        // Make request and extract plug-in object. Action is query_plugins
        $response = wp_remote_post(
                'https://api.wordpress.org/plugins/info/1.0/', array(
            'body' => array(
                'action' => 'query_plugins',
                'request' => serialize((object) $args)
            )
                )
        );
        if (!is_wp_error($response)) {
            $returned_object = unserialize(wp_remote_retrieve_body($response));
            $plugins = $returned_object->plugins;
        }
        $current_slug = 'blog-designer';
        if ($plugins) {
            foreach ($plugins as $plugin) {
                if ($current_slug == $plugin->slug) {
                    $rating = $plugin->rating * 5 / 100;
                    if ($rating > 0) {
                        $args = array(
                            'rating' => $rating,
                            'type' => 'rating',
                            'number' => $plugin->num_ratings,
                        );
                        wp_star_rating($args);
                    }
                }
            }
        }
    }

}

/**
 * Get first media
 * @param int postid
 * @return video, audio or gallery
 */
if (!function_exists('bdp_get_first_embed_media')) {

    function bdp_get_first_embed_media($post_id, $bdp_settings = '') {
        $post_format = get_post_format($post_id);
        $post = get_post($post_id);
        $content = $post->post_content;
        $audio_video = new WP_Embed();
        $content = $audio_video->run_shortcode($content);
        $content = $audio_video->autoembed($content);
        $content = wpautop($content);
        $embeds = get_media_embedded_in_content($content);
        if ($post_format == 'gallery') {
            $gallery_images = get_post_gallery_images($post_id);
            ob_start();
            if ($gallery_images) {
                ?>
                <div class="flexslider" style="margin:0">
                    <ul class="slides">
                        <?php
                        foreach ($gallery_images as $single_gallery_image) {
                            ?>
                            <li style="margin:0">
                                <img src="<?php echo $single_gallery_image ?>" alt="<?php esc_attr_e('gallery image', BLOGDESIGNERPRO_TEXTDOMAIN); ?>" />
                            </li>
                            <?php
                        }
                        ?>
                    </ul>
                </div>
                <?php
            }
            $gallery_img = ob_get_clean();
            return $gallery_img;
        } elseif ($post_format == 'video') {
            $pattern = get_shortcode_regex();
            if (preg_match_all('/' . $pattern . '/s', $content, $matches) && array_key_exists(2, $matches) && in_array('video', $matches[2])) {
                return do_shortcode($matches[0][0]);
            }
            if (!empty($embeds) && ((strpos($embeds[0], 'youtube') || strpos($embeds[0], 'vimeo')))) {
                return $embeds[0];
            }
        } elseif ($post_format == 'audio') {
            $pattern = get_shortcode_regex();
            if (preg_match_all('/' . $pattern . '/s', $content, $matches) && array_key_exists(2, $matches) && in_array('audio', $matches[2])) {
                if (isset($matches[0][0])) {
                    return do_shortcode($matches[0][0]);
                }
            }
            if (preg_match('/https:\/\/[\"soundcloud.com]+\.[a-zA-Z0-9]{2,3}(\/\S*)?/', $post->post_content, $result)) {
                if ( isset($result[0]) && wp_oembed_get($result[0]) ) {
                    return wp_oembed_get( $result[0] );
                }
            }
            if(preg_match_all('/<iframe.*src=\"(.*)\".*><\/iframe>/isU', $post->post_content, $matches)){
                if( $matches && isset( $matches[1] ) ){
                    $iframe_round = 0;
                    foreach ($matches[1] as $single_match) {
                        if( strpos($single_match, 'w.soundcloud.com/player/') ){
                            return $matches[0][$iframe_round];
                        }
                        $iframe_round++;
                    }
                }
            }
        }
        return false;
    }

}

/**
 * @param type $content
 * @return content Add a class in first letter
 */
function bdp_add_first_letter_structure($content){

    if ( preg_match( '#(>|]|^)(([A-Z]|[a-z]|[0-9]|[\p{L}])(.*\R)*(\R)*.*)#m', $content, $matches ) ) {
        $top_content = str_replace( $matches[2], '', $content );
        $content_change = ltrim ( $matches[2] );
        $bdp_content_first_letter = mb_substr( $content_change, 0, 1 );
        if ( mb_substr( $content_change, 1, 1 ) === ' ' ) {
            $bdp_remaining_letter = ' ' . mb_substr( $content_change, 2 );
        } else {
            $bdp_remaining_letter = mb_substr( $content_change, 1 );
        }
        $spanned_first_letter = '<span class="bdp-first-letter">' . $bdp_content_first_letter . '</span>';
        $bottom_content = $spanned_first_letter . $bdp_remaining_letter;
        return $top_content . $bottom_content;
    }
    return $content;
}

/**
 * change in exceprt content
 * @param int $bdp_post_id
 * @param boolean $rss_use_excerpt
 * @param int $excerpt_length
 * @return content or excerpt
 */
if (!function_exists('bdp_get_content')) {

    function bdp_get_content($bdp_post_id, $rss_use_excerpt = 0, $excerpt_length = 20, $bdp_settings) {
        if ($rss_use_excerpt == 0):
            $content = apply_filters('the_content', get_the_content($bdp_post_id));
            $content = apply_filters('bdp_content_change', $content, $bdp_post_id);
            if( isset($bdp_settings['firstletter_big']) && $bdp_settings['firstletter_big'] == 1 ){
                return bdp_add_first_letter_structure($content);
            }else{
                return $content;
            }
        else:
            $template_post_content_from = 'from_content';
            if (isset($bdp_settings['template_post_content_from'])) {
                $template_post_content_from = $bdp_settings['template_post_content_from'];
            }
            if ($template_post_content_from == 'from_excerpt') {
                if (get_the_excerpt($bdp_post_id) != '') {
                    return get_the_excerpt($bdp_post_id);
                } else {
                    $excerpt = get_the_content($bdp_post_id);
                    if (isset($bdp_settings['display_html_tags']) && $bdp_settings['display_html_tags'] == 1) {
                        $text = apply_filters('the_content', $excerpt);
                        if (strpos(_x('words', 'Word count type. Do not translate!', BLOGDESIGNERPRO_TEXTDOMAIN), 'characters') === 0 && preg_match('/^utf\-?8$/i', get_option('blog_charset'))) {
                            $text = trim(preg_replace("/[\n\r\t ]+/", ' ', $text), ' ');
                            preg_match_all('/./u', $text, $words_array);
                            $words_array = array_slice($words_array[0], 0, $excerpt_length + 1);
                            $sep = '';
                        } else {
                            $words_array = preg_split("/[\n\r\t ]+/", $text, $excerpt_length + 1, PREG_SPLIT_NO_EMPTY);
                            $sep = ' ';
                        }
                        if (count($words_array) > $excerpt_length) {
                            array_pop($words_array);
                            $text = implode($sep, $words_array);
                            $bdp_excerpt_data = $text;
                        } else {
                            $bdp_excerpt_data = implode($sep, $words_array);
                        }
                        $first_letter = $bdp_excerpt_data;
                        if ( preg_match( '#(>|]|^)(([A-Z]|[a-z]|[0-9]|[\p{L}])(.*\R)*(\R)*.*)#m', $first_letter, $matches ) ) {
                            $top_content = str_replace( $matches[2], '', $first_letter );
                            $content_change = ltrim ( $matches[2] );
                            $bdp_content_first_letter = mb_substr( $content_change, 0, 1 );
                            if ( mb_substr( $content_change, 1, 1 ) === ' ' ) {
                                $bdp_remaining_letter = ' ' . mb_substr( $content_change, 2 );
                            } else {
                                $bdp_remaining_letter = mb_substr( $content_change, 1 );
                            }
                            $spanned_first_letter = '<span class="bdp-first-letter">' . $bdp_content_first_letter . '</span>';
                            $bottom_content = $spanned_first_letter . $bdp_remaining_letter;
                            return $top_content . $bottom_content;
                        }
                        $bdp_excerpt_data = apply_filters('bdp_excerpt_change', $bdp_excerpt_data, $bdp_post_id);
                        return $bdp_excerpt_data;
                    } else {
                        $text = strip_shortcodes($excerpt);
                        $text = apply_filters('the_content', $text);
                        $text = str_replace(']]>', ']]&gt;', $text);
                        $bdp_excerpt_data = wp_trim_words($text, $excerpt_length, '');
                        $bdp_excerpt_data = apply_filters('bdp_excerpt_change', $bdp_excerpt_data, $bdp_post_id);
                        if (isset($bdp_settings['firstletter_big']) && $bdp_settings['firstletter_big'] == 1) {
                            return bdp_add_first_letter_structure($bdp_excerpt_data);
                        }else{
                            return $bdp_excerpt_data;
                        }
                        return $bdp_excerpt_data;
                    }
                }
            } else {
                $excerpt = get_the_content($bdp_post_id);
                if (isset($bdp_settings['display_html_tags']) && $bdp_settings['display_html_tags'] == 1) {
                    $text = apply_filters('the_content', $excerpt);

                    if (strpos(_x('words', 'Word count type. Do not translate!', BLOGDESIGNERPRO_TEXTDOMAIN), 'characters') === 0 && preg_match('/^utf\-?8$/i', get_option('blog_charset'))) {
                        $text = trim(preg_replace("/[\n\r\t ]+/", ' ', $text), ' ');
                        preg_match_all('/./u', $text, $words_array);
                        $words_array = array_slice($words_array[0], 0, $excerpt_length + 1);
                        $sep = '';
                    } else {
                        $words_array = preg_split("/[\n\r\t ]+/", $text, $excerpt_length + 1, PREG_SPLIT_NO_EMPTY);
                        $sep = ' ';
                    }
                    if (count($words_array) > $excerpt_length) {
                        array_pop($words_array);
                        $text = implode($sep, $words_array);
                        $bdp_excerpt_data = $text;
                    } else {
                        $bdp_excerpt_data = implode($sep, $words_array);
                    }
                    $first_letter = $bdp_excerpt_data;
                    if ( preg_match( '#(>|]|^)(([A-Z]|[a-z]|[0-9]|[\p{L}])(.*\R)*(\R)*.*)#m', $first_letter, $matches ) ) {
                        $top_content = str_replace( $matches[2], '', $first_letter );
                        $content_change = ltrim ( $matches[2] );
                        $bdp_content_first_letter = mb_substr( $content_change, 0, 1 );
                        if ( mb_substr( $content_change, 1, 1 ) === ' ' ) {
                            $bdp_remaining_letter = ' ' . mb_substr( $content_change, 2 );
                        } else {
                            $bdp_remaining_letter = mb_substr( $content_change, 1 );
                        }
                        $spanned_first_letter = '<span class="bdp-first-letter">' . $bdp_content_first_letter . '</span>';
                        $bottom_content = $spanned_first_letter . $bdp_remaining_letter;
                        return $top_content . $bottom_content;
                    }
                    $bdp_excerpt_data = apply_filters('bdp_excerpt_change', $bdp_excerpt_data, $bdp_post_id);
                    return $bdp_excerpt_data;
                } else {
                    $text = strip_shortcodes($excerpt);
                    $text = apply_filters('the_content', $text);
                    $text = str_replace(']]>', ']]&gt;', $text);
                    $bdp_excerpt_data = wp_trim_words($text, $excerpt_length, '');
                    $bdp_excerpt_data = apply_filters('bdp_excerpt_change', $bdp_excerpt_data, $bdp_post_id);
                    if (isset($bdp_settings['firstletter_big']) && $bdp_settings['firstletter_big'] == 1) {
                        return bdp_add_first_letter_structure($bdp_excerpt_data);
                    }else{
                        return $bdp_excerpt_data;
                    }
                }
            }
        endif;
    }

}

/*
 * add pinterest button on image
 * @param int $bdp_post_id
 * @return html pinterest image
 */
if (!function_exists('bdp_pinterest')) {

    function bdp_pinterest($bdp_post_id) {
        ob_start();
        ?>
        <div class="bdp-pinterest-share-image">
            <?php
            $img_url = wp_get_attachment_url(get_post_thumbnail_id($bdp_post_id));
            apply_filters('bdp_pinterest_img_url', $img_url, $bdp_post_id);
            ?>
            <a target="_blank" href="<?php echo 'https://pinterest.com/pin/create/button/?url=' . get_permalink($bdp_post_id) . '&media=' . $img_url; ?>"></a>
        </div>
        <?php
        $pintrest = ob_get_clean();
        return $pintrest;
    }

}

/**
 * get default image
 * @param string template name
 * @param int $bdp_post_id
 * @return html image
 */
if (!function_exists('bdp_get_sample_image')) {

    function bdp_get_sample_image($template_name = '', $bdp_post_id) {

        if ($template_name == 'boxy-clean') {
            $sample_img = '<img alt="' . esc_attr__('Feature image not available', BLOGDESIGNERPRO_TEXTDOMAIN) . '" src="' . BLOGDESIGNERPRO_URL . '/images/no_image_boxy_clean.png" />';
        } elseif ($template_name == 'deport' || $template_name == 'masonry_timeline' || $template_name == 'my_diary') {
            $sample_img = '<img alt="' . esc_attr__('Feature image not available', BLOGDESIGNERPRO_TEXTDOMAIN) . '" src="' . BLOGDESIGNERPRO_URL . '/images/No_available_deport.gif" />';
        } elseif ($template_name == 'navia') {
            $sample_img = '<img alt="' . esc_attr__('Feature image not available', BLOGDESIGNERPRO_TEXTDOMAIN) . '" class="attachment-full size-full wp-post-image" src="' . BLOGDESIGNERPRO_URL . '/images/No_available_deport.gif" />';
        } elseif ($template_name == 'invert-grid') {
            $sample_img = '<img alt="' . esc_attr__('Feature image not available', BLOGDESIGNERPRO_TEXTDOMAIN) . '" class="attachment-full size-full wp-post-image" src="' . BLOGDESIGNERPRO_URL . '/images/no_available_image_640_320.png" />';
        } elseif ($template_name == 'brit_co') {
            $sample_img = '<img alt="' . esc_attr__('Feature image not available', BLOGDESIGNERPRO_TEXTDOMAIN) . '" class="attachment-full size-full wp-post-image" src="' . BLOGDESIGNERPRO_URL . '/images/no_available_image_580_255.png" />';
        } elseif ($template_name == 'media-grid') {
            $sample_img = '<img alt="' . esc_attr__('Feature image not available', BLOGDESIGNERPRO_TEXTDOMAIN) . '" class="attachment-full size-full wp-post-image" src="' . BLOGDESIGNERPRO_URL . '/images/no_available_image_640_320.png" />';
        } elseif ($template_name == 'brit_co') {
            $sample_img = '<img width="500" height="500" alt="' . esc_attr__('Feature image not available', BLOGDESIGNERPRO_TEXTDOMAIN) . '" class="attachment-full size-full wp-post-image" src="' . BLOGDESIGNERPRO_URL . '/images/No_available_image.png" />';
        } elseif ($template_name == 'elina' || $template_name == 'chapter' || $template_name == 'brite') {
            $sample_img = '<img width="900" height="400" alt="' . esc_attr__('Feature image not available', BLOGDESIGNERPRO_TEXTDOMAIN) . '" class="attachment-full size-full wp-post-image" src="' . BLOGDESIGNERPRO_URL . '/images/no_available_image_900.gif" />';
        } else {
            $sample_img = '<img alt="' . esc_attr__('Feature image not available', BLOGDESIGNERPRO_TEXTDOMAIN) . '" src="' . BLOGDESIGNERPRO_URL . '/images/No_available_image.png" />';
        }
        $sample_img = apply_filters('bdp_sample_img', $sample_img, $template_name, $bdp_post_id);
        return $sample_img;
    }

}

/**
 * get default image
 * @param string template name
 * @param int $bdp_settings, $post_thumbnail, $post_thumbnail_id, $bdp_post_id
 * @return html image
 */
if (!function_exists('bdp_get_the_thumbnail')) {

    function bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, $post_thumbnail_id, $bdp_post_id) {
        $thumbnail = '';
        if ($post_thumbnail == '') {
            $post_thumbnail = 'full';
        }
        if (has_post_thumbnail()) {
            if (isset($bdp_settings['bdp_media_size'])) {
                if ($bdp_settings['bdp_media_size'] == 'custom') {
                    $url = wp_get_attachment_url($post_thumbnail_id);
                    $width = isset($bdp_settings['media_custom_width']) ? $bdp_settings['media_custom_width'] : 560;
                    $height = isset($bdp_settings['media_custom_height']) ? $bdp_settings['media_custom_height'] : 350;
                    $resizedImage = bdp_resize($url, $width, $height, true);
                    $thumbnail = '<img src="' . $resizedImage["url"] . '" width="' . $resizedImage["width"] . '" height="' . $resizedImage["height"] . '" title="' . get_the_title($bdp_post_id) . '" alt="' . get_the_title($bdp_post_id) . '" />';
                } else {
                    $post_thumbnail = $bdp_settings['bdp_media_size'];
                    $thumbnail = get_the_post_thumbnail($bdp_post_id, $post_thumbnail);
                }
            } else {
                $thumbnail = get_the_post_thumbnail($bdp_post_id, $post_thumbnail);
            }
        } elseif (isset($bdp_settings['bdp_default_image_id']) && $bdp_settings['bdp_default_image_id'] != '') {
            if (isset($bdp_settings['bdp_media_size'])) {
                if ($bdp_settings['bdp_media_size'] == 'custom') {
                    $url = wp_get_attachment_url($bdp_settings['bdp_default_image_id']);
                    $width = isset($bdp_settings['media_custom_width']) ? $bdp_settings['media_custom_width'] : 560;
                    $height = isset($bdp_settings['media_custom_height']) ? $bdp_settings['media_custom_height'] : 350;
                    $resizedImage = bdp_resize($url, $width, $height, true);
                    $thumbnail = '<img src="' . $resizedImage["url"] . '" width="' . $resizedImage["width"] . '" height="' . $resizedImage["height"] . '" title="' . get_the_title($bdp_post_id) . '" alt="' . get_the_title($bdp_post_id) . '" />';
                } else {
                    $post_thumbnail = $bdp_settings['bdp_media_size'];
                    $thumbnail = wp_get_attachment_image($bdp_settings['bdp_default_image_id'], $post_thumbnail);
                }
            } else {
                $thumbnail = wp_get_attachment_image($bdp_settings['bdp_default_image_id'], $post_thumbnail);
            }
        } else {
            if (in_array($bdp_settings['template_name'], array('boxy-clean', 'brit_co', 'deport', 'elina', 'invert-grid', 'media-grid', 'masonry_timeline', 'my_diary', 'navia', 'brite', 'chapter')))
                $thumbnail = bdp_get_sample_image($bdp_settings['template_name'], $bdp_post_id);
        }
        return $thumbnail;
    }

}

/**
 * Get the single post thumbnail
 */
if (!function_exists('bdp_get_the_single_post_thumbnail')) {

    function bdp_get_the_single_post_thumbnail($bdp_settings, $post_thumbnail_id, $bdp_post_id) {
        $thumbnail = '';
        $post_thumbnail = 'full';
        if (has_post_thumbnail()) {
            if (isset($bdp_settings['bdp_media_size'])) {
                if ($bdp_settings['bdp_media_size'] == 'custom') {
                    $url = wp_get_attachment_url($post_thumbnail_id);
                    $width = isset($bdp_settings['media_custom_width']) ? $bdp_settings['media_custom_width'] : 560;
                    $height = isset($bdp_settings['media_custom_height']) ? $bdp_settings['media_custom_height'] : 350;
                    $resizedImage = bdp_resize($url, $width, $height, true);
                    $thumbnail = '<img src="' . $resizedImage["url"] . '" width="' . $resizedImage["width"] . '" height="' . $resizedImage["height"] . '" title="' . get_the_title($bdp_post_id) . '" alt="' . get_the_title($bdp_post_id) . '" />';
                } else {
                    $post_thumbnail = $bdp_settings['bdp_media_size'];
                    $thumbnail = get_the_post_thumbnail($bdp_post_id, $post_thumbnail);
                }
            } else {
                $thumbnail = get_the_post_thumbnail($bdp_post_id, $post_thumbnail);
            }
        }
        return $thumbnail;
    }

}

/**
 * get default image for related posts
 * @param int $bdp_post_id
 * @return html image
 */
if (!function_exists('bdp_get_related_post_sample_image')) {

    function bdp_get_related_post_sample_image($bdp_post_id) {
        $sample_img = '<img alt="' . esc_attr__('No image available', BLOGDESIGNERPRO_TEXTDOMAIN) . '" title="' . esc_attr__('No image available', BLOGDESIGNERPRO_TEXTDOMAIN) . '" src="' . BLOGDESIGNERPRO_URL . '/images/related_post_no_available_image.png" />';
        return $sample_img;
    }

}

/**
 * insert layout
 * @param string $layout_name
 * @param array $bdp_settings
 * @global object $wpdb
 * @return int layout id
 */
if (!function_exists('bdp_insert_layout')) {

    function bdp_insert_layout($layout_name, $bdp_settings) {
        global $wpdb;
        $bdp_table_name = $wpdb->prefix . 'blog_designer_pro_shortcodes';
        $insert = $wpdb->insert(
                $bdp_table_name, array('shortcode_name' => $layout_name, 'bdsettings' => serialize($bdp_settings)), array('%s', '%s')
        );
        if ($insert === FALSE) {
            return;
        } else {
            return $wpdb->insert_id;
        }
    }

}

/**
 * get parameter array for posts query
 * @param array $bdp_settings
 * @return array parameters for posts query
 */
if (!function_exists('bdp_get_wp_query')) {

    function bdp_get_wp_query($bdp_settings) {

        $taxonomy = $terms = $tags = $cats = $author = "";
        $orderby = 'date';
        $order = 'DESC';
        if (isset($bdp_settings['custom_post_type']))
            $post_type = $bdp_settings['custom_post_type'];

        if (isset($bdp_settings['template_category']))
            $cat = $bdp_settings['template_category'];

        if (isset($bdp_settings['template_tags']))
            $tag = $bdp_settings['template_tags'];

        if (isset($bdp_settings['template_authors']))
            $author = $bdp_settings['template_authors'];

        if (isset($bdp_settings['bdp_blog_order_by']) && $bdp_settings['bdp_blog_order_by'] != '')
            $orderby = $bdp_settings['bdp_blog_order_by'];

        if (isset($bdp_settings['bdp_blog_order']) && isset($bdp_settings['bdp_blog_order_by']) && $bdp_settings['bdp_blog_order_by'] != '')
            $order = $bdp_settings['bdp_blog_order'];

        $taxo = get_object_taxonomies($post_type);

        if (empty($cat)) {
            $cat = '';
        }

        if (empty($tag)) {
            $tag = '';
        }
        if (isset($bdp_settings['exclude_category_list'])) {
            $exlude_category = 'category__not_in';
        } else {
            $exlude_category = 'category__in';
        }

        if (isset($bdp_settings['exclude_tag_list'])) {
            $exlude_tag = 'tag__not_in';
        } else {
            $exlude_tag = 'tag__in';
        }

        if (isset($bdp_settings['exclude_author_list'])) {
            $exlude_author = 'author__not_in';
        } else {
            $exlude_author = 'author__in';
        }

        if ($bdp_settings['template_name'] == 'cool_horizontal' || $bdp_settings['template_name'] == 'overlay_horizontal') {
            $posts_per_page = -1;
        } else {
            $posts_per_page = $bdp_settings['posts_per_page'];
        }
        if (isset($bdp_settings['paged'])) {
            $paged = $bdp_settings['paged'];
        } else {
            $paged = bdp_paged();
        }
        if ($post_type == 'post') {

            if ($orderby == 'meta_value_num') {
                $orderby_str = $orderby . ' date';
            } else {
                $orderby_str = $orderby;
            }
            $posts = array(
                $exlude_category => $cat,
                $exlude_tag => $tag,
                $exlude_author => $author,
                'post_type' => $post_type,
                'posts_per_page' => $posts_per_page,
                'paged' => $paged,
                'orderby' => $orderby_str,
                'order' => $order,
            );
            if ($orderby == 'meta_value_num') {
                $posts['meta_query'] = array(
                    'relation' => 'OR',
                    array(
                        'key' => '_post_like_count',
                        'compare' => 'NOT EXISTS'
                    ),
                    array(
                        'key' => '_post_like_count',
                        'compare' => 'EXISTS'
                    ),
                );
            }
            if (isset($bdp_settings['paged'])) {
                $posts['post_status'] = 'publish';
            }
            if (($orderby == 'date' || $orderby == 'modified') && isset($bdp_settings['template_name']) && ($bdp_settings['template_name'] == 'timeline' || $bdp_settings['template_name'] == 'story')) {
                $posts['ignore_sticky_posts'] = 1;
            }
            if (isset($bdp_settings['template_name']) && ($bdp_settings['template_name'] == 'explore' || $bdp_settings['template_name'] == 'hoverbic')) {
                $posts['ignore_sticky_posts'] = 1;
            }
            /**
             * Time Period Coding
             */
            if (isset($bdp_settings['blog_time_period'])) {
                $blog_time_period = $bdp_settings['blog_time_period'];
                if ($blog_time_period == 'today') {
                    $today = getdate();
                    $posts['date_query'] = array(
                        array(
                            'year' => $today['year'],
                            'month' => $today['mon'],
                            'day' => $today['mday'],
                        ),
                    );
                }
                if ($blog_time_period == 'tomorrow') {
                    $twodayslater = getdate(current_time('timestamp') + 1 * DAY_IN_SECONDS);
                    $posts['date_query'] = array(
                        array(
                            'year' => $twodayslater['year'],
                            'month' => $twodayslater['mon'],
                            'day' => $twodayslater['mday'],
                        ),
                    );
                    $posts['post_status'] = array('future');
                }
                if ($blog_time_period == 'this_week') {
                    $week = date('W');
                    $year = date('Y');
                    $posts['date_query'] = array(
                        array(
                            'year' => $year,
                            'week' => $week,
                        ),
                    );
                }
                if ($blog_time_period == 'last_week') {
                    $thisweek = date('W');
                    if ($thisweek != 1) :
                        $lastweek = $thisweek - 1;
                    else :
                        $lastweek = 52;
                    endif;

                    $year = date('Y');
                    if ($lastweek != 52) :
                        $year = date('Y');
                    else:
                        $year = date('Y') - 1;
                    endif;

                    $posts['date_query'] = array(
                        array(
                            'year' => $year,
                            'week' => $lastweek,
                        ),
                    );
                }
                if ($blog_time_period == 'next_week') {
                    $thisweek = date('W');
                    if ($thisweek != 52) :
                        $lastweek = $thisweek + 1;
                    else :
                        $lastweek = 1;
                    endif;

                    $year = date('Y');
                    if ($lastweek != 52) :
                        $year = date('Y');
                    else:
                        $year = date('Y') + 1;
                    endif;
                    $posts['date_query'] = array(
                        array(
                            'year' => $year,
                            'week' => $lastweek,
                        ),
                    );
                    $posts['post_status'] = array('future');
                }
                if ($blog_time_period == 'this_month') {
                    $today = getdate();
                    $posts['date_query'] = array(
                        array(
                            'year' => $today['year'],
                            'month' => $today['mon'],
                        ),
                    );
                }
                if ($blog_time_period == 'last_month') {
                    $twodayslater = getdate(current_time('timestamp') - 1 * MONTH_IN_SECONDS);
                    $posts['date_query'] = array(
                        array(
                            'year' => $twodayslater['year'],
                            'month' => $twodayslater['mon'],
                        ),
                    );
                }
                if ($blog_time_period == 'next_month') {
                    $twodayslater = getdate(current_time('timestamp') + 1 * MONTH_IN_SECONDS);
                    $posts['date_query'] = array(
                        array(
                            'year' => $twodayslater['year'],
                            'month' => $twodayslater['mon'],
                        ),
                    );
                    $posts['post_status'] = array('future');
                }
                if ($blog_time_period == 'last_n_days') {
                    if (isset($bdp_settings['bdp_time_period_day']) && $bdp_settings['bdp_time_period_day']) {
                        $last_n_days = $bdp_settings['bdp_time_period_day'] . ' days ago';
                        $posts['date_query'] = array(
                            array(
                                'after' => $last_n_days,
                                'inclusive' => true,
                            ),
                        );
                    }
                }
                if ($blog_time_period == 'next_n_days') {
                    if (isset($bdp_settings['bdp_time_period_day']) && $bdp_settings['bdp_time_period_day']) {
                        $next_n_days = '+' . $bdp_settings['bdp_time_period_day'] . ' days';
                        $posts['date_query'] = array(
                            array(
                                'before' => date('Y-m-d', strtotime($next_n_days)),
                                'inclusive' => true,
                            )
                        );
                        $posts['post_status'] = array('future');
                    }
                }
                if ($blog_time_period == 'between_two_date') {
                    $between_two_date_from = isset($bdp_settings['between_two_date_from']) ? $bdp_settings['between_two_date_from'] : '';
                    $between_two_date_to = isset($bdp_settings['between_two_date_to']) ? $bdp_settings['between_two_date_to'] : '';
                    $from_format = array();
                    $after = array();
                    if ($between_two_date_from) {
                        $unixtime = strtotime($between_two_date_from);
                        $from_time = date("m-d-Y", $unixtime);
                        if ($from_time) {
                            $from_format = explode('-', $from_time);
                            $after = array(
                                'year' => isset($from_format[2]) ? $from_format[2] : '',
                                'month' => isset($from_format[0]) ? $from_format[0] : '',
                                'day' => isset($from_format[1]) ? $from_format[1] : '',
                            );
                        }
                    }
                    $to_format = array();
                    $before = array();
                    if ($between_two_date_to) {
                        $unixtime = strtotime($between_two_date_to);
                        $to_time = date("m-d-Y", $unixtime);
                        if ($to_time) {
                            $to_format = explode('-', $to_time);
                            $before = array(
                                'year' => isset($to_format[2]) ? $to_format[2] : '',
                                'month' => isset($to_format[0]) ? $to_format[0] : '',
                                'day' => isset($to_format[1]) ? $to_format[1] : '',
                            );
                        }
                    }
                    $posts['date_query'] = array(
                        array(
                            'after' => $after,
                            'before' => $before,
                            'inclusive' => true,
                        ),
                    );
                }
            }
        } else {
            $tax_query = array('relation' => 'OR');
            if (isset($bdp_settings['relation']) && !empty($bdp_settings['relation'])) {
                $tax_query = $bdp_settings['relation'];
            }

            foreach ($taxo as $taxonom) {
                if (isset($bdp_settings[$taxonom . "_terms"])) {
                    if (!empty($bdp_settings[$taxonom . "_terms"])) {
                        $terms[$taxonom] = $bdp_settings[$taxonom . "_terms"];
                    }
                    if (isset($bdp_settings["exclude_" . $taxonom . "_list"])) {
                        $operator_value = 'NOT IN';
                    } else {
                        $operator_value = 'IN';
                    }
                    $tax_query[] = array(
                        'taxonomy' => $taxonom,
                        'field' => 'name',
                        'terms' => $terms[$taxonom],
                        'operator' => $operator_value
                    );
                }
            }

            if ($orderby == 'meta_value_num') {
                $orderby_str = $orderby . ' date';
            } else {
                $orderby_str = $orderby;
            }
            $posts = array(
                'post_type' => $post_type,
                'tax_query' => $tax_query,
                'posts_per_page' => $posts_per_page,
                'paged' => $paged,
                'orderby' => $orderby_str,
                'order' => $order,
                $exlude_author => $author,
            );
            if ($orderby == 'meta_value_num') {
                $posts['meta_query'] = array(
                    'relation' => 'OR',
                    array(
                        'key' => '_post_like_count',
                        'compare' => 'NOT EXISTS'
                    ),
                    array(
                        'key' => '_post_like_count',
                        'compare' => 'EXISTS'
                    ),
                );
            }
            if (($orderby == 'date' || $orderby == 'modified') && isset($bdp_settings['template_name']) && ($bdp_settings['template_name'] == 'timeline' || $bdp_settings['template_name'] == 'story')) {
                $posts['ignore_sticky_posts'] = 1;
            }
            if (isset($bdp_settings['template_name']) && ($bdp_settings['template_name'] == 'explore' || $bdp_settings['template_name'] == 'hoverbic')) {
                $posts['ignore_sticky_posts'] = 1;
            }
            /**
             * Time Period Coding
             */
            if (isset($bdp_settings['blog_time_period'])) {
                $blog_time_period = $bdp_settings['blog_time_period'];
                if ($blog_time_period == 'today') {
                    $today = getdate();
                    $posts['date_query'] = array(
                        array(
                            'year' => $today['year'],
                            'month' => $today['mon'],
                            'day' => $today['mday'],
                        ),
                    );
                }
                if ($blog_time_period == 'tomorrow') {
                    $twodayslater = getdate(current_time('timestamp') + 1 * DAY_IN_SECONDS);
                    $posts['date_query'] = array(
                        array(
                            'year' => $twodayslater['year'],
                            'month' => $twodayslater['mon'],
                            'day' => $twodayslater['mday'],
                        ),
                    );
                    $posts['post_status'] = array('future');
                }
                if ($blog_time_period == 'this_week') {
                    $week = date('W');
                    $year = date('Y');
                    $posts['date_query'] = array(
                        array(
                            'year' => $year,
                            'week' => $week,
                        ),
                    );
                }
                if ($blog_time_period == 'last_week') {
                    $thisweek = date('W');
                    if ($thisweek != 1) :
                        $lastweek = $thisweek - 1;
                    else :
                        $lastweek = 52;
                    endif;

                    $year = date('Y');
                    if ($lastweek != 52) :
                        $year = date('Y');
                    else:
                        $year = date('Y') - 1;
                    endif;

                    $posts['date_query'] = array(
                        array(
                            'year' => $year,
                            'week' => $lastweek,
                        ),
                    );
                }
                if ($blog_time_period == 'next_week') {
                    $thisweek = date('W');
                    if ($thisweek != 52) :
                        $lastweek = $thisweek + 1;
                    else :
                        $lastweek = 1;
                    endif;

                    $year = date('Y');
                    if ($lastweek != 52) :
                        $year = date('Y');
                    else:
                        $year = date('Y') + 1;
                    endif;
                    $posts['date_query'] = array(
                        array(
                            'year' => $year,
                            'week' => $lastweek,
                        ),
                    );
                    $posts['post_status'] = array('future');
                }
                if ($blog_time_period == 'this_month') {
                    $today = getdate();
                    $posts['date_query'] = array(
                        array(
                            'year' => $today['year'],
                            'month' => $today['mon'],
                        ),
                    );
                }
                if ($blog_time_period == 'last_month') {
                    $twodayslater = getdate(current_time('timestamp') - 1 * MONTH_IN_SECONDS);
                    $posts['date_query'] = array(
                        array(
                            'year' => $twodayslater['year'],
                            'month' => $twodayslater['mon'],
                        ),
                    );
                }
                if ($blog_time_period == 'next_month') {
                    $twodayslater = getdate(current_time('timestamp') + 1 * MONTH_IN_SECONDS);
                    $posts['date_query'] = array(
                        array(
                            'year' => $twodayslater['year'],
                            'month' => $twodayslater['mon'],
                        ),
                    );
                    $posts['post_status'] = array('future');
                }
                if ($blog_time_period == 'last_n_days') {
                    if (isset($bdp_settings['bdp_time_period_day']) && $bdp_settings['bdp_time_period_day']) {
                        $last_n_days = $bdp_settings['bdp_time_period_day'] . ' days ago';
                        $posts['date_query'] = array(
                            array(
                                'after' => $last_n_days,
                                'inclusive' => true,
                            ),
                        );
                    }
                }
                if ($blog_time_period == 'next_n_days') {
                    if (isset($bdp_settings['bdp_time_period_day']) && $bdp_settings['bdp_time_period_day']) {
                        $next_n_days = '+' . $bdp_settings['bdp_time_period_day'] . ' days';
                        $posts['date_query'] = array(
                            array(
                                'before' => date('Y-m-d', strtotime($next_n_days)),
                                'inclusive' => true,
                            )
                        );
                        $posts['post_status'] = array('future');
                    }
                }
                if ($blog_time_period == 'between_two_date') {
                    $between_two_date_from = isset($bdp_settings['between_two_date_from']) ? $bdp_settings['between_two_date_from'] : '';
                    $between_two_date_to = isset($bdp_settings['between_two_date_to']) ? $bdp_settings['between_two_date_to'] : '';
                    $from_format = array();
                    $after = array();
                    if ($between_two_date_from) {
                        $unixtime = strtotime($between_two_date_from);
                        $from_time = date("m-d-Y", $unixtime);
                        if ($from_time) {
                            $from_format = explode('-', $from_time);
                            $after = array(
                                'year' => isset($from_format[2]) ? $from_format[2] : '',
                                'month' => isset($from_format[0]) ? $from_format[0] : '',
                                'day' => isset($from_format[1]) ? $from_format[1] : '',
                            );
                        }
                    }
                    $to_format = array();
                    $before = array();
                    if ($between_two_date_to) {
                        $unixtime = strtotime($between_two_date_to);
                        $to_time = date("m-d-Y", $unixtime);
                        if ($to_time) {
                            $to_format = explode('-', $to_time);
                            $before = array(
                                'year' => isset($to_format[2]) ? $to_format[2] : '',
                                'month' => isset($to_format[0]) ? $to_format[0] : '',
                                'day' => isset($to_format[1]) ? $to_format[1] : '',
                            );
                        }
                    }
                    $posts['date_query'] = array(
                        array(
                            'after' => $after,
                            'before' => $before,
                            'inclusive' => true,
                        ),
                    );
                }
            }
        }
        return $posts;
    }

}

/**
 * get html of layout from layout id
 * @param it $layout_id
 * @param array $bdp_settings
 * @return html Blog Layout design
 */
if (!function_exists('bdp_layout_view_portion')) {

    function bdp_layout_view_portion($layout_id, $bdp_settings) {
        $posts = bdp_get_wp_query($bdp_settings);
        global $wp_query;
        $temp_query = $wp_query;
        //$wp_query = NULL;
        $loop = new WP_Query($posts);
        $wp_query = $loop;
        $max_num_pages = $wp_query->max_num_pages;
        $sticky_posts = get_option('sticky_posts');
        $alter = 1;
        $class = '';
        $alter_class = '';
        $prev_year = null;
        $theme = $bdp_settings['template_name'];
        $posts_per_page = $bdp_settings['posts_per_page'];
        $unique_design_option = isset($bdp_settings['unique_design_option']) ? $bdp_settings['unique_design_option'] : '';
        if (isset($bdp_settings['blog_unique_design']) && $bdp_settings['blog_unique_design'] != "") {
            $blog_unique_design = $bdp_settings['blog_unique_design'];
        } else {
            $blog_unique_design = 0;
        }
        if (isset($bdp_settings['bdp_blog_order_by'])) {
            $orderby = $bdp_settings['bdp_blog_order_by'];
        }
        $template = '';
        if ($max_num_pages > 1 && $bdp_settings['pagination_type'] == 'load_more_btn') {
            $template .= "<div class='bdp-load-more-pre'>";
        }
        if ($max_num_pages > 1 && $bdp_settings['pagination_type'] == 'load_onscroll_btn') {
            $template .= "<div class='bdp-load-onscroll-pre' id='bdp-load-onscroll-pre'>";
        }
        if ($theme == "boxy" || $theme == "brit_co" || $theme == "glossary" || $theme == "invert-grid") {
            $template .= "<div class='bdp-row $theme'>";
        }
        if($theme == "media-grid" || $theme == "chapter") {
            $column_setting = (isset($bdp_settings['column_setting']) && $bdp_settings['column_setting'] != '') ? 'column_layout_'. $bdp_settings['column_setting'] : 'column_layout_2';
            $template .= "<div class='bdp-row $column_setting $theme'>";
        }
        if ($theme == 'glossary' || $theme == 'boxy') {
            $template .= '<div class="bdp-js-masonry masonry bdp_' . $theme . '">';
        }
        if ($theme == 'boxy-clean') {
            $template .= '<div class="blog_template boxy-clean"><ul>';
        }
        $slider_navigation = isset($bdp_settings['select_slider_navigation']) ? $bdp_settings['select_slider_navigation'] : 'navigation1';
        if ($theme == 'crayon_slider') {
            $unique_id = mt_rand();
            $template .= '<div class="blog_template slider_template crayon_slider ' . $slider_navigation . ' slider_' . $unique_id . '"><ul class="slides">';
        }
        if ($theme == 'sallet_slider') {
            $unique_id = mt_rand();
            $template .= '<div class="blog_template slider_template sallet_slider ' . $slider_navigation . ' slider_' . $unique_id . '"><ul class="slides">';
        }
        if ($theme == 'sunshiny_slider') {
            $unique_id = mt_rand();
            $template .= '<div class="blog_template slider_template sunshiny_slider ' . $slider_navigation . ' slider_' . $unique_id . '"><ul class="slides">';
        }
        if ($theme == 'story') {
            $template .= '<div class="bdp_template story">';
        }
        if ($theme == 'brit_co') {
            $template .= '<div class="brit_co bdp_brit_co">';
        }
        if ($theme == 'cool_horizontal' || $theme == 'overlay_horizontal') {
            $template .= '<div class="logbook flatLine flatNav flatButton">';
        }
        if ($theme == 'my_diary') {
            $template .= '<div class="my_diary_wrapper">';
        }
        if ($theme == 'elina') {
            $template .= '<div class="elina_wrapper">';
        }
        if ($theme == 'masonry_timeline') {
            $template .= '<div class="masonry_timeline_wrapper">';
        }
        if ($theme == 'brite') {
            $template .= '<div class="brite-wrapp">';
        }
        $prev_year = null;
        $prev_year1 = null;
        $prev_month = null;
        $count_sticky = 0;
        $alter_val = 1;
        if ($loop->have_posts()) {
            if ($theme == 'explore' || $theme == 'hoverbic') {
                $template .= '<div class="blog_template bdp-grid-row">';
            }

            if($theme == 'media-grid') {
                $prev_year = 0;
            }

            if ($theme == 'timeline') {
                if (isset($bdp_settings['bdp_timeline_layout']) && $bdp_settings['bdp_timeline_layout'] == 'left_side') {
                    if (isset($bdp_settings['timeline_display_option']) && $bdp_settings['timeline_display_option'] != '') {
                        $template .= '<div class="timeline_bg_wrap left_side with_year"><div class="timeline_back clearfix">';
                    } else {
                        $template .= '<div class="timeline_bg_wrap left_side"><div class="timeline_back clearfix">';
                    }
                } elseif (isset($bdp_settings['bdp_timeline_layout']) && $bdp_settings['bdp_timeline_layout'] == 'right_side') {
                    if (isset($bdp_settings['timeline_display_option']) && $bdp_settings['timeline_display_option'] != '') {
                        $template .= '<div class="timeline_bg_wrap right_side with_year"><div class="timeline_back clearfix">';
                    } else {
                        $template .= '<div class="timeline_bg_wrap right_side"><div class="timeline_back clearfix">';
                    }
                } elseif (isset($bdp_settings['bdp_timeline_layout']) && $bdp_settings['bdp_timeline_layout'] == 'center') {
                    if (isset($bdp_settings['timeline_display_option']) && $bdp_settings['timeline_display_option'] != '') {
                        $template .= '<div class="timeline_bg_wrap center with_year"><div class="timeline_back clearfix">';
                    } else {
                        $template .= '<div class="timeline_bg_wrap center"><div class="timeline_back clearfix">';
                    }
                } else {
                    if ($orderby == 'date' || $orderby == 'modified') {
                        $template .= '<div class="timeline_bg_wrap date_order"><div class="timeline_back clearfix">';
                    } else {
                        $template .= '<div class="timeline_bg_wrap"><div class="timeline_back clearfix">';
                    }
                }
            }
            if ($theme == 'easy_timeline') {
                $template .= '<div class="blog_template bdp_blog_template easy-timeline-wrapper"><ul class="easy-timeline" data-effect="' . $bdp_settings['easy_timeline_effect'] . '">';
            }
            $ajax_preious_year = '';
            $ajax_preious_month = '';
            $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
            while (have_posts()) : the_post();
                if ($theme) {
                    if ($theme == 'timeline') {
                        if ($alter % 2 == 0) {
                            $alter_class = 'even_class';
                        } else {
                            $alter_class = 'odd_class';
                        }
                        if ($orderby == 'date' || $orderby == 'modified') {
                            if (isset($bdp_settings['timeline_display_option']) && $bdp_settings['timeline_display_option'] == 'display_year') {
                                $this_year = get_the_date('Y');
                                if ($prev_year != $this_year) {
                                    $prev_year = $this_year;
                                    if($alter_class == 'even_class'){
                                        $alter_class = 'odd_class';
                                        $alter++;
                                    }
                                    $template .= '<p class="timeline_year"><span class="year_wrap"><span class="only_year">' . $prev_year . '</span></span></p>';
                                }
                            } else if (isset($bdp_settings['timeline_display_option']) && $bdp_settings['timeline_display_option'] == 'display_month') {
                                $this_year = get_the_date('Y');
                                $this_month = get_the_time('M');
                                $prev_year = $this_year;
                                if ($prev_month != $this_month) {
                                    $prev_month = $this_month;
                                    if($alter_class == 'even_class'){
                                        $alter_class = 'odd_class';
                                        $alter++;
                                    }
                                    $template .= '<p class="timeline_year"><span class="year_wrap"><span class="year">' . $this_year . '</span><span class="month">' . $prev_month . '</span></span></p>';
                                }
                            }
                            $ajax_preious_year = get_the_date('Y');
                            $ajax_preious_month = get_the_time('M');
                        }
                    }

                    if ($theme == 'story') {
                        if ($orderby == 'date' || $orderby == 'modified') {
                            $this_year = get_the_date('Y');
                            if ($prev_year1 != $this_year) {
                                $prev_year1 = $this_year;
                                $prev_year = 0;
                            } elseif ($prev_year1 == $this_year) {
                                $prev_year = 1;
                            }
                        } else {
                            $prev_year = get_the_date('Y');
                        }
                    }
                    if (isset($bdp_settings['template_alternativebackground']) && $bdp_settings['template_alternativebackground'] == 1) {
                        if ($alter % 2 == 0) {
                            $alter_class = ' alternative-back';
                        } else {
                            $alter_class = '';
                        }
                    }
                    if ($theme == 'deport' || $theme == 'navia' || $theme == 'story') {
                        if ($alter % 2 == 0) {
                            $alter_class = 'even_class';
                        } else {
                            $alter_class = '';
                        }
                    }

                    if($theme == 'media-grid' || $theme == 'invert-grid') {
                        $alter_val = $alter; // are we on page one?
                    }
                    if ($blog_unique_design == 1) {
                        if ($theme == 'invert-grid' || $theme == 'boxy-clean' || $theme == 'news' || $theme == 'deport' || $theme == 'navia') {
                            $alter_val = $alter; // are we on page one?
                            if ($unique_design_option == 'first_post') {
                                if (1 == $paged) {
                                    if ($alter == 1) {
                                        $prev_year = 0;
                                    } else {
                                        $prev_year = 1;
                                    }
                                } else {
                                    $prev_year = 1;
                                }
                            } elseif ($unique_design_option == 'featured_posts') {
                                if (1 == $paged) {
                                    if (in_array(get_the_ID(), $sticky_posts)) {
                                        $count_sticky = count($sticky_posts);
                                        $prev_year = 0;
                                    } else {
                                        $count_sticky = count($sticky_posts);
                                        $prev_year = 1;
                                    }
                                } else {
                                    $prev_year = 1;
                                }
                            }
                        }
                        if($theme == 'media-grid') {
                            $column_setting = (isset($bdp_settings['column_setting']) && $bdp_settings['column_setting'] != '') ? $bdp_settings['column_setting'] : 2;
                            $alter_val = $alter; // are we on page one?
                            if ($unique_design_option == 'first_post') {
                                if($column_setting >= 2 && $alter <= 2) {
                                    $prev_year = 0;
                                } elseif (1 == $paged) {
                                    if ($alter == 1) {
                                        $prev_year = 0;
                                    } else {
                                        $prev_year = 1;
                                    }
                                } else {
                                    $prev_year = 1;
                                }
                            } elseif ($unique_design_option == 'featured_posts') {
                                if (1 == $paged) {
                                    if (in_array(get_the_ID(), $sticky_posts)) {
                                        $count_sticky = count($sticky_posts);
                                        $prev_year = 0;
                                    } else {
                                        $count_sticky = count($sticky_posts);
                                        $prev_year = 1;
                                    }
                                } else {
                                    $prev_year = 1;
                                }
                            }
                        }
                    }

                    if ($theme == 'invert-grid' || $theme == 'media-grid' || $theme == 'boxy-clean' || $theme == 'story' || $theme == 'explore' || $theme == 'hoverbic') {
                        $alter_class = $alter;
                    }

                    $template .= bdp_get_blog_template('blog/' . $theme . '.php', $bdp_settings, $alter_class, $prev_year, $paged, $count_sticky, $alter_val);
                    $alter ++;
                }
            endwhile;
            if ($theme == 'timeline') {
                $template .= '</div></div>';
            }
            if ($theme == 'easy_timeline') {
                $template .= '</ul></div>';
            }
            if ($theme == 'explore' || $theme == 'hoverbic') {
                $template .= '</div>';
            }
        } else {
            $template .= __('No posts found.', BLOGDESIGNERPRO_TEXTDOMAIN);
        }

        if ($alter % 2 != 1 && ( $theme == 'invert-grid' || $theme == 'media-grid' )) {
            do_action('bdp_separator_after_post');
            $template .= "</div>";
        } else if ($theme == 'invert-grid' || $theme == 'media-grid') {
            $template .= "</div>";
        }

        if($theme == "chapter") {
            $template .= "</div>";
        }

        if ($theme == 'boxy-clean' || $theme == 'crayon_slider' || $theme == 'sallet_slider' || $theme == 'sunshiny_slider') {
            $template .= "</ul></div>";
        }

        if (( $theme == 'glossary' || $theme == 'boxy' || $theme == 'story')) {
            $template .= '</div>';
        }
        if ($theme == 'brit_co') {
            $template .= '</div>';
        }
        if ($theme == 'cool_horizontal' || $theme == 'overlay_horizontal') {
            $template .= '</div>';
        }
        if ($theme == 'my_diary') {
            $template .= '</div>';
        }
        if ($theme == 'elina') {
            $template .= '</div>';
        }
        if ($theme == 'masonry_timeline') {
            $template .= '</div>';
        }
        if ($theme == 'brite') {
            $template .= '</div>';
        }

        if ($theme == "boxy" || $theme == "brit_co" || $theme == "glossary") {
            $template .= "</div>";
        }
        $slider_array = array('crayon_slider', 'sunshiny_slider', 'sallet_slider');
        if (!in_array($theme, $slider_array) && $bdp_settings['pagination_type'] != 'no_pagination') {
            if ($max_num_pages > 1 && $bdp_settings['pagination_type'] == 'load_more_btn') {
                $template .= '</div>';
                $is_loadmore_btn = '';
                if ($max_num_pages > 1) {
                    $is_loadmore_btn = '';
                } else {
                    $is_loadmore_btn = '1';
                }
                if (is_front_page()) {
                    $bdppaged = (get_query_var('page')) ? get_query_var('page') : 1;
                } else {
                    $bdppaged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                }
                $template .= '<form name="bdp-load-more-hidden" id="bdp-load-more-hidden">';
                $template .= '<input type="hidden" name="paged" id="paged" value="' . $bdppaged . '" />';
                $template .= '<input type="hidden" name="posts_per_page" id="posts_per_page" value="' . $posts_per_page . '" />';
                $template .= '<input type="hidden" name="max_num_pages" id="max_num_pages" value="' . $max_num_pages . '" />';
                $template .= '<input type="hidden" name="blog_template" id="blog_template" value="' . $theme . '" />';
                $template .= '<input type="hidden" name="blog_shortcode_id" id="blog_shortcode_id" value="' . $layout_id . '" />';
                if ($theme == 'timeline') {
                    $template .= '<input type="hidden" name="timeline_previous_year" id="timeline_previous_year" value="' . $ajax_preious_year . '" />';
                    $template .= '<input type="hidden" name="timeline_previous_month" id="timeline_previous_month" value="' . $ajax_preious_month . '" />';
                }
                $template .= '<img src="' . BLOGDESIGNERPRO_URL . '/images/loading.gif" alt="' . esc_attr__('Loading Image', BLOGDESIGNERPRO_TEXTDOMAIN) . '" style="display: none" class="loading-image" />';
                $template .= '</form>';
                if ($is_loadmore_btn == '') {
                    $class = '';
                    $template .= '<div class="bdp-load-more text-center" style="float:left;width:100%">';
                    $template .= '<a href="javascript:void(0);" class="button bdp-load-more-btn ' . $class . '">';
                    $template .= __('Load more', 'wp_blog_designer_pro');
                    $template .= '</a>';
                    $template .= '</div>';
                }
            } elseif ($max_num_pages > 1 && $bdp_settings['pagination_type'] == 'load_onscroll_btn') {
                $template .= '</div>';
                $is_load_onscroll_btn = '';
                if ($max_num_pages > 1) {
                    $is_load_onscroll_btn = '';
                } else {
                    $is_load_onscroll_btn = '1';
                }
                if (is_front_page()) {
                    $bdppaged = (get_query_var('page')) ? get_query_var('page') : 1;
                } else {
                    $bdppaged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                }
                $template .= '<form name="bdp-load-more-hidden" id="bdp-load-more-hidden">';

                $template .= '<input type="hidden" name="paged" id="paged" value="' . $bdppaged . '" />';
                if ($theme == 'story') {
                    $template .= '<input type="hidden" name="this_year" id="this_year" value="' . $this_year . '" />';
                }
                $template .= '<input type="hidden" name="posts_per_page" id="posts_per_page" value="' . $posts_per_page . '" />';
                $template .= '<input type="hidden" name="max_num_pages" id="max_num_pages" value="' . $max_num_pages . '" />';
                $template .= '<input type="hidden" name="blog_template" id="blog_template" value="' . $theme . '" />';
                $template .= '<input type="hidden" name="blog_shortcode_id" id="blog_shortcode_id" value="' . $layout_id . '" />';
                if ($theme == 'timeline') {
                    $template .= '<input type="hidden" name="timeline_previous_year" id="timeline_previous_year" value="' . $ajax_preious_year . '" />';
                    $template .= '<input type="hidden" name="timeline_previous_month" id="timeline_previous_month" value="' . $ajax_preious_month . '" />';
                }
                $template .= '<img src="' . BLOGDESIGNERPRO_URL . '/images/loading.gif" alt="' . esc_attr__('Loading Image', BLOGDESIGNERPRO_TEXTDOMAIN) . '" style="display: none" class="loading-image" />';
                $template .= '</form>';
                if ($is_load_onscroll_btn == '') {
                    $class = '';
                    $template .= '<div class="bdp-load-onscroll text-center">';
                    $template .= '<a href="javascript:void(0);" class="button bdp-load-onscroll-btn ' . $class . '">';
                    $template .= __('Loading Posts', BLOGDESIGNERPRO_TEXTDOMAIN) . '</a>';
                    $template .= '</div>';
                }
            }
            if ($bdp_settings['pagination_type'] == 'paged') {
                $template .= '<div class="wl_pagination_box ' . $class . '">';
                $template .= bdp_standard_paging_nav();
                $template .= '</div>';
            }
        }

        if (((isset($bdp_settings['filter_category']) && $bdp_settings['filter_category'] == 1)) || (isset($bdp_settings['filter_date']) && $bdp_settings['filter_date'] == 1)) {
            ?>
            <form name="bdp-filer-change" id="bdp-filer-change">
                <?php
                if ($bdp_settings['custom_post_type'] == 'post') {
                    if (isset($bdp_settings['filter_category']) && $bdp_settings['filter_category'] == 1) {
                        $categories = get_categories();
                        if (isset($bdp_settings['template_category'])) {
                            if (isset($bdp_settings['exclude_category_list'])) {
                                ?>
                                <select name="filter_cat[]" class="chosen-select filter_data" data-placeholder="<?php esc_attr_e('Choose', BLOGDESIGNERPRO_TEXTDOMAIN); ?> category" multiple="multiple">
                                    <?php
                                    foreach ($categories as $category) {
                                        if (in_array($category->term_id, $bdp_settings['template_category']) == false) {
                                            ?>
                                            <option value="<?php echo $category->term_id; ?>"><?php echo $category->name; ?></option>
                                            <?php
                                        }
                                    }
                                    ?>
                                </select>
                                <?php
                            } else {
                                ?>
                                <select name="filter_cat[]" class="chosen-select filter_data" data-placeholder="<?php esc_attr_e('Choose', BLOGDESIGNERPRO_TEXTDOMAIN); ?> category" multiple="multiple">
                                    <?php
                                    foreach ($categories as $category) {
                                        if (in_array($category->term_id, $bdp_settings['template_category'])) {
                                            ?>
                                            <option value="<?php echo $category->term_id; ?>"><?php echo $category->name; ?></option>
                                            <?php
                                        }
                                    }
                                    ?>
                                </select>
                                <?php
                            }
                        } else {
                            ?>
                            <select name="filter_cat[]" class="chosen-select filter_data" data-placeholder="<?php esc_attr_e('Choose', BLOGDESIGNERPRO_TEXTDOMAIN); ?> category" multiple="multiple">
                                <?php
                                foreach ($categories as $category) {
                                    ?>
                                    <option value="<?php echo $category->term_id; ?>"><?php echo $category->name; ?></option>
                                    <?php
                                }
                                ?>
                            </select>
                            <?php
                        }
                    }
                } else {
                    $taxonomy_names = get_object_taxonomies($bdp_settings['custom_post_type']);

                    foreach ($taxonomy_names as $taxonomy) {
                        if (isset($taxonomy)) {
                            if (isset($bdp_settings['filter_' . $taxonomy]) && $bdp_settings['filter_' . $taxonomy] == 1) {
                                $terms_list = get_terms($taxonomy);
                                $select_name = 'filter_' . $taxonomy;
                                ?>
                                <select name="<?php echo $select_name; ?>[]" id="<?php echo $select_name; ?>" class="chosen-select filter_data" data-placeholder="<?php esc_attr_e('Choose', BLOGDESIGNERPRO_TEXTDOMAIN); ?> <?php echo $taxonomy; ?>" multiple="multiple">
                                    <?php
                                    foreach ($terms_list as $term_list) {
                                        ?>
                                        <option value="<?php echo $term_list->name; ?>"><?php echo $term_list->name; ?></option>
                                        <?php
                                    }
                                    ?>
                                </select>
                                <?php
                            }
                        }
                    }
                }
                if (isset($bdp_settings['filter_date']) && $bdp_settings['filter_date'] == 1) {

                    while (have_posts()) : the_post();
                        $dates[get_the_time('Y-m')] = get_the_time('F Y');
                    endwhile;
                    ?>
                    <select name="filer_date[]" id="filer_date" class="chosen-select filter_data" data-placeholder="<?php esc_attr_e('Choose', BLOGDESIGNERPRO_TEXTDOMAIN); ?> date" multiple="multiple">
                        <?php
                        krsort($dates);
                        foreach ($dates as $key => $value) {
                            ?><option value="<?php echo $key; ?>"><?php echo $value; ?></option><?php
                        }
                        ?>
                    </select>
                    <?php
                }
                ?>
                <input type="hidden" name="blog_template" id="blog_template" value="<?php echo $theme ?>" />
                <input type="hidden" name="blog_shortcode_id" id="blog_shortcode_id" value="<?php echo $layout_id ?>" />
                <input type="hidden" name="blog_itemMargin" id="blog_itemMargin" value="<?php echo $bdp_settings["template_post_margin"]; ?>" />
                <input type="hidden" name="blog_itemWidth" id="blog_itemWidth" value="<?php echo $bdp_settings["item_width"] ?>" />
                <input type="hidden" name="blog_itemHeight" id="blog_itemHeight" value="<?php echo $bdp_settings["item_height"] ?>" />
                <input type="hidden" name="blog_easing" id="blog_easing" value="<?php echo $bdp_settings["template_easing"] ?>" />
                <input type="hidden" name="blog_startFrom" id="blog_startFrom" value="<?php echo $bdp_settings["timeline_start_from"] ?>" />
                <input type="hidden" name="blog_hideLogbook" id="blog_hideLogbook" value="<?php echo $bdp_settings['display_timeline_bar'] ?>" />
                <input type="hidden" name="blog_autoplay" id="blog_autoplay" value="<?php echo $bdp_settings["enable_autoslide"] ?>" />
                <input type="hidden" name="blog_scrollSpeed" id="blog_scrollSpeed" value="<?php echo $bdp_settings["scroll_speed"] ?>" />
                <input type="hidden" name="blog_page_number" id="blog_page_number" value="<?php echo $paged; ?>" />
            </form>
            <?php
        }
        wp_reset_query();
        $wp_query = NULL;
        $wp_query = $temp_query;

        $template_wrapper = '<div class="bdp_wrapper">';
        if (( ($theme == 'cool_horizontal' || $theme == 'overlay_horizontal' || $theme != 'crayon_slider') && ($bdp_settings['pagination_type'] == 'no_pagination') ) && isset($bdp_settings['display_customread_more']) && $bdp_settings['display_customread_more'] == 0) {
            if (isset($bdp_settings['beforeloop_Readmoretext']) && $bdp_settings['beforeloop_Readmoretext'] != '') {
                $custom_read_more_href = isset($bdp_settings['beforeloop_Readmoretextlink']) && $bdp_settings['beforeloop_Readmoretextlink'] != '' ? $bdp_settings['beforeloop_Readmoretextlink'] : '#';
                $open_customlink = isset($bdp_settings['open_customlink']) ? $bdp_settings['open_customlink'] : '';
                $custom_link_target = '';
                if ($open_customlink == 0) {
                    $custom_link_target = "target = '_blank'";
                }
                $template_wrapper .= '<div class="custom_read_more before_loop"><a href="' . esc_url($custom_read_more_href) . '" ' . $custom_link_target . ' >' . $bdp_settings['beforeloop_Readmoretext'] . '</a></div>';
            }
        }
        $template_wrapper .= $template;
        if (( ($theme == 'cool_horizontal' || $theme == 'overlay_horizontal' || $theme != 'crayon_slider') && ($bdp_settings['pagination_type'] == 'no_pagination') ) && isset($bdp_settings['display_customread_more']) && $bdp_settings['display_customread_more'] == 1) {
            if (isset($bdp_settings['beforeloop_Readmoretext']) && $bdp_settings['beforeloop_Readmoretext'] != '') {
                $custom_read_more_href = isset($bdp_settings['beforeloop_Readmoretextlink']) && $bdp_settings['beforeloop_Readmoretextlink'] != '' ? $bdp_settings['beforeloop_Readmoretextlink'] : '#';
                $open_customlink = isset($bdp_settings['open_customlink']) ? $bdp_settings['open_customlink'] : '';
                $custom_link_target = '';
                if ($open_customlink == 0) {
                    $custom_link_target = "target = '_blank'";
                }
                $template_wrapper .= '<div class="custom_read_more after_loop"><a href="' . esc_url($custom_read_more_href) . '" ' . $custom_link_target . '>' . $bdp_settings['beforeloop_Readmoretext'] . '</a></div>';
            }
        }
        $template_wrapper .= '</div>';

        return $template_wrapper;
    }

}

/**
 * get comments count
 * @return html comments
 */
if (!function_exists('bdp_comment_count')) {

    function bdp_comment_count($comment_link = true) {
        $id = get_the_ID();
        $num_comments = get_comments_number($id);
        $write_comments = '';
        if (comments_open()) {
            if ($num_comments == 0) {
                $comments = __('0 Comments');
            } elseif ($num_comments > 1) {
                $comments = $num_comments . __(' Comments');
            } else {
                $comments = __('1 Comment');
            }
            if ($comment_link) {
                $write_comments = '<a href="' . get_comments_link() . '">' . $comments . '</a>';
            } else {
                $write_comments = $comments;
            }
        } else {
            $write_comments = __('Comments are closed');
        }
        echo $write_comments;
    }

}

/**
 * Related Post Display title
 * @param string $template
 * @param int $post_perpage
 * @param string $related_post_by
 * @param string $title
 */
if (!function_exists('bdp_related_post_title')) {

    function bdp_related_post_title($template, $post_perpage, $related_post_by, $title) {
        ?>
        <h3><?php
            if ($title != "") {
                echo $title;
            } else {
                _e('Related Posts', BLOGDESIGNERPRO_TEXTDOMAIN);
            }
            ?></h3>
        <?php
    }

}

/**
 * function for display related post items
 * @param string $template
 * @param int $post_perpage
 * @param string $related_post_by
 * @param string $title
 * @param int $related_post_content_length
 */
if (!function_exists('bdp_related_post_item')) {

    function bdp_related_post_item($template, $post_perpage, $related_post_by, $title, $orderby, $order, $related_post_content_length, $related_post_content_from = "from_content") {
        if ($post_perpage == 2) {
            $col_class = "two_post";
        } elseif ($post_perpage == 3) {
            $col_class = "three_post";
        } elseif ($post_perpage == 4) {
            $col_class = "four_post";
        } else {
            $col_class = "";
        }
        ?>
        <div class="related_post_div <?php echo $col_class; ?>">
            <div class="relatedposts">
                <?php
                $args = array();
                if ($related_post_by == "category") {
                    global $post;
                    $categories = get_the_category($post->ID);
                    if ($categories) {
                        $category_ids = array();
                        foreach ($categories as $individual_category)
                            $category_ids[] = $individual_category->term_id;
                        $args = array(
                            'category__in' => $category_ids,
                            'post__not_in' => array($post->ID),
                            'posts_per_page' => $post_perpage, // Number of related posts that will be displayed.                            'caller_get_posts' => 1,
                            'orderby' => $orderby,
                            'order' => $order
                        );
                    }
                } elseif ($related_post_by == "tag") {
                    global $post;
                    $tags = wp_get_post_tags($post->ID);
                    if ($tags) {
                        $tag_ids = array();
                        foreach ($tags as $individual_tag)
                            $tag_ids[] = $individual_tag->term_id;
                        $args = array(
                            'tag__in' => $tag_ids,
                            'post__not_in' => array($post->ID),
                            'posts_per_page' => $post_perpage, // Number of related posts to display.
                            'orderby' => $orderby,
                            'order' => $order
                        );
                    }
                }
                $my_query = new wp_query($args);
                if ($my_query->have_posts()) {
                    while ($my_query->have_posts()) {
                        $my_query->the_post();
                        ?>
                        <div class="relatedthumb">
                            <a rel="external" href="<?php the_permalink() ?>"><?php
                                if (has_post_thumbnail()) {
                                    $thumbnail = get_the_post_thumbnail($post->ID, 'related-post-thumb');
                                } else {
                                    $thumbnail = bdp_get_related_post_sample_image($post->ID);
                                }
                                echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                                ?>
                                <div class="relatedpost_title"><?php the_title(); ?></div>
                            </a>
                            <?php if ($related_post_content_length != 0 && $related_post_content_length != '') { ?>
                                <?php
                                if ($related_post_content_from == 'from_excerpt' && get_the_excerpt(get_the_ID()) != '') {
                                    $excerpt = get_the_excerpt(get_the_ID());
                                } else {
                                    $excerpt = get_the_content(get_the_ID());
                                }
                                $bdp_excerpt_data = wp_trim_words($excerpt, $related_post_content_length, ' ...');
                                $bdp_excerpt_data = apply_filters('bdp_related_post_content_change', $bdp_excerpt_data, get_the_ID());
                                if (!empty($bdp_excerpt_data)) {
                                    echo '<div class="related_post_content">' . $bdp_excerpt_data . '</div>';
                                }
                                ?>
                            <?php } ?>
                        </div>

                        <?php
                    }
                } else {
                    echo '<span class="bdp-no-post-found">';
                    _e('No posts found.', BLOGDESIGNERPRO_TEXTDOMAIN);
                    echo '</span>';
                }
                wp_reset_query();
                ?>
            </div>
        </div>
        <?php
    }

}

/**
 * Function Display Author Image Using Action
 * @param string $template
 */
if (!function_exists('bdp_display_author_image')) {

    function bdp_display_author_image($template) {
        ?>
        <div class="avtar-img">
            <a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>">
                <?php
                $authorid = get_the_author_meta('ID');
                if($template == 'brite') {
                    echo get_avatar(get_the_author_meta('ID'), 112);
                } else {
                    echo get_avatar(get_the_author_meta('ID'), 150);
                }
                ?>
            </a>
        </div>
        <?php
    }

}

/**
 * Function Display Author Name Using Action
 * @param string $template
 * @param html $biography
 * @param string $title
 */
if (!function_exists('bdp_display_author_name')) {

    function bdp_display_author_name($template, $biography, $title) {
        if (!empty($title)) {
            ?>
            <span class="author">
                <?php
                if (!is_author()) {
                    $text = $title;
                    $replace = '<a href="' . get_author_posts_url(get_the_author_meta('ID')) . '">' . sprintf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_author()) . '</a>';
                    echo str_replace('[author]', $replace, $text);
                } else {
                    $text = $title;
                    $replace = sprintf(__('%s', BLOGDESIGNERPRO_TEXTDOMAIN), get_the_author());
                    echo str_replace('[author]', $replace, $text);
                }
                ?>
            </span>
            <?php
        }
    }

}

/**
 * Function Display Author Biography Using Action
 * @param string $template
 * @param boolean $display_author_biography
 */
if (!function_exists('bdp_display_author_biography')) {

    function bdp_display_author_biography($template, $display_author_biography) {
        if ($display_author_biography == 1) {
            $authorid = get_the_author_meta('ID');
            if (get_the_author_meta('description', $authorid)) {
                ?><p><?php echo get_the_author_meta('description', $authorid); ?></p>
                <?php
            }
        }
    }

}

/**
 * Function Display Author Biography Cover Div Start Using Action
 */
if (!function_exists('bdp_display_author_content_cover_start')) {

    function bdp_display_author_content_cover_start($template) {
        echo '<div class="author_content">';
    }

}

/**
 * Function Display Author Biography Cover Div End Using Action
 */
if (!function_exists('bdp_display_author_content_cover_end')) {

    function bdp_display_author_content_cover_end($template) {
        echo '</div>';
    }

}

add_filter('next_post_link', 'bdp_post_link_attributes', 1);
add_filter('previous_post_link', 'bdp_post_link_attributes', 1);

/**
 * add class in a tag
 * @param string $output
 * @return string anchor tag of with class
 */
if (!function_exists('bdp_post_link_attributes')) {

    function bdp_post_link_attributes($output) {
        $code = 'class="styled-button"';
        return str_replace('<a href=', '<a ' . $code . ' href=', $output);
    }

}

add_filter('user_contactmethods', 'bdp_author_social_links', 12, 1);

/**
 * Add facebook,twitter,Google+ links to user profile page.
 * @param array $user_info
 * @return array updated userinfo
 */
if (!function_exists('bdp_author_social_links')) {

    function bdp_author_social_links($user_info) {

        // Add user social contact links
        $user_info['googleplus'] = __('Google+', BLOGDESIGNERPRO_TEXTDOMAIN);
        $user_info['facebook'] = __('Facebook', BLOGDESIGNERPRO_TEXTDOMAIN);
        $user_info['twitter'] = __('Twitter', BLOGDESIGNERPRO_TEXTDOMAIN);
        $user_info['linkedin'] = __('LinkedIn', BLOGDESIGNERPRO_TEXTDOMAIN);

        return $user_info;
    }

}

/**
 * Add social media links of author display in single post page
 * @param string $theme
 * @param boolean $display_author_biography
 * @param string $txtAuthorTitle
 * @param array $bdp_settings
 */
if (!function_exists('bdp_display_author_social_links')) {

    function bdp_display_author_social_links($theme, $display_author_biography, $txtAuthorTitle, $bdp_settings) {
        $website = esc_url(get_the_author_meta('url'));
        $email = sanitize_email(get_the_author_meta('email'));
        $facebook = esc_url(get_the_author_meta('facebook'));
        $twitter = esc_url(get_the_author_meta('twitter'));
        $googleplus = esc_url(get_the_author_meta('googleplus'));
        $linkedin = esc_url(get_the_author_meta('linkedin'));

        if (!empty($facebook) || !empty($twitter) || !empty($googleplus) || !empty($linkedin) || !empty($website) || !empty($email)) {
            $social_theme = ' default_social_style_1 ';
            if (isset($bdp_settings['default_icon_theme']) && isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) {
                $social_theme = ' default_social_style_' . $bdp_settings['default_icon_theme'] . ' ';
            }
            ?>
            <div class="social-component<?php echo $social_theme; ?><?php
            if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 0) {
                if (isset($bdp_settings['social_icon_size']) && $bdp_settings['social_icon_size'] == 0) {
                    echo ' large ';
                } elseif (isset($bdp_settings['social_icon_size']) && $bdp_settings['social_icon_size'] == 2) {
                    echo ' extra_small ';
                }
            }
            ?>">
                     <?php if (!empty($facebook)) { ?>

                    <?php if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) { ?>
                        <a href="<?php echo $facebook; ?>" target= _blank class="bdp-facebook-share social-share-default"></a>
                        <?php
                    } else {
                        ?>
                        <a href="<?php echo $facebook; ?>" target= _blank class="bdp-facebook-share facebook-share">
                            <i class="fa fa-facebook"></i>
                        </a>
                        <?php
                    }
                    ?>

                    <?php
                }
                if (!empty($googleplus)) {                   
                    if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) { ?>
                        <a href="<?php echo $googleplus; ?>" target= _blank class="bdp-google-share social-share-default"></a>
                    <?php } else { ?>
                        <a href="<?php echo $googleplus; ?>" target= _blank class="bdp-google-share">
                            <i class="fa fa-google-plus"></i>
                        </a>
                    <?php } 
                }
                if (!empty($linkedin)) {
                    if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) { ?>
                        <a href="<?php echo $linkedin; ?>" target= _blank class="bdp-linkedin-share social-share-default"></a>
                    <?php } else { ?>
                        <a href="<?php echo $linkedin; ?>" target= _blank class="bdp-linkedin-share">
                            <i class="fa fa-linkedin"></i>
                        </a>
                        <?php
                    }
                    ?>
                    <?php
                }
                if (!empty($twitter)) {
                    if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) { ?>
                        <a href="<?php echo $twitter; ?>" target= _blank class="bdp-twitter-share social-share-default"></a>
                    <?php } else { ?>
                        <a href="<?php echo $twitter; ?>" target= _blank class="bdp-twitter-share">
                            <i class="fa fa-twitter"></i>
                        </a>
                        <?php
                    }
                }
                if (!empty($email)) {
                    ?>
                    <?php if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) { ?>
                        <a href="<?php echo 'mailto:' . $email; ?>" target= _blank class="bdp-email-share social-share-default"></a>
                    <?php } else { ?>
                        <a href="<?php echo 'mailto:' . $email; ?>" target= _blank class="bdp-email-share">
                            <i class="fa fa-envelope-o"></i>
                        </a>
                        <?php
                    }
                }
                if (!empty($website)) {
                    ?>
                    <?php if (isset($bdp_settings['social_style']) && $bdp_settings['social_style'] == 1) { ?>
                        <a href="<?php echo $website; ?>" target= _blank class="bdp-website-share social-share-default"></a>
                    <?php } else { ?>
                        <a href="<?php echo $website; ?>" target= _blank class="bdp-website-share">
                            <i class="fa fa-globe"></i>
                        </a>
                        <?php
                    }
                }
                ?>
            </div>
            <?php
        }
    }

}

/**
 * get all archive list
 * @global object $wpdb
 * @return Array List of archive table
 */
if (!function_exists('bdp_get_archive_list')) {

    function bdp_get_archive_list() {
        global $wpdb;
        $archive_array = array();
        $archives = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'bdp_archives ORDER BY id DESC');
        if ($archives) {
            foreach ($archives as $archive) {
                $archive_array[] = $archive->archive_template;
            }
        }
        return $archive_array;
    }

}

/**
 * get all Single list
 * @global object $wpdb
 * @return Array List of single tempalte list
 */
if (!function_exists('bdp_get_single_list')) {

    function bdp_get_single_list() {
        global $wpdb;
        $single_array = array();
        $singles = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'bdp_single_layouts ORDER BY id DESC');
        if ($singles) {
            foreach ($singles as $single) {
                $single_array[] = $single->single_template;
            }
        }
        return $single_array;
    }

}

/**
 * get date archive template settings
 * @global object $wpdb
 * @return array Date Template settings
 */
if (!function_exists('bdp_get_date_template_settings')) {

    function bdp_get_date_template_settings() {
        global $wpdb;
        $date_settings = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_archives WHERE archive_template = "date_template"');
        return $date_settings;
    }

}

/**
 * get author template settings
 * @global object $wpdb
 * @return array Author Template settings
 */
if (!function_exists('bdp_get_author_template_settings')) {

    function bdp_get_author_template_settings() {
        global $wpdb;
        $author_settings = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_archives WHERE archive_template = "author_template"');
        return $author_settings;
    }

}

/**
 * get author template settings
 * @global object $wpdb
 * @return array Author Template settings
 */
if (!function_exists('bdp_get_search_template_settings')) {

    function bdp_get_search_template_settings() {
        global $wpdb;
        $author_settings = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_archives WHERE archive_template = "search_template"');
        return $author_settings;
    }

}

/**
 * Get single post template settings
 * @global object $wpdb
 * @return array All Post Single Template settings
 */
if (!function_exists('bdp_get_all_single_template_settings')) {

    function bdp_get_all_single_template_settings() {
        global $wpdb;
        $all_settings = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "all"');
        return $all_settings;
    }

}

/**
 * Get single post template settings
 * @global object $wpdb
 * @return array Get bdp settings
 */
if (!function_exists('bdp_get_single_template_settings')) {

    function bdp_get_single_template_settings($cat_ids, $tag_ids) {
        global $wpdb;
        $single_data = '';
        $all_single_settings = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "all"');
        $single_post_template = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE find_in_set("' . get_the_ID() . '",single_post_id) <> 0');
        $single_category_template = '';
        $single_tag_template = '';
        if ($cat_ids) {
            foreach ($cat_ids as $cat_id) {
                $category_template = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "category" AND find_in_set("' . $cat_id . '",sub_categories) <> 0');
                if ($category_template) {
                    $single_category_template = true;
                    break;
                }
            }
            $category_template_blank = '';
            if (!$single_category_template) {
                $category_template_blank = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "category" AND sub_categories = "" AND single_post_id = ""');
                if ($category_template_blank) {
                    $single_category_template = true;
                }
            }
        }
        if ($tag_ids) {
            foreach ($tag_ids as $tag_id) {
                $tag_template = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "tag" AND find_in_set("' . $tag_id->term_id . '",sub_categories) <> 0');
                if ($tag_template) {
                    $single_tag_template = true;
                    break;
                }
            }
            $tag_template_blank = '';
            if (!$single_tag_template) {
                $tag_template_blank = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "tag" AND sub_categories = "" AND single_post_id = ""');
                if ($tag_template_blank) {
                    $single_tag_template = true;
                }
            }
        }
        if ($single_post_template) {
            if (isset($single_post_template->settings)) {
                $single_data = $single_post_template->settings;
            }
        } else if ($cat_ids && $single_category_template) {
            if ($category_template_blank) {
                $single_data = isset($category_template_blank->settings) ? $category_template_blank->settings : '';
            } else {
                $single_data = isset($all_single_settings->settings) ? $all_single_settings->settings : '';
            }
            foreach ($cat_ids as $cat_id) {
                $category_template = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "category" AND find_in_set("' . $cat_id . '",sub_categories) <> 0');
                if ($category_template) {
                    if (isset($category_template->settings)) {
                        $single_data_cat = $category_template->settings;
                        $serialize_single_data = unserialize($single_data_cat);
                        $template_posts = isset($serialize_single_data['template_posts']) ? $serialize_single_data['template_posts'] : array();
                        if (empty($template_posts)) {
                            $single_data = $category_template->settings;
                            break;
                        }
                    }
                }
            }
        } else if ($tag_ids && $single_tag_template) {
            if ($tag_template_blank) {
                $single_data = isset($tag_template_blank->settings) ? $tag_template_blank->settings : '';
            } else {
                $single_data = isset($all_single_settings->settings) ? $all_single_settings->settings : '';
            }
            foreach ($tag_ids as $tag_id) {
                $tag_template = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "tag" AND find_in_set("' . $tag_id->term_id . '",sub_categories) <> 0');
                if ($tag_template) {
                    if (isset($tag_template->settings)) {
                        $single_data_settings = $tag_template->settings;
                        $serialize_single_data = unserialize($single_data_settings);
                        $template_posts = isset($serialize_single_data['template_posts']) ? $serialize_single_data['template_posts'] : array();
                        if (empty($template_posts)) {
                            $single_data = $tag_template->settings;
                            break;
                        }
                    }
                }
            }
        } else if ($all_single_settings) {
            if (isset($all_single_settings->settings)) {
                $single_data = $all_single_settings->settings;
            }
        }
        return $single_data;
    }

}

function get_single_template_setting_front_end() {
    global $post, $wpdb;
    $post_id = $post->ID;
    $cat_ids = wp_get_post_categories($post_id);
    $tag_ids = wp_get_post_tags($post_id);
    $all_single_settings = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "all"');
    $single_template = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE find_in_set("' . get_the_ID() . '",single_post_id) <> 0');
    $single_category_template = '';
    $single_tag_template = '';
    if ($cat_ids) {
        foreach ($cat_ids as $cat_id) {
            $category_template = $wpdb->get_row('SELECT id FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "category" AND find_in_set("' . $cat_id . '",sub_categories) <> 0');
            if ($category_template) {
                $single_category_template = true;
                break;
            }
        }
        $category_template_blank = '';
        if (!$single_category_template) {
            $category_template_blank = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "category" AND sub_categories = "" AND single_post_id = ""');
            if ($category_template_blank) {
                $single_category_template = true;
            }
        }
    }
    if ($tag_ids) {
        foreach ($tag_ids as $tag_id) {
            $tag_template = $wpdb->get_row('SELECT id FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "tag" AND find_in_set("' . $tag_id->term_id . '",sub_categories) <> 0');
            if ($tag_template) {
                $single_tag_template = true;
                break;
            }
        }
        $tag_template_blank = '';
        if (!$single_tag_template) {
            $tag_template_blank = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "tag" AND sub_categories = "" AND single_post_id = ""');
            if ($tag_template_blank) {
                $single_tag_template = true;
            }
        }
    }
    if ($single_template) {
        if (isset($single_template->settings) && is_serialized($single_template->settings)) {
            $bdp_settings = unserialize($single_template->settings);
        }
    } else if ($cat_ids && $single_category_template) {
        if ($category_template_blank) {
            $bdp_settings = isset($category_template_blank->settings) ? unserialize($category_template_blank->settings) : '';
        } else {
            $bdp_settings = isset($all_single_settings->settings) ? unserialize($all_single_settings->settings) : '';
        }
        foreach ($cat_ids as $cat_id) {
            $category_template = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "category" AND find_in_set("' . $cat_id . '",sub_categories) <> 0');
            if ($category_template) {
                if (isset($category_template->settings) && is_serialized($category_template->settings)) {
                    $serialize_single_data = unserialize($category_template->settings);
                    $template_posts = isset($serialize_single_data['template_posts']) ? $serialize_single_data['template_posts'] : array();
                    if (empty($template_posts)) {
                        $bdp_settings = unserialize($category_template->settings);
                        break;
                    }
                }
            }
        }
    } else if ($tag_ids && $single_tag_template) {
        if ($tag_template_blank) {
            $bdp_settings = isset($tag_template_blank->settings) ? unserialize($tag_template_blank->settings) : '';
        } else {
            $bdp_settings = isset($all_single_settings->settings) ? unserialize($all_single_settings->settings) : '';
        }
        foreach ($tag_ids as $tag_id) {
            $tag_template = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "tag" AND find_in_set("' . $tag_id->term_id . '",sub_categories) <> 0');
            if ($tag_template) {
                if (isset($tag_template->settings) && is_serialized($tag_template->settings)) {
                    $serialize_single_data = unserialize($tag_template->settings);
                    $template_posts = isset($serialize_single_data['template_posts']) ? $serialize_single_data['template_posts'] : array();
                    if (empty($template_posts)) {
                        $bdp_settings = unserialize($tag_template->settings);
                        break;
                    }
                }
            }
        }
    } else if ($all_single_settings) {
        if (isset($all_single_settings->settings) && is_serialized($all_single_settings->settings)) {
            $bdp_settings = unserialize($all_single_settings->settings);
        }
    } else {
        $bdp_settings = array();
    }
    return $bdp_settings;
}

/**
 * get author template settings
 * @param int $tag_id
 * @param array $archive_list
 * @return array Author Template settings
 */
if (!function_exists('bdp_get_tag_template_settings')) {

    function bdp_get_tag_template_settings($tag_id, $archive_list) {
        $bdp_settings = array();
        if ($archive_list) {
            foreach ($archive_list as $archive) {
                if ($archive == 'tag_template') {
                    global $wpdb;
                    $tag_template = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_archives WHERE archive_template = "tag_template" AND find_in_set("' . $tag_id . '",sub_categories) <> 0');
                    if (!empty($tag_template)) {
                        $allsettings = $tag_template->settings;
                        if (is_serialized($allsettings)) {
                            $bdp_settings = unserialize($allsettings);
                        }
                    }
                }
            }
        }
        return $bdp_settings;
    }

}

/**
 * get category template settings
 * @param int $category_id
 * @param array $archive_list
 * @return Array Category Template settings
 */
if (!function_exists('bdp_get_category_template_settings')) {

    function bdp_get_category_template_settings($category_id, $archive_list) {
        $bdp_settings = array();
        if ($archive_list) {
            foreach ($archive_list as $archive) {
                if ($archive == 'category_template') {
                    global $wpdb;
                    $category_template = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'bdp_archives WHERE archive_template = "category_template" AND find_in_set("' . $category_id . '",sub_categories) <> 0');
                    if (!empty($category_template)) {
                        $allsettings = $category_template->settings;
                        if (is_serialized($allsettings)) {
                            $bdp_settings = unserialize($allsettings);
                        }
                    }
                }
            }
        }
        return $bdp_settings;
    }

}

/**
 * add notice at admin side
 * @global object $current_user
 */
if (!function_exists('bdp_admin_notice')) {

    function bdp_admin_notice() {
        global $current_user;
        $user_id = $current_user->ID;
        /* Check that the user hasn't already clicked to ignore the message */
        
        if (!get_user_meta($user_id, 'bdp_notice_ignore') && current_user_can('manage_options')) {
            echo '<div class="updated notice is-dismissible bdp-admin-notice-pro-layouts"><p>';
            ?>
            <strong><?php _e('Blog Designer PRO is a best layout builders plugin of your blog, archive and single post pages. 30+ pre-defined templates will beautify your blog section in just 5 minutes!', BLOGDESIGNERPRO_TEXTDOMAIN); ?></strong>
            <p> <a href="<?php echo esc_url('http://blogdesigner.solwininfotech.com/'); ?>" target="_blank"><strong><?php _e('Live Preview ', BLOGDESIGNERPRO_TEXTDOMAIN); ?></strong> </a> | <a href="<?php echo esc_url('https://codecanyon.net/item/blog-designer-pro-for-wordpress/17069678?ref=solwin');?>" target="_blank"><strong><?php _e('See Details ', BLOGDESIGNERPRO_TEXTDOMAIN); ?></strong></a> | <a href="<?php echo esc_url('https://www.solwininfotech.com/documents/wordpress/blogdesigner/#quick_guide');?>" target="_blank"><strong><?php _e('Detailed Documentation', BLOGDESIGNERPRO_TEXTDOMAIN)?></strong></a></p>
            <button class="notice-dismiss" type="button">
                <span class="screen-reader-text"><?php _e('Dismiss this notice.', BLOGDESIGNERPRO_TEXTDOMAIN); ?></span>
            </button>
            <?php
            echo "</p></div>";
        }
    }

}

/**
 * add notice at admin side for create sample blog layout
 * @since 1.5
 * @global object $pagenow;
 */
if (!function_exists('bdp_sample_layout_notice')) {

    function bdp_sample_layout_notice() {

        /* Check that the user hasn't already clicked to ignore the message */
        if (isset($_GET['page']) && current_user_can('manage_options') && ($_GET['page'] == 'layouts' || $_GET['page'] == 'add_shortcode')) {
            global $wpdb;
            $count_layout = $wpdb->get_var('SELECT COUNT(`bdid`) FROM ' . $wpdb->prefix . 'blog_designer_pro_shortcodes');

            if($count_layout < 1) {
                echo '<div class="updated notice is-dismissible bdp-admin-notice-pro-layouts"><p>';
                ?>
                <strong><?php _e('Create New Sample Blog layout with Blog Designer PRO Plugin', BLOGDESIGNERPRO_TEXTDOMAIN); ?></strong>&nbsp;&nbsp;&nbsp;
                <a class="bdp-create-layout button-primary" href="<?php echo esc_url(add_query_arg('sample-blog-layout', 'new', admin_url('admin.php?page=layouts'))); ?>"><?php _e('Create Layout', BLOGDESIGNERPRO_TEXTDOMAIN); ?></a>
                <button class="notice-dismiss" type="button">
                    <span class="screen-reader-text"><?php _e('Dismiss this notice.', BLOGDESIGNERPRO_TEXTDOMAIN); ?></span>
                </button>
                <?php
                echo "</p></div>";
            }
        }
    }

}

/**
 * create sample blog layout
 * @since 1.5
 * @global type $wpdb
 */
if (!function_exists('bdp_create_sample_layout')) {

    function bdp_create_sample_layout() {

        if (isset($_GET['sample-blog-layout']) && 'new' == $_GET['sample-blog-layout']) {
            global $wpdb;

            $count_layout = $wpdb->get_var('SELECT COUNT(`bdid`) FROM ' . $wpdb->prefix . 'blog_designer_pro_shortcodes');

            if($count_layout < 1) {
                $page_id = '';
                $blog_page_id = wp_insert_post(
                                            array(
                                                'post_title'=> __('Sample Blog', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                'post_type'=> 'page',
                                                'post_status'=> 'publish',
                                                'post_content'=> ''
                                            )
                                        );

                 if($blog_page_id) {
                    $page_id = $blog_page_id;
                 }

                 /* Array for sample blog layout create */
                 $sample_blog_settings = array(
                    'template_name' => 'classical',
                    'bdp_color_preset' => 'classical_default',
                    'unique_shortcode_name' => 'Sample Blog Layout',
                    'bdp_timeline_layout' => '',
                    'custom_post_type' => 'post',
                    'blog_page_display' => $page_id,
                    'blog_time_period' => 'all',
                    'between_two_date_from' => '',
                    'between_two_date_to' => '',
                    'bdp_time_period_day' => '15',
                    'posts_per_page' => '5',
                    'bdp_blog_order_by' => 'date',
                    'bdp_blog_order' => 'ASC',
                    'timeline_display_option' => '',
                    'displaydate_backcolor' => '#414a54',
                    'pagination_type' => 'paged',
                    'display_category' => '1',
                    'display_tag' => '1',
                    'display_author' => '1',
                    'display_story_year' => '1',
                    'display_date' => '1',
                    'display_comment_count' => '1',
                    'display_postlike' => '0',
                    'custom_css' => '',
                    'display_timeline_bar' => '0',
                    'timeline_start_from' => '28/01/2017',
                    'template_easing' => 'easeOutSine',
                    'item_width' => '400',
                    'item_height' => '570',
                    'template_post_margin' => '28',
                    'enable_autoslide' => '0',
                    'scroll_speed' => '1000',
                    'unique_design_option' => 'first_post',
                    'template_columns' => '2',
                    'template_grid_height' => '300',
                    'template_grid_skin' => 'default',
                    'grid_col_space' => '10',
                    'grid_hoverback_color' => '#000000',
                    'template_color' => '#ffffff',
                    'template_alternative_color' => '#c34376',
                    'story_startup_border_color' => '#ffffff',
                    'template_bgcolor' => '#ffffff',
                    'blog_background_image_style' => '1',
                    'template_bghovercolor' => '#eeeeee',
                    'template_alternativebackground' => '0',
                    'template_alterbgcolor' => '#ffffff',
                    'story_startup_text' => 'STARTUP',
                    'story_startup_background' => '#ade175',
                    'story_startup_text_color' => '#333',
                    'story_ending_text' => 'Ending',
                    'story_ending_link' => '',
                    'story_ending_background' => '#ade175',
                    'story_ending_text_color' => '#333',
                    'post_loop_alignment' => 'default',
                    'template_ftcolor' => '#007acc',
                    'template_fthovercolor' => '#666666',
                    'deport_dashcolor' => '',
                    'winter_category_color' => '',
                    'image_corner_selection' => '0',
                    'bdp_post_title_link' => '1',
                    'template_titlecolor' => '#007acc',
                    'template_titlehovercolor' => '#666666',
                    'template_titlebackcolor' => '',
                    'template_titlefontface_font_type' => '',
                    'template_titlefontface' => '',
                    'template_titlefontsize' => '30',
                    'template_title_font_weight' => 'normal',
                    'template_title_font_line_height' => '1.2',
                    'template_title_font_text_transform' => 'none',
                    'template_title_font_text_decoration' => 'none',
                    'template_title_font_letter_spacing' => '0',
                    'rss_use_excerpt' => '1',
                    'template_post_content_from' => 'from_content',
                    'display_html_tags' => '1',
                    'firstletter_fontsize' => '28',
                    'firstletter_font_family_font_type' => '',
                    'firstletter_font_family' => '',
                    'firstletter_contentcolor' => '#777777',
                    'txtExcerptlength' => '80',
                    'content_font_family_font_type' => '',
                    'content_font_family' => '',
                    'content_fontsize' => '14',
                    'content_font_weight' => 'normal',
                    'content_font_line_height' => '1.5',
                    'content_font_text_transform' => 'none',
                    'content_font_text_decoration' => 'none',
                    'content_font_letter_spacing' => '0',
                    'template_contentcolor' => '#777777',
                    'template_content_hovercolor' => '#ed4b1f',
                    'txtReadmoretext' => 'Read More',
                    'template_readmorecolor' => '#007acc',
                    'template_readmorebackcolor' => '#f1f1f1',
                    'display_feature_image' => '0',
                    'easy_timeline_effect' => 'flip-effect',
                    'thumbnail_skin' => '0',
                    'bdp_post_image_link' => '1',
                    'bdp_default_image_id' => '',
                    'bdp_default_image_src' => '',
                    'bdp_media_size' => 'full',
                    'media_custom_width' => '800',
                    'media_custom_height' => '320',
                    'template_slider_columns' => '2',
                    'template_slider_effect' => 'slide',
                    'template_slider_scroll' => '1',
                    'display_slider_navigation' => '1',
                    'select_slider_navigation' => 'navigation1',
                    'display_slider_controls' => '1',
                    'select_slider_control' => 'control1',
                    'slider_autoplay' => '1',
                    'slider_autoplay_intervals' => '3000',
                    'slider_speed' => '300',
                    'display_customread_more' => '1',
                    'beforeloop_Readmoretext' => '',
                    'beforeloop_Readmoretextlink' => '',
                    'open_customlink' => '1',
                    'beforeloop_readmorecolor' => '#ffffff',
                    'beforeloop_readmorebackcolor' => '#333333',
                    'beforeloop_readmorehovercolor' => '#333333',
                    'beforeloop_readmorehoverbackcolor' => '#f1f1f1',
                    'beforeloop_titlefontface_font_type' => '',
                    'beforeloop_titlefontface' => '',
                    'beforeloop_titlefontsize' => '14',
                    'beforeloop_title_font_weight' => 'normal',
                    'beforeloop_title_font_line_height' => '1.5',
                    'beforeloop_title_font_text_transform' => 'none',
                    'beforeloop_title_font_text_decoration' => 'none',
                    'beforeloop_title_font_letter_spacing' => '0',
                    'social_style' => '1',
                    'social_icon_style' => '1',
                    'social_icon_size' => '1',
                    'default_icon_theme' => '1',
                    'facebook_link' => '1',
                    'facebook_link_with_count' => '1',
                    'google_link' => '1',
                    'google_link_with_count' => '1',
                    'linkedin_link' => '1',
                    'linkedin_link_with_count' => '1',
                    'pinterest_link' => '1',
                    'pinterest_link_with_count' => '1',
                    'twitter_link' => '1',
                    'pocket_link' => '0',
                    'telegram_link' => '0',
                    'instagram_link' => '1',
                    'whatsapp_link' => '0',
                    'social_count_position' => 'right',
                    'savedata' => 'Save Changes'

                );

                $table_name = $wpdb->prefix . "blog_designer_pro_shortcodes";

                if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") == $table_name) {
                        $insert_shortcode = $wpdb->insert(
                                            $table_name, array(
                                            'shortcode_name' => __('Sample Blog Layout', BLOGDESIGNERPRO_TEXTDOMAIN),
                                            'bdsettings' => maybe_serialize($sample_blog_settings),
                                            )
                                        );
                        if ($insert_shortcode === FALSE) {

                            wp_die(__('Sample Blog Layout not created.', BLOGDESIGNERPRO_TEXTDOMAIN));

                        } else {
                                $layout_id = $wpdb->insert_id;
                                $blog_args = array(
                                            'ID'           => $page_id,
                                            'post_content' => '[wp_blog_designer id="'.$layout_id.'"]',
                                        );
                                $layout_inserted = wp_update_post( $blog_args );

                                if($layout_inserted) {

                                    $blog_url = get_permalink($page_id);
                                    echo "<script type=\"text/javascript\">
                                            window.open('$blog_url', '_blank')
                                        </script>";
                                }

                            }
                } else {
                    wp_die(__('Table not found. Please try again.', BLOGDESIGNERPRO_TEXTDOMAIN));
                }

            }
        }
    }

}


/**
 * add user meta for ignore notice
 * @global object $current_user
 */
if (!function_exists('bdp_detail_ignore')) {

    function bdp_detail_ignore() {
        global $current_user;
        $user_id = $current_user->ID;
        /* If user clicks to ignore the notice, add that to their user meta */
        if (isset($_GET['bdp_notice_ignore']) && '0' == $_GET['bdp_notice_ignore']) {
            add_user_meta($user_id, 'bdp_notice_ignore', 'true', true);
        }
    }

}

/**
 * Add Footer link
 */
if (!function_exists('bdp_footer')) {

    function bdp_footer() {
        $screen = get_current_screen();
        if ($screen->id == "blog-designer_page_add_shortcode" || $screen->id == "blog-designer_page_bdp_license_key" || $screen->id == "blog-designer_page_single_post" || $screen->id == "toplevel_page_layouts" || $screen->id == "blog-designer_page_archive_layouts" || $screen->id == "blog-designer_page_bdp_add_archive_layout" || $screen->id == "blog-designer_page_bdp_google_fonts" || $screen->id == "blog-designer_page_bdp_export") {
            add_filter('admin_footer_text', 'bdp_remove_footer_admin'); //change admin footer text
        }
    }

}

/**
 * Add rating html at footer of admin
 * @return html rating
 */
if (!function_exists('bdp_remove_footer_admin')) {

    function bdp_remove_footer_admin() {
        ob_start();
        ?>
        <p id="footer-left" class="alignleft">
            <?php _e('If you like ', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
            <a href="<?php esc_url('https://codecanyon.net/item/blog-designer-pro-for-wordpress/17069678'); ?>" target="_blank"><strong><?php _e('Blog Designer', BLOGDESIGNERPRO_TEXTDOMAIN); ?></strong></a>
            <?php _e('please leave us a', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
            <a class="bdp-rating-link" data-rated="Thanks :)" target="_blank" href="https://codecanyon.net/item/blog-designer-pro-for-wordpress/reviews/17069678">&#x2605;&#x2605;&#x2605;&#x2605;&#x2605;</a>
            <?php _e('rating. A huge thank you from Solwin Infotech in advance!', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
        </p>
        <?php
        return ob_get_clean();
    }

}

/**
 * check if current template is date archive or not
 * @return boolean
 */
if (!function_exists('bdp_check_archive_date_template')) {

    function bdp_check_archive_date_template($item) {
        return $item['archive_template'] === 'date_template';
    }

}

/**
 * check if current template is author archive or not
 * @return boolean
 */
if (!function_exists('bdp_check_archive_author_template')) {

    function bdp_check_archive_author_template($item) {
        return $item['archive_template'] === 'author_template';
    }

}

/**
 * check if current template is author archive or not
 * @return boolean
 */
if (!function_exists('bdp_check_single_all_template')) {

    function bdp_check_single_all_template($item) {
        return $item['single_template'] === 'all';
    }

}

/**
 * get if current theme have template file
 * @return filepath
 */
if (!function_exists('bdp_get_theme_template_file')) {

    function bdp_get_theme_template_file($template) {
        return get_stylesheet_directory() . '/' . apply_filters('bdp_template_directory', 'bdp_templates', $template) . '/' . $template;
    }

}
/**
 * Move template action.
 *
 * @param string $template_type
 */
if (!function_exists('bdp_singlefile_move_template_action')) {

    function bdp_singlefile_move_template_action($template) {
        if (!empty($template) && $template == 'single/single.php') {
            $template = 'single/single.php';
            $theme_file = bdp_get_theme_template_file($template);

            if (wp_mkdir_p(dirname($theme_file)) && !file_exists($theme_file)) {

                // Locate template file
                $template_name = BLOGDESIGNERPRO_DIR . 'bdp_templates/single/single.php';

                $template_file = apply_filters('bdp_locate_core_template', $template_name, $template);
                // Copy template file
                copy($template_file, $theme_file);

                /**
                 * bdp_copy_single_template action hook.
                 *
                 * @param string $template The copied template type
                 */
                do_action('bdp_copy_single_template', $template);

                echo '<div class="updated"><p>' . __('Template file copied to theme.', BLOGDESIGNERPRO_TEXTDOMAIN) . '</p></div>';
            }
        }
    }

}


/**
 * Delete template action.
 *
 * @param string $template_type
 */
if (!function_exists('bdp_singlefile_delete_template_action')) {

    function bdp_singlefile_delete_template_action($template) {
        if (!empty($template) && $template == 'single/single.php') {

            $theme_file = bdp_get_theme_template_file($template);

            if (file_exists($theme_file)) {
                unlink($theme_file);

                /**
                 * bdp_delete_single_template action hook.
                 *
                 * @param string $template The deleted template type
                 * @param string $email The email object
                 */
                do_action('bdp_delete_single_template', $template);

                echo '<div class="updated"><p>' . __('Template file deleted from theme.', BLOGDESIGNERPRO_TEXTDOMAIN) . '</p></div>';
            }
        }
    }

}

/**
 * Save the single templates.
 *
 * @param string $template_code
 * @param string $template_path
 */
if (!function_exists('bdp_singlefile_save_template')) {

    function bdp_singlefile_save_template($template_code, $template_path) {
        if (current_user_can('edit_themes') && !empty($template_code) && !empty($template_path)) {
            $saved = false;
            $file = get_stylesheet_directory() . '/' . $template_path;
            $code = stripslashes($template_code);

            if (is_writeable($file)) {
                $f = fopen($file, 'w+');

                if ($f !== false) {
                    fwrite($f, $code);
                    fclose($f);
                    $saved = true;
                }
            }
            if (!$saved) {
                $redirect = add_query_arg('bdp_errors', urlencode(__('Could not write to template file.', BLOGDESIGNERPRO_TEXTDOMAIN)));
                wp_safe_redirect($redirect);
                exit;
            }
        }
    }

}


/**
 * Admin actions.
 */
if (!function_exists('bdp_admin_singlefile_actions')) {

    function bdp_admin_singlefile_actions() {
        // Handle any actions
        if ((!empty($_GET['move_template']) || !empty($_GET['delete_template']) ) && 'GET' === $_SERVER['REQUEST_METHOD']) {
            if (empty($_GET['_bdp_single_nonce']) || !wp_verify_nonce($_GET['_bdp_single_nonce'], 'bdp_single_template_nonce')) {
                wp_die(__('Action failed. Please refresh the page and retry.', BLOGDESIGNERPRO_TEXTDOMAIN));
            }

            if (!current_user_can('edit_themes')) {
                wp_die(__('Cheatin&#8217; huh?', BLOGDESIGNERPRO_TEXTDOMAIN));
            }

            if (!empty($_GET['move_template'])) {
                bdp_singlefile_move_template_action($_GET['move_template']);
            }

            if (!empty($_GET['delete_template'])) {
                bdp_singlefile_delete_template_action($_GET['delete_template']);
            }
        }
    }

}

/**
 * Queue some JavaScript code to be output in the footer.
 *
 * @param string $code
 */
if (!function_exists('bdp_enqueue_js')) {

    function bdp_enqueue_js($code) {
        global $bdp_queued_js;

        if (empty($bdp_queued_js)) {
            $bdp_queued_js = '';
        }
        
        $bdp_queued_js .= "\n" . $code . "\n";
    }

}


/**
 * Output any queued javascript code in the footer.
 */
if (!function_exists('bdp_print_js')) {

    function bdp_print_js() {
        global $bdp_queued_js;

        if (!empty($bdp_queued_js)) {
            // Sanitize.
            $bdp_queued_js = wp_check_invalid_utf8($bdp_queued_js);
            $bdp_queued_js = preg_replace('/&#(x)?0*(?(1)27|39);?/i', "'", $bdp_queued_js);
            $bdp_queued_js = str_replace("\r", '', $bdp_queued_js);

            $js = "<!-- Bdp JavaScript -->\n<script type=\"text/javascript\">\njQuery(function($) { $bdp_queued_js });\n</script>\n";

            /**
             * bdp_queued_js filter.
             *
             * @param string $js JavaScript code.
             */
            echo apply_filters('bdp_queued_js', $js);

            unset($bdp_queued_js);
        }
    }

}
add_action('admin_footer', 'bdp_print_js', 25);

/**
 * Display social share text in a single post.
 * @param array $bdp_settings
 */
if (!function_exists('bdp_display_social_share_text')) {

    function bdp_display_social_share_text($bdp_settings) {
        if (!empty($bdp_settings['txtSocialIcon']) || !empty($bdp_settings['txtSocialText'])) {
            ?>
            <div class="share-this">
                <?php if (!empty($bdp_settings['txtSocialIcon'])) { ?>
                    <i class="<?php echo $bdp_settings['txtSocialIcon']; ?>"></i>
                    <?php
                }

                if (!empty($bdp_settings['txtSocialText'])) {
                    ?>
                    <span><?php printf(__(' %1$s ', BLOGDESIGNERPRO_TEXTDOMAIN), $bdp_settings['txtSocialText']); ?></span>
                    <?php
                }
                ?>
            </div>
            <?php
        }
    }

}

add_action('bdp_author_archive_detail', 'bdp_display_author_image', 5, 2);
add_action('bdp_author_archive_detail', 'bdp_display_author_content_cover_start', 10, 2);
add_action('bdp_author_archive_detail', 'bdp_display_author_name', 15, 3);
add_action('bdp_author_archive_detail', 'bdp_display_author_biography', 20, 2);
add_action('bdp_author_archive_detail', 'bdp_display_author_social_links', 25, 4);
add_action('bdp_author_archive_detail', 'bdp_display_author_content_cover_end', 30, 2);
add_action('bdp_social_share_text', 'bdp_display_social_share_text', 5, 1);


if (!function_exists('bdp_get_post_views')) {

    /**
     * Display counter with view ie. 999 Views
     * @param int $postID
     * @return string $countData
     */
    function bdp_get_post_views($postID, $bdp_settings) {
        $count_key = '_bdp_post_views_count';
        $daily_count_key = '_bdp_post_daily_count';
        $count = get_post_meta($postID, $count_key, true);
        $daily_count = get_post_meta($postID, $daily_count_key, true);
        if ($count == '') {
            $count = 1;
            update_post_meta($postID, $count_key, $count);
        }
        if ($daily_count == '') {
            $daily_count = 1;
            update_post_meta($postID, $daily_count_key, $daily_count);
        }
        $sep = ", ";
        $countData = '';
        if (isset($bdp_settings['display_post_views']) && $bdp_settings['display_post_views'] == 1) {
            $countData.= "<p>" . sprintf(_n('%d Visit today', '%d Visits today', $daily_count, BLOGDESIGNERPRO_TEXTDOMAIN), $daily_count) . "</p>";
        }
        if (isset($bdp_settings['display_post_views']) && $bdp_settings['display_post_views'] == 2) {
            $countData.="<p>" . sprintf(_n('Visited %d time', 'Visited %d times', $count, BLOGDESIGNERPRO_TEXTDOMAIN), $count);
            $countData.= $sep . sprintf(_n('%d Visit today', '%d Visits today', $daily_count, BLOGDESIGNERPRO_TEXTDOMAIN), $daily_count) . "</p>";
        }
        return $countData;
    }

}
if (!function_exists('bdp_set_post_views')) {

    /**
     * Update calculated post count
     * @param int $postID
     */
    function bdp_set_post_views($postID) {
        $user_ip = $_SERVER['REMOTE_ADDR']; //retrieve the current IP address of the visitor
        $key = $user_ip . 'x' . $postID; //combine post ID & IP to form unique key
        $value = array($user_ip, $postID); // store post ID & IP as separate values (see note)
        $visited = get_transient($key); //get transient and store in variable
        //check to see if the Post ID/IP ($key) address is currently stored as a transient
        if (false === ( $visited )) {
            //store the unique key, Post ID & IP address for 24 hours if it does not exist
            set_transient($key, $value, 60 * 60 * 24);
            // now run post views function
            $count_key = '_bdp_post_views_count';
            $daily_count_key = '_bdp_post_daily_count';
            $daily_count_date = '_bdp_daily_view_date';
            $count = get_post_meta($postID, $count_key, true);

            if ($count == '') {
                $count = 1;
            } else {
                $count++;
            }
            update_post_meta($postID, $count_key, $count);
            $viewed_count_daily = get_post_meta($postID, $daily_count_key, true);
            $daily_date = get_post_meta($postID, $daily_count_date, true);
            if ($daily_date == date('Y-m-d')) {
                update_post_meta($postID, $daily_count_key, $viewed_count_daily + 1);
            } else {
                update_post_meta($postID, $daily_count_key, '1');
            }
            update_post_meta($postID, $daily_count_date, date('Y-m-d'));
        }
    }
}