<?php
/*
 * Widget for Blog Designer Pro suppprt
 */

if (!defined('ABSPATH'))
    exit;


add_action('widgets_init', 'register_blogdesigner_widget');

function register_blogdesigner_widget() {
    register_widget('BDP_Widget_BlogDesignerPro');
}

//register_widget('BDP_Widget_BlogDesignerPro');

class BDP_Widget_BlogDesignerPro extends WP_Widget {

    public function __construct() {
        parent::__construct('blog_designer_pro_widget', __('Blog Designer PRO', 'blogdesigner'), array('classname' => 'widgte_blog_designer_pro_shortcode_list', 'description' => __('Show blogs of Blog Designer Pro. Please use this widget only for full with container area.', 'blogdesigner')));
        $this->alt_option_name = 'widgte_blog_designer_pro_shortcode_list';

        add_action('save_post', array($this, 'flush_widgte_blog_designer_pro_shortcode_list'));
        add_action('deleted_post', array($this, 'flush_widgte_blog_designer_pro_shortcode_list'));
        add_action('switch_theme', array($this, 'flush_widgte_blog_designer_pro_shortcode_list'));
    }

    public function widget($args, $instance) {
        $blog_designer_pro_shortcode_list = (isset($instance['blog_designer_pro_shortcode_list']) && $instance['blog_designer_pro_shortcode_list'] != '' ) ? (int) ($instance['blog_designer_pro_shortcode_list']) : '';
        $before_widget = $args['before_widget'];
        $after_widget = $args['after_widget'];

        if ($blog_designer_pro_shortcode_list) {
            $settings = bdp_get_shortcode_settings($blog_designer_pro_shortcode_list);
            $theme = $settings['template_name'];
            $style_name = 'bdp-' . $theme . '-template-css';
            wp_print_styles($style_name);
            wp_print_styles('bdp-front-css');
            $template_titlefontface = (isset($settings['template_titlefontface']) && $settings['template_titlefontface'] != '') ? $settings['template_titlefontface'] : "Open Sans";
            $background = (isset($settings['template_bgcolor']) && $settings['template_bgcolor'] != '') ? $settings['template_bgcolor'] : "";
            $template_bghovercolor = (isset($settings['template_bghovercolor']) && $settings['template_bghovercolor'] != '') ? $settings['template_bghovercolor'] : "#eeeeee";
            $templatecolor = (isset($settings['template_color']) && $settings['template_color'] != '') ? $settings['template_color'] : "#000";
            $color = (isset($settings['template_ftcolor']) && $settings['template_ftcolor'] != '') ? $settings['template_ftcolor'] : "#000";
            $linkhovercolor = (isset($settings['template_fthovercolor']) && $settings['template_fthovercolor'] != '') ? $settings['template_fthovercolor'] : "#000";
            $titlecolor = (isset($settings['template_titlecolor']) && $settings['template_titlecolor'] != '') ? $settings['template_titlecolor'] : "#000";
            $titlehovercolor = (isset($settings['template_titlehovercolor']) && $settings['template_titlehovercolor'] != '') ? $settings['template_titlehovercolor'] : "#000";
            $contentcolor = (isset($settings['template_contentcolor']) && $settings['template_contentcolor'] != '') ? $settings['template_contentcolor'] : "#000";
            $readmorecolor = (isset($settings['template_readmorecolor']) && $settings['template_readmorecolor'] != '') ? $settings['template_readmorecolor'] : "#fff";
            $readmorebackcolor = (isset($settings['template_readmorebackcolor']) && $settings['template_readmorebackcolor'] != '') ? $settings['template_readmorebackcolor'] : "#000";
            $alterbackground = (isset($settings['template_alterbgcolor']) && $settings['template_alterbgcolor'] != '') ? $settings['template_alterbgcolor'] : "";
            $titlebackcolor = (isset($settings['template_titlebackcolor']) && $settings['template_titlebackcolor'] != '') ? $settings['template_titlebackcolor'] : "";
            $social_icon_style = (isset($settings['social_icon_style']) && $settings['social_icon_style'] != '') ? $settings['social_icon_style'] : 0;
            $template_alternativebackground = (isset($settings['template_alternativebackground']) && $settings['template_alternativebackground'] != '') ? $settings['template_alternativebackground'] : 0;
            $template_titlefontsize = (isset($settings['template_titlefontsize']) && $settings['template_titlefontsize'] != '') ? $settings['template_titlefontsize'] : 30;
            $content_fontsize = (isset($settings['content_fontsize']) && $settings['content_fontsize'] != '') ? $settings['content_fontsize'] : 16;
            include(WP_PLUGIN_DIR . '/blog-designer-pro/css/layout_dynamic_style.php');
        }
        echo $before_widget;
        echo do_shortcode('[wp_blog_designer id=' . "$blog_designer_pro_shortcode_list" . ']');
        echo $after_widget;
    }

    public function form($instance) {
        $blog_designer_pro_shortcode_list = isset($instance['blog_designer_pro_shortcode_list']) ? $instance['blog_designer_pro_shortcode_list'] : '';
        ?>
        <p>
            <label for="blog_designer_pro_shortcode_list"><?php _e('Select Blog Layout', 'blogdesigner') ?>:</label>
            <select name="<?php echo $this->get_field_name('blog_designer_pro_shortcode_list'); ?>" class="blog_designer_pro_shortcode_list" id="blog_designer_pro_shortcode_list" style="width: 100%;">
                <option value="">-- <?php _e('Select Blog Layout', 'blogdesigner'); ?> --</option>
                <?php
                global $wpdb;
                $shortcodes = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'blog_designer_pro_shortcodes ');
                if ($shortcodes) {
                    foreach ($shortcodes as $shortcode) {
                        $shortcode_name = $shortcode->shortcode_name;
                        ?>
                        <option value="<?php echo $shortcode->bdid; ?>" <?php
                        if ($blog_designer_pro_shortcode_list == $shortcode->bdid) {
                            echo 'selected=selected';
                        }
                        ?>><?php
                                    if ($shortcode_name) {
                                        echo $shortcode_name;
                                    } else {
                                        _e('No title', 'blogdesigner');
                                    }
                                    ?></option>
                        <?php
                    }
                }
                ?>
            </select>
        </p>
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['blog_designer_pro_shortcode_list'] = (!empty($new_instance['blog_designer_pro_shortcode_list']) ) ? (int) ($new_instance['blog_designer_pro_shortcode_list']) : '';

        $alloptions = wp_cache_get('alloptions', 'options');
        if (isset($alloptions['widgte_blog_designer_pro_shortcode_list']))
            delete_option('widgte_blog_designer_pro_shortcode_list');

        return $instance;
    }

    public function flush_widgte_blog_designer_pro_shortcode_list() {
        wp_cache_delete('widgte_blog_designer_pro_shortcode_list', 'widget');
    }

}
