<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

//$plugin_lists = get_plugins();
//echo '<pre>'; print_r($plugin_lists); exit;

/* * ********************************************* */
/*                                                 */
/*              Beaver Builder Lite                */
/*                                                 */
/* * ********************************************* */

if (is_plugin_active('beaver-builder-lite-version/fl-builder.php')) {

    if (!function_exists('add_bdp_widget')) {

        function add_bdp_widget() {
            ?>
            <div id="fl-builder-blocks-bdp-widget" class="fl-builder-blocks-section">
                <span class="fl-builder-blocks-section-title">
                    <?php echo 'Blog Designer' ?>
                    <i class="fa fa-chevron-down"></i>
                </span>
                <div class="fl-builder-blocks-section-content fl-builder-modules">
                    <span class="fl-builder-block fl-builder-block-module" data-widget="BDP_Widget_BlogDesignerPro" data-type="widget">
                        <span class="fl-builder-block-title">Blog Designer PRO</span>
                    </span>
                </div>
            </div>
            <?php
        }

    }
    add_action('fl_builder_ui_panel_after_modules', 'add_bdp_widget');
}


/* * ********************************************* */
/*                                                 */
/*          Page Builder by SiteOrigin             */
/*                                                 */
/* * ********************************************* */
if (is_plugin_active('siteorigin-panels/siteorigin-panels.php')) {

    function siteorigin_panels_add_widgets_dialog_tabs_fun($tabs) {
        $tabs['blog_designer'] = array(
            'title' => __('Blog Designer', 'siteorigin-panels'),
            'filter' => array(
                'groups' => array('blog_designer')
            )
        );
        return $tabs;
    }

    add_filter('siteorigin_panels_widget_dialog_tabs', 'siteorigin_panels_add_widgets_dialog_tabs_fun', 20);

    function siteorigin_panels_add_recommended_widgets_fun($widgets) {
        foreach ($widgets as $widget_id => &$widget) {
            if (strpos($widget_id, 'BDP_Widget_') === 0 || strpos($widget_id, 'blog_designer_pro_widget') !== FALSE) {
                $widget['groups'][] = 'blog_designer';
                $widget['icon'] = 'bdp_icon';
            }
        }
        return $widgets;
    }

    add_filter('siteorigin_panels_widgets', 'siteorigin_panels_add_recommended_widgets_fun');
}

if (is_plugin_active('siteorigin-panels/siteorigin-panels.php')) {
    add_action('admin_enqueue_scripts', 'bdp_suuport_script');

    function bdp_suuport_script() {
        wp_enqueue_style('bdp_support_css', plugins_url('blog-designer-pro/admin/css/bdp_support.css'));
    }

}
