<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
global $wp_version, $wpdb, $bdp_errors, $bdp_success, $bdp_settings;
?>
<div class="wrap">
    <h1>
        <?php
        _e('Edit Single file Override', BLOGDESIGNERPRO_TEXTDOMAIN);
        ?>
    </h1>
    <?php
    if (isset($bdp_errors)) {
        if (is_wp_error($bdp_errors)) {
            ?>
            <div class="error notice">
                <p><?php echo $bdp_errors->get_error_message(); ?></p>
            </div>
            <?php
        }
    }
    if (isset($bdp_success)) {
        ?>
        <div class="updated notice">
            <p><?php echo $bdp_success; ?></p>
        </div>
        <?php
    }
    if (isset($_GET['page']) && $_GET['page'] == 'single_file_override') {
        $allsettings = get_option('bdp_single_file_template');
        if ($allsettings && is_serialized($allsettings)) {
            $bdp_settings = unserialize($allsettings);
        }
        $msg = '&msg=updated';
    }
    ?>
    <form Id="" method="post">
        <?php wp_nonce_field('bdp-singlefile-form-submit', 'bdp-singlefile-submit-nonce'); ?>
        <div class="single_file_override">
            <div class="template template_single">
                <?php
                bdp_admin_singlefile_actions();
                $template_name = BLOGDESIGNERPRO_DIR . 'bdp_templates/single/single.php';
                $template = 'single/single.php';
                $template_file = apply_filters('bdp_locate_core_template', $template_name, $template);
                $local_file = bdp_get_theme_template_file($template);
                $template_dir = apply_filters('bdp_template_directory', 'bdp_templates', $template);
                if (file_exists($local_file)) {
                    ?>
                    <p>
                        <a class="button single_toggle_editor" href="#"><?php _e('Hide template', BLOGDESIGNERPRO_TEXTDOMAIN); ?></a>

                        <?php if (is_writable($local_file)) : ?>
                            <a href="<?php echo esc_url(wp_nonce_url(remove_query_arg(array('move_template', 'saved'), add_query_arg('delete_template', $template)), 'bdp_single_template_nonce', '_bdp_single_nonce')); ?>" class="delete_template button"><?php _e('Delete template file', BLOGDESIGNERPRO_TEXTDOMAIN); ?></a>
                        <?php endif; ?>

                        <?php printf(__('This template has been overridden by your theme and can be found in: <code>%s</code>.', BLOGDESIGNERPRO_TEXTDOMAIN), trailingslashit(basename(get_stylesheet_directory())) . $template_dir . '/' . $template); ?>
                    </p>

                    <div class="single_file_editor" style="display:none">
                        <textarea class="code" cols="25" rows="20" <?php if (!is_writable($local_file)) : ?>readonly="readonly" disabled="disabled"<?php else : ?> name="singlefile_html"<?php endif; ?>><?php echo file_get_contents($local_file); ?></textarea>
                    </div>
                    <p><strong><?php _e('Note', BLOGDESIGNERPRO_TEXTDOMAIN); ?>:</strong> <?php _e('If you have query or face any issue to override single file, Please', BLOGDESIGNERPRO_TEXTDOMAIN); ?> <a href="https://www.solwininfotech.com/product/wordpress-plugins/blog-designer-pro" target="_blank"><?php _e('Click here', BLOGDESIGNERPRO_TEXTDOMAIN); ?></a></p>
                <?php }elseif (file_exists($template_name)) { ?>

                    <p>
                        <a class="button single_toggle_editor" href="#"><?php _e('Hide template', BLOGDESIGNERPRO_TEXTDOMAIN); ?></a>

                        <?php if (( is_dir(get_stylesheet_directory() . '/' . $template_dir . '/') && is_writable(get_stylesheet_directory() . '/' . $template_dir . '/') ) || is_writable(get_stylesheet_directory())) { ?>
                            <a href="<?php echo esc_url(wp_nonce_url(remove_query_arg(array('delete_template', 'saved'), add_query_arg('move_template', $template)), 'bdp_single_template_nonce', '_bdp_single_nonce')); ?>" class="button"><?php _e('Copy file to theme', BLOGDESIGNERPRO_TEXTDOMAIN); ?></a>
                        <?php } ?>
                        <?php printf(__('To override and edit this single template copy <code>%s</code> to your theme folder: <code>%s</code>.', BLOGDESIGNERPRO_TEXTDOMAIN), plugin_basename($template_name), trailingslashit(basename(get_stylesheet_directory())) . $template_dir . '/' . $template); ?>
                    </p>

                    <div class="single_file_editor" style="">
                        <textarea class="code" readonly="readonly" disabled="disabled" cols="25" rows="20"><?php echo file_get_contents($template_name); ?></textarea>
                    </div>
                    <p><strong><?php _e('Note', BLOGDESIGNERPRO_TEXTDOMAIN); ?>:</strong> <?php _e('If you have query or face any issue to override single file, Please', BLOGDESIGNERPRO_TEXTDOMAIN); ?> <a href="https://www.solwininfotech.com/product/wordpress-plugins/blog-designer-pro" target="_blank"><?php _e('Click here', BLOGDESIGNERPRO_TEXTDOMAIN); ?></a></p>
                <?php } ?>
            </div>
        </div>
        <?php if (file_exists($local_file)) { ?>
            <input type="submit" style="" class="button-primary single_file_savebtn" name="savedata"
                   value="<?php esc_attr_e('Save Changes', BLOGDESIGNERPRO_TEXTDOMAIN); ?>" />
        <?php } ?>
    </form>
</div>
<?php
bdp_enqueue_js("
                var view = '" . esc_js(__('View template', BLOGDESIGNERPRO_TEXTDOMAIN)) . "';
                var hide = '" . esc_js(__('Hide template', BLOGDESIGNERPRO_TEXTDOMAIN)) . "';

                jQuery( 'a.single_toggle_editor' ).text( view ).toggle( function() {
                        jQuery( this ).text( hide ).closest( '.template.template_single' ).find( '.single_file_editor' ).slideToggle( 'slow' );
                        return false;
                }, function() {
                        jQuery( this ).text( view ).closest( '.template.template_single' ).find( '.single_file_editor' ).slideToggle( 'slow' );
                        return false;
                } );

                jQuery( 'a.delete_template' ).click( function() {
                        if ( window.confirm('" . esc_js(__('Are you sure you want to delete this template file?', BLOGDESIGNERPRO_TEXTDOMAIN)) . "') ) {
                                return true;
                        }

                        return false;
                });

        ");
