<?php
/**
 * Administration API: Core Ajax handlers
 * @since 1.0
 */
/**
 * Ajax handler to get custom post taxonomy
 */
if (!function_exists('bdp_custom_post_taxonomy')) {

    function bdp_custom_post_taxonomy() {
        ob_start();
        ?>
        <table>
            <tbody>
                <?php
                if (isset($_POST['posttype']) && !empty($_POST['posttype'])) {
                    $custom_posttype = $_POST['posttype'];
                }
                $taxonomy_names = get_object_taxonomies($custom_posttype);
                if (!empty($taxonomy_names)) {
                    foreach ($taxonomy_names as $taxonomy_name) {
                        if (!empty($taxonomy_name)) {
                            $terms = get_terms($taxonomy_name, array('hide_empty' => false));
                            if (!empty($terms)) {
                                ?>
                                <tr class="custom-taxonomy">
                                    <td>
                                        <?php printf(__('Select %s', BLOGDESIGNERPRO_TEXTDOMAIN), $taxonomy_name); ?>
                                    </td>
                                    <td>
                                        <select data-placeholder="Choose <?php echo $taxonomy_name; ?>" multiple style="width:220px;" class="chosen-select custom_post_term" name="<?php echo $taxonomy_name; ?>_terms[]" id="terms_<?php echo $taxonomy_name; ?>"><?php foreach ($terms as $term) { ?>
                                                <option value="<?php echo $term->name; ?>"><?php echo $term->name; ?></option>
                                            <?php } ?>
                                        </select>
                                        <div class="exclude_tag_list_div">
                                            <label>
                                                <input id="exclude_<?php echo $taxonomy_name; ?>_list" name="exclude_<?php echo $taxonomy_name; ?>_list" type="checkbox" value="1" /> <?php echo __('Exclude Selected ', BLOGDESIGNERPRO_TEXTDOMAIN) . $taxonomy_name; ?>
                                            </label>
                                        </div>
                                    </td>
                                </tr>
                                <?php
                            }
                        }
                    }
                }
                if (!empty($taxonomy_names)) {
                    foreach ($taxonomy_names as $taxonomy_name) {
                        if (!empty($taxonomy_name)) {
                            ?>
                            <tr>
                                <td>
                                    <?php _e('Display', BLOGDESIGNERPRO_TEXTDOMAIN); print_r($taxonomy_name); _e('Terms', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </td>
                                <td>
                                    <fieldset class="bdp-social-options bdp-display_tax buttonset">
                                        <input id="display_taxonomy_<?php echo $taxonomy_name; ?>_1" name="display_taxonomy_<?php echo $taxonomy_name; ?>" type="radio" value="1"/>
                                        <label for="display_taxonomy_<?php echo $taxonomy_name; ?>_1"><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        <input id="display_taxonomy_<?php echo $taxonomy_name; ?>_0" name="display_taxonomy_<?php echo $taxonomy_name; ?>" type="radio" value="0" checked=""/>
                                        <label for="display_taxonomy_<?php echo $taxonomy_name; ?>_0"><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                    </fieldset>
                                </td>
                            </tr>
                            <?php
                        }
                    }
                }
                ?>
            </tbody>
        </table><?php
        $data = ob_get_clean();
        echo $data;
        die();
    }

}

/**
 * Get post listing
 */
function bdp_get_posts_single_template() {
    ob_start();
    $tax_ids = isset($_POST['tax_ids']) ? $_POST['tax_ids'] : array();
    $tax = isset($_POST['tax']) ? $_POST['tax'] : '';
    ?>
    <td>
        <?php _e('Select Posts', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
    </td>
    <td>
        <?php
        global $wpdb;
        $db_posts = $wpdb->get_results('SELECT single_post_id FROM ' . $wpdb->prefix . 'bdp_single_layouts');
        $db_posts_list = array();
        if ($db_posts) {
            foreach ($db_posts as $db_post) {
                $sub_list = $db_post->single_post_id;
                if ($sub_list) {
                    $db_post_ids = explode(',', $sub_list);
                    foreach ($db_post_ids as $db_post_id) {
                        $db_posts_list[] = $db_post_id;
                    }
                }
            }
        }
        $final_posts = $db_posts_list;
        if ($tax == 'tag') {
            $args = array('posts_per_page' => -1, 'post_type' => 'post', 'orderby' => 'date', 'order' => 'desc', 'tag__in' => $tax_ids);
        } else if ($tax == 'category') {
            $args = array('posts_per_page' => -1, 'post_type' => 'post', 'orderby' => 'date', 'order' => 'desc', 'category__in' => $tax_ids);
        } else {
            $args = array('posts_per_page' => -1, 'post_type' => 'post', 'orderby' => 'date', 'order' => 'desc');
        }
        $allposts = get_posts($args);
        if ($allposts) {
            ?>
            <select data-placeholder="<?php esc_attr_e('Choose Posts', BLOGDESIGNERPRO_TEXTDOMAIN); ?>" class="chosen-select" multiple style="width:220px;" name="template_posts[]" id="template_posts">
                <?php
                foreach ($allposts as $single_post) : setup_postdata($single_post);
                    ?>
                    <option <?php
                    if (in_array($single_post->ID, $final_posts)) {
                        echo 'disabled="disabled"';
                    }
                    ?> value="<?php echo $single_post->ID; ?>"><?php echo $single_post->post_title; ?></option>
                        <?php
                endforeach;
                wp_reset_postdata();
                ?>
            </select>
            <div class="bdp-setting-description">
                <b class="note"><?php _e('Note:', BLOGDESIGNERPRO_TEXTDOMAIN); ?></b>
                <?php _e('Default All Posts Selected', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
            </div>
            <?php
        } else {
            _e('No posts found', BLOGDESIGNERPRO_TEXTDOMAIN);
        }
        ?>
    </td>
    <?php
    $data = ob_get_clean();
    echo $data;
    die();
}

/**
 * Function for getting post list
 */
function bdp_get_taxonomy_list() {
    ob_start();
    if (isset($_POST['posttype']) && !empty($_POST['posttype'])) {
        $custom_posttype = $_POST['posttype'];
    }
    $taxonomy_names = get_object_taxonomies($custom_posttype);
    $sep = 1;
    if (!empty($taxonomy_names)) {
        foreach ($taxonomy_names as $taxonomy_name) {
            if (!empty($taxonomy_name)) {
                $terms = get_terms($taxonomy_name, array('hide_empty' => false));
                if (!empty($terms)) {

                    if ($sep != 1) {
                        echo ',';
                    } echo $taxonomy_name;
                    $sep++;
                }
            }
        }
    }
    $data = ob_get_clean();
    echo $data;
    die();
}

/**
 * Ajax handler for preview
 */
if (!function_exists('bdp_preview_request')) {

    function bdp_preview_request() {
        if (isset($_POST['settings'])) {
            $bdp_settings = array();
            parse_str($_POST['settings'], $bdp_settings);
            echo bdp_layout_view_portion('', $bdp_settings);
            exit();
        }
    }

}
/*
 * Ajax handler for archive preview
 */
if (!function_exists('bdp_archive_preview_request')) {

    function bdp_archive_preview_request() {
        if (isset($_POST['settings'])) {
            $bdp_settings = array();
            parse_str($_POST['settings'], $bdp_settings);
            $alter_class = '';

            $alter = 1;
            $theme = $bdp_settings['template_name'];
            if (isset($bdp_settings['bdp_blog_order_by'])) {
                $orderby = $bdp_settings['bdp_blog_order_by'];
            }
            if (isset($bdp_settings['firstpost_unique_design']) && $bdp_settings['firstpost_unique_design'] != "") {
                $firstpost_unique_design = $bdp_settings['firstpost_unique_design'];
            } else {
                $firstpost_unique_design = 0;
            }
            ?>
            <div class="blog_template bdp_archive <?php echo $theme; ?>">
                <?php
                if ($theme == "offer_blog") {
                    echo '<div class="bdp_single_offer_blog">';
                }
                if ($theme == "winter") {
                    echo '<div class="bdp_single_winter">';
                }
                if ($bdp_settings['custom_archive_type'] == 'author_template') {
                    $display_author = isset($bdp_settings['display_author_data']) ? $bdp_settings['display_author_data'] : 0;
                    $txtAuthorTitle = isset($bdp_settings['txtAuthorTitle']) ? $bdp_settings['txtAuthorTitle'] : '[author]';
                    $display_author_biography = $bdp_settings['display_author_biography'];
                }
                if ($theme == 'timeline') {
                    if (isset($bdp_settings['bdp_timeline_layout']) && $bdp_settings['bdp_timeline_layout'] == 'left_side') {
                        if (isset($bdp_settings['timeline_display_option']) && $bdp_settings['timeline_display_option'] != '') {
                            echo '<div class="timeline_bg_wrap left_side with_year"><div class="timeline_back clearfix">';
                        } else {
                            echo '<div class="timeline_bg_wrap left_side"><div class="timeline_back clearfix">';
                        }
                    } elseif (isset($bdp_settings['bdp_timeline_layout']) && $bdp_settings['bdp_timeline_layout'] == 'right_side') {
                        if (isset($bdp_settings['timeline_display_option']) && $bdp_settings['timeline_display_option'] != '') {
                            echo '<div class="timeline_bg_wrap right_side with_year"><div class="timeline_back clearfix">';
                        } else {
                            echo '<div class="timeline_bg_wrap right_side"><div class="timeline_back clearfix">';
                        }
                    } else {
                        if ($orderby == 'date' || $orderby == 'modified') {
                            echo '<div class="timeline_bg_wrap date_order"><div class="timeline_back clearfix">';
                        } else {
                            echo '<div class="timeline_bg_wrap"><div class="timeline_back clearfix">';
                        }
                    }
                }
                if ($theme == "boxy" || $theme == "brit_co" || $theme == "glossary" || $theme == "invert-grid") {
                    echo "<div class='bdp-row'>";
                }
                if($theme == "media-grid") {
                    $column_setting = (isset($bdp_settings['column_setting']) && $bdp_settings['column_setting'] != '') ? 'column_layout_'. $bdp_settings['column_setting'] : 'column_layout_2';
                    echo "<div class='bdp-row $column_setting'>";
                }
                if ($theme == 'glossary' || $theme == 'boxy') {
                    echo '<div class="bdp-js-masonry masonry bdp_' . $theme . '">';
                }
                if ($theme == 'boxy-clean') {
                    echo '<div class="blog_template boxy-clean"><ul>';
                }
                $slider_navigation = isset($bdp_settings['select_slider_navigation']) ? $bdp_settings['select_slider_navigation'] : 'navigation1';
                if ($theme == 'crayon_slider') {
                    $unique_id = mt_rand();
                    echo'<div class="blog_template crayon_slider ' . $slider_navigation . ' slider_' . $unique_id . '"><ul class="slides">';
                }
                if ($theme == 'sallet_slider') {
                    $unique_id = mt_rand();
                    echo '<div class="blog_template sallet_slider ' . $slider_navigation . ' slider_' . $unique_id . '"><ul class="slides">';
                }
                if ($theme == 'sunshiny_slider') {
                    $unique_id = mt_rand();
                    echo '<div class="blog_template sunshiny_slider ' . $slider_navigation . ' slider_' . $unique_id . '"><ul class="slides">';
                }
                if ($theme == 'cool_horizontal' || $theme == 'overlay_horizontal') {
                    echo '<div class="logbook flatLine flatNav flatButton">';
                }
                if ($theme == 'easy_timeline') {
                    echo '<div class="blog_template bdp_blog_template easy-timeline-wrapper"><ul class="easy-timeline" data-effect="' . $bdp_settings['easy_timeline_effect'] . '">';
                }
                if ($theme == 'my_diary') {
                    echo '<div class="my_diary_wrapper">';
                }
                global $wp_query;
                $posts_per_page = $bdp_settings['posts_per_page'];
                $orderby = 'date';
                $order = 'DESC';
                if (isset($bdp_settings['bdp_blog_order_by']) && $bdp_settings['bdp_blog_order_by'] != '')
                    $orderby = $bdp_settings['bdp_blog_order_by'];
                if (isset($bdp_settings['bdp_blog_order']) && isset($bdp_settings['bdp_blog_order_by']) && $bdp_settings['bdp_blog_order_by'] != '')
                    $order = $bdp_settings['bdp_blog_order'];
                $paged = bdp_paged();

                if ($bdp_settings['custom_archive_type'] == 'category_template') {
                    if (isset($bdp_settings['template_category'][0])) {
                        $cat = $bdp_settings['template_category'][0];
                    } else {
                        $cat = '';
                    }
                    if ($orderby == 'meta_value_num') {
                        $orderby_str = $orderby . ' date';
                    } else {
                        $orderby_str = $orderby;
                    }
                    $arg_posts = array(
                        'post_type' => 'post',
                        'posts_per_page' => $posts_per_page,
                        'orderby' => $orderby_str,
                        'order' => $order,
                        'paged' => $paged,
                        'post_status' => 'publish',
                        'cat' => $cat
                    );
                    if ($orderby == 'meta_value_num') {
                        $arg_posts['meta_query'] = array(
                            'relation' => 'OR',
                            array(
                                'key' => '_post_like_count',
                                'compare' => 'NOT EXISTS'
                            ),
                            array(
                                'key' => '_post_like_count',
                                'compare' => 'EXISTS'
                            ),
                        );
                    }
                } else if ($bdp_settings['custom_archive_type'] == 'tag_template') {
                    if (isset($bdp_settings['template_tags'][0])) {
                        $tag = $bdp_settings['template_tags'][0];
                    } else {
                        $tag = '';
                    }
                    if ($orderby == 'meta_value_num') {
                        $orderby_str = $orderby . ' date';
                    } else {
                        $orderby_str = $orderby;
                    }
                    $arg_posts = array(
                        'post_type' => 'post',
                        'posts_per_page' => $posts_per_page,
                        'orderby' => $orderby_str,
                        'order' => $order,
                        'paged' => $paged,
                        'post_status' => 'publish',
                        'tag_id' => $tag
                    );
                    if ($orderby == 'meta_value_num') {
                        $arg_posts['meta_query'] = array(
                            'relation' => 'OR',
                            array(
                                'key' => '_post_like_count',
                                'compare' => 'NOT EXISTS'
                            ),
                            array(
                                'key' => '_post_like_count',
                                'compare' => 'EXISTS'
                            ),
                        );
                    }
                } else {
                    if ($orderby == 'meta_value_num') {
                        $orderby_str = $orderby . ' date';
                    } else {
                        $orderby_str = $orderby;
                    }
                    $arg_posts = array(
                        'post_type' => 'post',
                        'posts_per_page' => $posts_per_page,
                        'orderby' => $orderby_str,
                        'order' => $order,
                        'paged' => $paged,
                        'post_status' => 'publish',
                    );
                    if ($orderby == 'meta_value_num') {
                        $arg_posts['meta_query'] = array(
                            'relation' => 'OR',
                            array(
                                'key' => '_post_like_count',
                                'compare' => 'NOT EXISTS'
                            ),
                            array(
                                'key' => '_post_like_count',
                                'compare' => 'EXISTS'
                            ),
                        );
                    }
                }

                if (($orderby == 'date' || $orderby == 'modified') && isset($bdp_settings['template_name']) && ( $bdp_settings['template_name'] == 'story' || $bdp_settings['template_name'] == 'timeline' )) {
                    $posts['ignore_sticky_posts'] = 1;
                }
                if (isset($bdp_settings['template_name']) && ($bdp_settings['template_name'] == 'explore' || $bdp_settings['template_name'] == 'hoverbic')) {
                    $posts['ignore_sticky_posts'] = 1;
                }
                $loop = new WP_Query($arg_posts);
                $temp_query = $wp_query;
                $wp_query = NULL;
                $wp_query = $loop;
                $prev_year1 = null;
                $prev_year = null;
                $alter_val = null;
                if ($loop->have_posts()) {
                    // Start the loop.
                    while (have_posts()) : the_post();
                        if (isset($bdp_settings['template_alternativebackground']) && $bdp_settings['template_alternativebackground'] == 1) {
                            if ($alter % 2 == 0) {
                                $alter_class = ' alternative-back';
                            } else {
                                $alter_class = '';
                            }
                        }
                        if ($theme == 'deport' || $theme == 'navia') {
                            if ($alter % 2 == 0) {
                                $alter_class = 'even_class';
                            } else {
                                $alter_class = '';
                            }
                        }
                        if ($theme == 'invert-grid' || $theme == 'media-grid' || $theme == 'boxy-clean' || $theme == 'story' || $theme == 'explore' || $theme == 'hoverbic') {
                            $alter_class = $alter;
                        }
                        if ($theme) {
                            if ($theme == 'timeline') {
                                if ($orderby == 'date' || $orderby == 'modified') {
                                    if (isset($bdp_settings['timeline_display_option']) && $bdp_settings['timeline_display_option'] == 'display_year') {
                                        $this_year = get_the_date('Y');
                                        if ($prev_year != $this_year) {
                                            $prev_year = $this_year;
                                            echo '<p class="timeline_year"><span class="year_wrap"><span class="only_year">' . $prev_year . '</span></span></p>';
                                        }
                                    } else if (isset($bdp_settings['timeline_display_option']) && $bdp_settings['timeline_display_option'] == 'display_month') {
                                        $this_year = get_the_date('Y');
                                        $this_month = get_the_time('M');
                                        $prev_year = $this_year;
                                        if ($prev_month != $this_month) {
                                            $prev_month = $this_month;
                                            echo '<p class="timeline_year"><span class="year_wrap"><span class="year">' . $this_year . '</span><span class="month">' . $prev_month . '</span></span></p>';
                                        }
                                    }
                                }
                            }
                            if ($theme == 'story') {
                                if ($orderby == 'date' || $orderby == 'modified') {
                                    $this_year = get_the_date('Y');
                                    if ($prev_year1 != $this_year) {
                                        $prev_year1 = $this_year;
                                        $prev_year = 0;
                                    } elseif ($prev_year1 == $this_year) {
                                        $prev_year = 1;
                                    }
                                } else {
                                    $prev_year = get_the_date('Y');
                                }
                            }
                            if($theme == 'media-grid') {
                                $alter_val = $alter;
                            }
                            if ($theme == 'invert-grid' || $theme == 'boxy-clean' || $theme == 'news' || $theme == 'deport' || $theme == 'navia') {
                                if ($firstpost_unique_design == 1) {
                                    $alter_val = $alter;
                                    if (1 == $paged) {
                                        if ($alter == 1) {
                                            $prev_year = 0;
                                        } else {
                                            $prev_year = 1;
                                        }
                                    } else {
                                        $prev_year = 1;
                                    }
                                }
                                if($theme == 'media-grid') {
                                    $column_setting = (isset($bdp_settings['column_setting']) && $bdp_settings['column_setting'] != '') ? $bdp_settings['column_setting'] : 2;
                                    $alter_val = $alter;
                                    if (1 == $paged) {
                                        if($column_setting >= 2 && $alter <= 2) {
                                            $prev_year = 0;
                                        } else {
                                            if ($alter == 1) {
                                                $prev_year = 0;
                                            } else {
                                                $prev_year = 1;
                                            }                                    
                                        }
                                    } else {
                                        $prev_year = 1;
                                    }
                                }
                            }
                        }
                        // Include the single post content template.
                        bdp_get_template('archive/' . $theme . '.php');
                        do_action('bd_archive_design_format_function', $bdp_settings, $alter_class, $prev_year, $alter_val, $paged);
                        $alter ++;
                    // End of the loop.
                    endwhile;
                    if ($theme == 'boxy-clean' || $theme == 'crayon_slider' || $theme == 'sallet_slider' || $theme == 'sunshiny_slider' || $theme == 'easy_timeline') {
                        echo "</ul></div>";
                    }
                    if ($theme == 'cool_horizontal' || $theme == 'overlay_horizontal' || $theme == 'my_diary' || $theme == 'glossary' || $theme == 'boxy') {
                        echo '</div>';
                    }
                    if ($theme == "boxy" || $theme == "brit_co" || $theme == "glossary" || $theme == "invert-grid") {
                        echo "</div>";
                    }
                    if($theme == "media-grid" || $theme == "offer_blog" || $theme == "winter") {
                        echo "</div>";
                    }
                    if ($theme == 'timeline') {
                        echo '</div>
                                </div>';
                    }
                    $slider_array = array('crayon_slider', 'sunshiny_slider', 'sallet_slider');
                    if (in_array($theme, $slider_array)) {
                        $template_slider_scroll = isset($bdp_settings['template_slider_scroll']) ? $bdp_settings['template_slider_scroll'] : 1;
                        $display_slider_navigation = isset($bdp_settings['display_slider_navigation']) ? $bdp_settings['display_slider_navigation'] : 1;
                        $display_slider_controls = isset($bdp_settings['display_slider_controls']) ? $bdp_settings['display_slider_controls'] : 1;
                        $slider_autoplay = isset($bdp_settings['slider_autoplay']) ? $bdp_settings['slider_autoplay'] : 1;
                        $slider_autoplay_intervals = isset($bdp_settings['slider_autoplay_intervals']) ? $bdp_settings['slider_autoplay_intervals'] : 7000;
                        $slider_speed = isset($bdp_settings['slider_speed']) ? $bdp_settings['slider_speed'] : 600;
                        $template_slider_effect = isset($bdp_settings['template_slider_effect']) ? $bdp_settings['template_slider_effect'] : 'slide';
                        $slider_column = isset($bdp_settings['template_slider_columns']) ? $bdp_settings['template_slider_columns'] : 1;
                        $select_slider_control = isset($bdp_settings['select_slider_control']) ? $bdp_settings['select_slider_control'] : 'control1';
                        if ($select_slider_control == '') {
                            $prev = "<i class='fa fa-chevron-left'></i>";
                            $next = "<i class='fa fa-chevron-right'></i>";
                        } else {
                            $prev = "<div class='" . $select_slider_control . "'></div>";
                            $next = "<div class='" . $select_slider_control . "'></div>";
                        }
                        ?>
                        <script type="text/javascript">
                            jQuery(document).ready(function () {
                                jQuery('.slider_' + <?php echo $unique_id; ?>).flexslider({
                                    move: <?php echo $template_slider_scroll; ?>,
                                    animation: '<?php echo $template_slider_effect; ?>',
                                    itemWidth: 210,
                                    itemMargin: 15,
                                    minItems: 1,
                                    maxItems: <?php echo $slider_column; ?>,
                                    <?php if ($display_slider_navigation) { ?>
                                        directionNav: true,
                                    <?php } else { ?>
                                        directionNav: false,
                                    <?php } ?>
                                    <?php if ($display_slider_controls) { ?>
                                        controlNav: true,
                                    <?php } else { ?>
                                        controlNav: false,
                                    <?php } ?>
                                    <?php if ($slider_autoplay) { ?>
                                        slideshow: true,
                                    <?php } else { ?>
                                        slideshow: false,
                                    <?php } ?>
                                    <?php if ($slider_autoplay) { ?>
                                        slideshowSpeed: <?php echo $slider_autoplay_intervals; ?>,
                                    <?php } ?>
                                    <?php if ($slider_speed) { ?>
                                        animationSpeed: <?php echo $slider_speed; ?>,
                                    <?php } ?>
                                    prevText: "<?php echo $prev; ?>",
                                    nextText: "<?php echo $next; ?>"
                                });
                            });
                        </script>
                        <?php
                    }
                    if (!in_array($theme, $slider_array) && isset($bdp_settings['pagination_type']) && $bdp_settings['pagination_type'] != 'no_pagination') {
                        echo '<div class="wl_pagination_box">';
                        echo bdp_standard_paging_nav();
                        echo '</div>';
                    }
                } else {
                    _e('No posts found', BLOGDESIGNERPRO_TEXTDOMAIN);
                }
                wp_reset_query();
                $wp_query = NULL;
                $wp_query = $temp_query;
                ?>
            </div>
            <?php
        }
        exit();
    }

}


/**
 * Ajax handler for Store closed box id
 */
if (!function_exists('bdp_closed_bdpboxes')) {

    function bdp_closed_bdpboxes() {

        $closed = isset($_POST['closed']) ? explode(',', $_POST['closed']) : array();
        $closed = array_filter($closed);

        $page = isset($_POST['page']) ? $_POST['page'] : '';

        if ($page != sanitize_key($page))
            wp_die(0);

        if (!$user = wp_get_current_user())
            wp_die(-1);

        if (is_array($closed))
            update_user_option($user->ID, "bdpclosedbdpboxes_$page", $closed, true);

        wp_die(1);
    }

}