/**************************************************************************************************
 *
 * ADOBE SYSTEMS INCORPORATED
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the
 * terms of the Adobe license agreement accompanying it.  If you have received this file from a
 * source other than Adobe, then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 *
 **************************************************************************************************/
/*jslint node: true, vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50, unparam: true, regexp: true */
/*global define, console */

'use strict';

var osx = require('./osx').init();
var utils = require('./utils');

utils.setLogger(function (level, message) {
    process.send({
        log: {
            level: level,
            message: message
        }
    });
});

// Fetch the certificates and send them back to the parent process
// Since we're in a different process, this can be killed if it hangs
var certs = osx.getRootCAUnsafe();
process.send({
    certs: certs
});
