<?php include(VIEW_ROOT.'/front/beta/partials/breadcrumb.php'); ?>

<div class="section-account-alpha-container">
    <div class="container">
        <div class="row">
            <div class="col-md-3">
                <div class="section-account-alpha-navigation">
                    <?php include(VIEW_ROOT.'/front/beta/partials/account-sidebar.php'); ?>
                </div>
            </div>
            <div class="col-md-9">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="table-responsive">
                        <table class="table section-account-alpha-table">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col"><?php echo lang('job'); ?></th>
                                    <th scope="col"><?php echo lang('department'); ?></th>
                                    <th scope="col"><?php echo lang('status'); ?></th>
                                    <th scope="col"><?php echo lang('applied_on'); ?> </th>
                                    <th scope="col"><?php echo lang('details'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($jobs) { ?>
                                <?php foreach ($jobs as $key => $job) { ?>
                                <tr>
                                    <td><?php echo esc_output($key + 1); ?></td>
                                    <td><?php echo esc_output($job['title']); ?></td>
                                    <td><?php echo esc_output($job['department']) ? esc_output($job['department']) : '---'; ?></td>
                                    <td><?php echo esc_output($job['job_status']); ?></td>
                                    <td><?php echo $job['applied_on'] ? date('d M, Y', strtotime($job['applied_on'])) : '---'; ?></td>
                                    <td>
                                        <?php $id = $job['slug'] ? $job['slug'] : encode($job['job_id']); ?>
                                        <a href="<?php echo base_url(); ?>job/<?php echo esc_output($id); ?>">
                                            <?php echo lang('view'); ?>
                                        </a>
                                        <?php if (setting('enable-delete-application-feature-for-candidate') == 'yes') { ?>
                                        <a 
                                            href="#" 
                                            class="delete-job-application" 
                                            data-id="<?php echo encode($job['job_id']); ?>"
                                            data-app_id="<?php echo encode($job['job_application_id']); ?>">
                                             | <?php echo lang('delete'); ?>
                                        </a>
                                        <?php } ?>
                                    </td>
                                </tr>
                                <?php } ?>
                                <?php } else { ?>
                                <tr>
                                    <td colspan="7"><?php echo lang('no_record_found'); ?></td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include(VIEW_ROOT.'/front/beta/layout/footer.php'); ?>