<?php

class AdminTemplateModel extends CI_Model
{
    protected $table = 'templates';
    protected $key = 'template_id';

    public function getTemplate($column, $value)
    {
        $this->db->where($column, $value);
        $this->db->where('status', 1);
        $result = $this->db->get('templates');
        return ($result->num_rows() == 1) ? objToArr($result->row(0)) : $this->emptyObject('templates');
    }

    public function updateTemplates($data)
    {
        foreach ($data as $k => $d) {
            $this->db->where('title', $k);
            $this->db->update('templates', array('content' => $d));
        }
    }

    public function getAll($title = '')
    {
        $this->db->from($this->table);
        $query = $this->db->get();
        $result = $query->result();
        $sorted = array();
        foreach ($result as $value) {
            $sorted[$value->title] = $value->content;
        }
        return $title ? $sorted[$title] : $sorted;
    }

}