<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Templates extends CI_Controller
{
    /**
     * Constructor
     * 
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->checkAdminLogin();
    }

    /**
     * View Function to display email templates page view
     *
     * @return html/string
     */
    public function index()
    {
        $data['page'] = lang('templates');
        $data['menu'] = 'templates';
        $data['tl'] = $this->AdminTemplateModel->getAll();
        $this->load->view('admin/layout/header', $data);
        $this->load->view('admin/settings/templates', $data);
    }

    /**
     * Function (for ajax) to process templates update form request
     *
     * @return redirect
     */
    public function save()
    {
        $data = $this->xssCleanInput();

        //Validating templates for reserved words
        $validations = $this->validateTemplates($data);
        if ($validations) {
            die(json_encode(array(
                'success' => 'error',
                'messages' => $this->ajaxErrorMessage(array('error' => $validations))
            )));
        }

        $this->AdminTemplateModel->updateTemplates($data);

        echo json_encode(array(
            'success' => 'true',
            'messages' => $this->ajaxErrorMessage(array('success' => lang('templates').' '.lang('updated')))
        ));
    }

    private function validateTemplates($data)
    {
        $errors = '';
        $reserved_words = array(
            'candidate_interview_notification' => array("[candidate]", "[interview_time]", "[message]"),
            'team_member_interview_notification' => array("[user]", "[interview_time]", "[description]"),
            'candidate_quiz_notification' => array("[candidate]"),
            'candidate_job_application_notification' => array("[candidate]", "[job]", "[job_detail_link]"),
            'candidate_verification_email' => array("[candidate]", "[activation_link]", "[hr]"),
            'candidate_signup' => array("[candidate]", "[activation_link]"),
            'candidate_signup_notification' => array("[candidate_name]", "[candidate_email]"),
            'candidate_forgot_password' => array("[candidate]", "[password_reset_link]"),
            'candidate_refer_job' => array("[user]", "[friend]", "[job_link]"),
        );

        foreach ($data as $key => $value) {
            $template_essentials = $reserved_words[$key];
            $error = false;
            foreach ($template_essentials as $te) {
                if (str_contains($value, $te) !== true) {
                    $errors .= 'Template : '.lang($key).' must have reserved word ('.$te.')<br />';
                }
            }
        }
        return $errors;
    }
}
